/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.session.SessionState;

class SessionExpirationTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SessionExpirationTracker.class);
    private static final Random rdm = new Random();
    private final PriorityBlockingQueue<TezSessionPoolSession> expirationQueue;
    private final BlockingQueue<TezSessionPoolSession> restartQueue;
    private final Thread expirationThread;
    private final Thread restartThread;
    private final long sessionLifetimeMs;
    private final long sessionLifetimeJitterMs;
    private final RestartImpl sessionRestartImpl;
    private volatile SessionState initSessionState;

    public static SessionExpirationTracker create(HiveConf conf, RestartImpl restartImpl) {
        long sessionLifetimeMs = conf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_LIFETIME, TimeUnit.MILLISECONDS);
        if (sessionLifetimeMs == 0L) {
            return null;
        }
        return new SessionExpirationTracker(sessionLifetimeMs, conf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_LIFETIME_JITTER, TimeUnit.MILLISECONDS), restartImpl);
    }

    private SessionExpirationTracker(long sessionLifetimeMs, long sessionLifetimeJitterMs, RestartImpl restartImpl) {
        this.sessionRestartImpl = restartImpl;
        this.sessionLifetimeMs = sessionLifetimeMs;
        this.sessionLifetimeJitterMs = sessionLifetimeJitterMs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session expiration is enabled; session lifetime is " + sessionLifetimeMs + " + [0, " + sessionLifetimeJitterMs + ") ms");
        }
        this.expirationQueue = new PriorityBlockingQueue<TezSessionPoolSession>(11, new Comparator<TezSessionPoolSession>(){

            @Override
            public int compare(TezSessionPoolSession o1, TezSessionPoolSession o2) {
                assert (o1.getExpirationNs() != null && o2.getExpirationNs() != null);
                return o1.getExpirationNs().compareTo(o2.getExpirationNs());
            }
        });
        this.restartQueue = new LinkedBlockingQueue<TezSessionPoolSession>();
        this.expirationThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionState.setCurrentSessionState(SessionExpirationTracker.this.initSessionState);
                    SessionExpirationTracker.this.runExpirationThread();
                }
                catch (Exception e) {
                    LOG.warn("Exception in TezSessionPool-expiration thread. Thread will shut down", e);
                }
                finally {
                    LOG.info("TezSessionPool-expiration thread exiting");
                }
            }
        }, "TezSessionPool-expiration");
        this.restartThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionState.setCurrentSessionState(SessionExpirationTracker.this.initSessionState);
                    SessionExpirationTracker.this.runRestartThread();
                }
                catch (Exception e) {
                    LOG.warn("Exception in TezSessionPool-cleanup thread. Thread will shut down", e);
                }
                finally {
                    LOG.info("TezSessionPool-cleanup thread exiting");
                }
            }
        }, "TezSessionPool-cleanup");
    }

    private void runRestartThread() {
        block5: while (true) {
            try {
                while (true) {
                    TezSessionPoolSession next = this.restartQueue.take();
                    LOG.info("Restarting the expired session [" + next + "]");
                    try {
                        this.sessionRestartImpl.closeAndReopenExpiredSession(next);
                        continue block5;
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to close or restart a session, ignoring", e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.info("Restart thread is exiting due to an interruption");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runExpirationThread() {
        try {
            while (true) {
                TezSessionPoolSession nextToExpire;
                block18: {
                    nextToExpire = null;
                    while (true) {
                        block17: {
                            nextToExpire = this.expirationQueue.take();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Seeing if we can expire [" + nextToExpire + "]");
                            }
                            try {
                                if (!nextToExpire.tryExpire(false)) {
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                LOG.error("Failed to expire session " + nextToExpire + "; ignoring", e);
                                nextToExpire = null;
                            }
                            if (nextToExpire != null) {
                                break;
                            }
                            break block18;
                        }
                        LOG.info("Tez session [" + nextToExpire + "] has expired");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[" + nextToExpire + "] is not ready to expire; adding it back");
                    }
                }
                PriorityBlockingQueue<TezSessionPoolSession> priorityBlockingQueue = this.expirationQueue;
                synchronized (priorityBlockingQueue) {
                    if (nextToExpire != null) {
                        this.expirationQueue.add(nextToExpire);
                    }
                    if ((nextToExpire = this.expirationQueue.peek()) != null) {
                        long timeToWaitMs = (nextToExpire.getExpirationNs() - System.nanoTime()) / 1000000L;
                        timeToWaitMs = Math.max(1L, timeToWaitMs + 10L);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Waiting for ~" + timeToWaitMs + "ms to expire [" + nextToExpire + "]");
                        }
                        this.expirationQueue.wait(timeToWaitMs);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Expiration queue is empty");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.info("Expiration thread is exiting due to an interruption");
            return;
        }
    }

    public void start() {
        this.initSessionState = SessionState.get();
        this.expirationThread.start();
        this.restartThread.start();
    }

    public void stop() {
        if (this.expirationThread != null) {
            this.expirationThread.interrupt();
        }
        if (this.restartThread != null) {
            this.restartThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToExpirationQueue(TezSessionPoolSession session) {
        long jitterModMs = (long)((float)this.sessionLifetimeJitterMs * rdm.nextFloat());
        session.setExpirationNs(System.nanoTime() + (this.sessionLifetimeMs + jitterModMs) * 1000000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding a pool session [" + this + "] to expiration queue");
        }
        PriorityBlockingQueue<TezSessionPoolSession> priorityBlockingQueue = this.expirationQueue;
        synchronized (priorityBlockingQueue) {
            this.expirationQueue.add(session);
            this.expirationQueue.notifyAll();
        }
    }

    public void removeFromExpirationQueue(TezSessionPoolSession session) {
        this.expirationQueue.remove(session);
    }

    public void closeAndRestartExpiredSessionAsync(TezSessionPoolSession session) {
        this.restartQueue.add(session);
    }

    public void closeAndRestartExpiredSession(TezSessionPoolSession session) throws Exception {
        this.sessionRestartImpl.closeAndReopenExpiredSession(session);
    }

    static interface RestartImpl {
        public void closeAndReopenExpiredSession(TezSessionPoolSession var1) throws Exception;
    }
}

