/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import java.util.Arrays;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes32;
import org.apache.tuweni.bytes.MutableBytes;

class MutableArrayWrappingBytes
extends ArrayWrappingBytes
implements MutableBytes {
    MutableArrayWrappingBytes(byte[] bytes) {
        super(bytes);
    }

    MutableArrayWrappingBytes(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public void set(int i, byte b) {
        Checks.checkElementIndex(i, this.length);
        this.bytes[this.offset + i] = b;
    }

    @Override
    public void set(int i, Bytes b) {
        byte[] bytesArray = b.toArrayUnsafe();
        System.arraycopy(bytesArray, 0, this.bytes, this.offset + i, bytesArray.length);
    }

    @Override
    public MutableBytes increment() {
        for (int i = this.length - 1; i >= this.offset; --i) {
            if (this.bytes[i] != -1) {
                int n = i;
                this.bytes[n] = (byte)(this.bytes[n] + 1);
                break;
            }
            this.bytes[i] = 0;
        }
        return this;
    }

    @Override
    public MutableBytes decrement() {
        for (int i = this.length - 1; i >= this.offset; --i) {
            if (this.bytes[i] != 0) {
                int n = i;
                this.bytes[n] = (byte)(this.bytes[n] - 1);
                break;
            }
            this.bytes[i] = -1;
        }
        return this;
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        Checks.checkElementIndex(i, this.length);
        Checks.checkArgument(i + length <= this.length, "Specified length %s is too large: the value has size %s and has only %s bytes from %s", length, this.length, this.length - i, i);
        return length == 32 ? new MutableArrayWrappingBytes32(this.bytes, this.offset + i) : new MutableArrayWrappingBytes(this.bytes, this.offset + i, length);
    }

    @Override
    public void fill(byte b) {
        Arrays.fill(this.bytes, this.offset, this.offset + this.length, b);
    }

    @Override
    public Bytes copy() {
        return new ArrayWrappingBytes(this.toArray());
    }

    @Override
    public int hashCode() {
        return this.computeHashcode();
    }
}

