/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser;

import android.util.Xml;
import io.ticofab.androidgpxparser.parser.domain.Gpx;
import io.ticofab.androidgpxparser.parser.domain.Link;
import io.ticofab.androidgpxparser.parser.domain.Point;
import io.ticofab.androidgpxparser.parser.domain.Route;
import io.ticofab.androidgpxparser.parser.domain.RoutePoint;
import io.ticofab.androidgpxparser.parser.domain.Track;
import io.ticofab.androidgpxparser.parser.domain.TrackPoint;
import io.ticofab.androidgpxparser.parser.domain.TrackSegment;
import io.ticofab.androidgpxparser.parser.domain.WayPoint;
import io.ticofab.androidgpxparser.parser.task.FetchAndParseGPXTask;
import io.ticofab.androidgpxparser.parser.task.GpxFetchedAndParsed;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GPXParser {
    private static final String TAG_GPX = "gpx";
    private static final String TAG_TRACK = "trk";
    private static final String TAG_SEGMENT = "trkseg";
    private static final String TAG_TRACK_POINT = "trkpt";
    private static final String TAG_LAT = "lat";
    private static final String TAG_LON = "lon";
    private static final String TAG_ELEVATION = "ele";
    private static final String TAG_TIME = "time";
    private static final String TAG_WAY_POINT = "wpt";
    private static final String TAG_ROUTE = "rte";
    private static final String TAG_ROUTE_POINT = "rtept";
    private static final String TAG_NAME = "name";
    private static final String TAG_DESC = "desc";
    private static final String TAG_CMT = "cmt";
    private static final String TAG_SRC = "src";
    private static final String TAG_LINK = "link";
    private static final String TAG_NUMBER = "number";
    private static final String TAG_TYPE = "type";
    private static final String TAG_TEXT = "text";
    private static final String ns = null;

    public void parse(String gpxUrl, GpxFetchedAndParsed listener) {
        new FetchAndParseGPXTask(gpxUrl, listener).execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gpx parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(in, null);
            parser.nextTag();
            Gpx gpx = this.readGpx(parser);
            return gpx;
        }
        finally {
            in.close();
        }
    }

    private Gpx readGpx(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<WayPoint> wayPoints = new ArrayList<WayPoint>();
        ArrayList<Track> tracks = new ArrayList<Track>();
        ArrayList<Route> routes = new ArrayList<Route>();
        parser.require(2, ns, TAG_GPX);
        block10: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "wpt": {
                    wayPoints.add(this.readWayPoint(parser));
                    continue block10;
                }
                case "rte": {
                    routes.add(this.readRoute(parser));
                    continue block10;
                }
                case "trk": {
                    tracks.add(this.readTrack(parser));
                    continue block10;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_GPX);
        return new Gpx.Builder().setWayPoints(wayPoints).setRoutes(routes).setTracks(tracks).build();
    }

    private Track readTrack(XmlPullParser parser) throws XmlPullParserException, IOException {
        Track.Builder trackBuilder = new Track.Builder();
        ArrayList<TrackSegment> segments = new ArrayList<TrackSegment>();
        parser.require(2, ns, TAG_TRACK);
        block20: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "name": {
                    trackBuilder.setTrackName(this.readName(parser));
                    continue block20;
                }
                case "trkseg": {
                    segments.add(this.readSegment(parser));
                    continue block20;
                }
                case "desc": {
                    trackBuilder.setTrackDesc(this.readDesc(parser));
                    continue block20;
                }
                case "cmt": {
                    trackBuilder.setTrackCmt(this.readCmt(parser));
                    continue block20;
                }
                case "src": {
                    trackBuilder.setTrackSrc(this.readString(parser, TAG_SRC));
                    continue block20;
                }
                case "link": {
                    trackBuilder.setTrackLink(this.readLink(parser));
                    continue block20;
                }
                case "number": {
                    trackBuilder.setTrackNumber(this.readNumber(parser));
                    continue block20;
                }
                case "type": {
                    trackBuilder.setTrackType(this.readString(parser, TAG_TYPE));
                    continue block20;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_TRACK);
        return trackBuilder.setTrackSegments(segments).build();
    }

    private Link readLink(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_LINK);
        Link.Builder linkBuilder = new Link.Builder();
        block8: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "text": {
                    linkBuilder.setLinkText(this.readString(parser, TAG_TEXT));
                    continue block8;
                }
                case "type": {
                    linkBuilder.setLinkType(this.readString(parser, TAG_TYPE));
                    continue block8;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_LINK);
        return linkBuilder.build();
    }

    private TrackSegment readSegment(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<TrackPoint> points = new ArrayList<TrackPoint>();
        parser.require(2, ns, TAG_SEGMENT);
        block6: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "trkpt": {
                    points.add(this.readTrackPoint(parser));
                    continue block6;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_SEGMENT);
        return new TrackSegment.Builder().setTrackPoints(points).build();
    }

    private Route readRoute(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<RoutePoint> points = new ArrayList<RoutePoint>();
        parser.require(2, ns, TAG_ROUTE);
        Route.Builder routeBuilder = new Route.Builder();
        block20: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "rtept": {
                    points.add(this.readRoutePoint(parser));
                    continue block20;
                }
                case "name": {
                    routeBuilder.setRouteName(this.readName(parser));
                    continue block20;
                }
                case "desc": {
                    routeBuilder.setRouteDesc(this.readDesc(parser));
                    continue block20;
                }
                case "cmt": {
                    routeBuilder.setRouteCmt(this.readCmt(parser));
                    continue block20;
                }
                case "src": {
                    routeBuilder.setRouteSrc(this.readString(parser, TAG_SRC));
                    continue block20;
                }
                case "link": {
                    routeBuilder.setRouteLink(this.readLink(parser));
                    continue block20;
                }
                case "number": {
                    routeBuilder.setRouteNumber(this.readNumber(parser));
                    continue block20;
                }
                case "type": {
                    routeBuilder.setRouteType(this.readString(parser, TAG_TYPE));
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_ROUTE);
        return routeBuilder.setRoutePoints(points).build();
    }

    private Point readPoint(Point.Builder builder, XmlPullParser parser, String tagName) throws XmlPullParserException, IOException {
        parser.require(2, ns, tagName);
        builder.setLatitude(Double.valueOf(parser.getAttributeValue(null, TAG_LAT)));
        builder.setLongitude(Double.valueOf(parser.getAttributeValue(null, TAG_LON)));
        block10: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "name": {
                    builder.setName(this.readName(parser));
                    continue block10;
                }
                case "ele": {
                    builder.setElevation(this.readElevation(parser));
                    continue block10;
                }
                case "time": {
                    builder.setTime(this.readTime(parser));
                    continue block10;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, tagName);
        return builder.build();
    }

    private WayPoint readWayPoint(XmlPullParser parser) throws XmlPullParserException, IOException {
        return (WayPoint)this.readPoint(new WayPoint.Builder(), parser, TAG_WAY_POINT);
    }

    private TrackPoint readTrackPoint(XmlPullParser parser) throws IOException, XmlPullParserException {
        return (TrackPoint)this.readPoint(new TrackPoint.Builder(), parser, TAG_TRACK_POINT);
    }

    private RoutePoint readRoutePoint(XmlPullParser parser) throws IOException, XmlPullParserException {
        return (RoutePoint)this.readPoint(new RoutePoint.Builder(), parser, TAG_ROUTE_POINT);
    }

    private String readName(XmlPullParser parser) throws IOException, XmlPullParserException {
        return this.readString(parser, TAG_NAME);
    }

    private String readDesc(XmlPullParser parser) throws IOException, XmlPullParserException {
        return this.readString(parser, TAG_DESC);
    }

    private String readCmt(XmlPullParser parser) throws IOException, XmlPullParserException {
        return this.readString(parser, TAG_CMT);
    }

    private String readString(XmlPullParser parser, String tag) throws IOException, XmlPullParserException {
        parser.require(2, ns, tag);
        String value = this.readText(parser);
        parser.require(3, ns, tag);
        return value;
    }

    private Double readElevation(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_ELEVATION);
        Double ele = Double.valueOf(this.readText(parser));
        parser.require(3, ns, TAG_ELEVATION);
        return ele;
    }

    private DateTime readTime(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_TIME);
        DateTime time = ISODateTimeFormat.dateTimeParser().parseDateTime(this.readText(parser));
        parser.require(3, ns, TAG_TIME);
        return time;
    }

    private String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == 4) {
            result = parser.getText();
            parser.nextTag();
        }
        return result;
    }

    private Integer readNumber(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_NUMBER);
        Integer number = Integer.valueOf(this.readText(parser));
        parser.require(3, ns, TAG_NUMBER);
        return number;
    }

    private void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }
}

