/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.domain;

import io.ticofab.androidgpxparser.parser.domain.TrackSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Track {
    private final String mTrackName;
    private final List<TrackSegment> mTrackSegments;

    private Track(Builder builder) {
        this.mTrackName = builder.mTrackName;
        this.mTrackSegments = Collections.unmodifiableList(new ArrayList(builder.mTrackSegments));
    }

    public String getTrackName() {
        return this.mTrackName;
    }

    public List<TrackSegment> getTrackSegments() {
        return this.mTrackSegments;
    }

    public static class Builder {
        private String mTrackName;
        private List<TrackSegment> mTrackSegments;

        public Builder setTrackName(String trackName) {
            this.mTrackName = trackName;
            return this;
        }

        public Builder setTrackSegments(List<TrackSegment> trackSegments) {
            this.mTrackSegments = trackSegments;
            return this;
        }

        public Track build() {
            return new Track(this);
        }
    }
}

