/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.task;

import android.os.AsyncTask;
import io.ticofab.androidgpxparser.parser.GPXParser;
import io.ticofab.androidgpxparser.parser.domain.Gpx;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.xmlpull.v1.XmlPullParserException;

public class FetchAndParseGpxTask
extends AsyncTask<Void, Void, Gpx> {
    final String mGpxUrl;
    final GpxFetchedAndParsed mListener;
    final GPXParser mParser = new GPXParser();

    public FetchAndParseGpxTask(String gpxUrl, GpxFetchedAndParsed listener) {
        this.mGpxUrl = gpxUrl;
        this.mListener = listener;
    }

    protected Gpx doInBackground(Void ... unused) {
        Gpx parsedGpx = null;
        try {
            URL url = new URL(this.mGpxUrl);
            HttpURLConnection client = (HttpURLConnection)url.openConnection();
            BufferedInputStream in = new BufferedInputStream(client.getInputStream());
            parsedGpx = this.mParser.parse(in);
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        return parsedGpx;
    }

    protected void onPostExecute(Gpx gpx) {
        this.mListener.onGpxFetchedAndParsed(gpx);
    }

    public static interface GpxFetchedAndParsed {
        public void onGpxFetchedAndParsed(Gpx var1);
    }
}

