/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.DependencyLocation;
import org.wildfly.swarm.plugin.maven.migrate.MavenUtils;
import org.wildfly.swarm.plugin.maven.migrate.MigrateWildFlySwarmDependency;
import org.wildfly.swarm.plugin.maven.migrate.MigrateWildFlySwarmDependencyExclusion;
import org.wildfly.swarm.plugin.maven.migrate.MigrateWildFlySwarmPlugin;
import org.wildfly.swarm.plugin.maven.migrate.MigrateWildFlySwarmVersionProperty;
import org.wildfly.swarm.plugin.maven.migrate.MigrationAction;
import org.wildfly.swarm.plugin.maven.migrate.PluginLocation;
import org.wildfly.swarm.plugin.maven.migrate.ProfileLocation;
import org.xml.sax.SAXException;

@Mojo(name="migrate-from-wildfly-swarm", aggregator=true, requiresDirectInvocation=true)
public class MigrationMojo
extends AbstractMojo {
    @Parameter(property="targetVersion")
    private String targetVersion;
    @Parameter(property="dryRun", defaultValue="false")
    private boolean dryRun;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    private Path rootDir;

    public void execute() throws MojoExecutionException {
        this.findTargetVersion();
        this.rootDir = Paths.get(".", new String[0]);
        try {
            Set<Path> pomXmls = this.findPomXmls(this.rootDir);
            HashSet<MigrationAction> migrationActions = new HashSet<MigrationAction>();
            for (Path pomXml : pomXmls) {
                migrationActions.addAll(this.prepareMigrationActions(pomXml));
            }
            List sortedMigrationActions = migrationActions.stream().sorted(Comparator.comparing(MigrationAction::describe)).collect(Collectors.toList());
            for (MigrationAction migrationAction : sortedMigrationActions) {
                this.getLog().info((CharSequence)migrationAction.describe());
                if (this.dryRun) continue;
                migrationAction.execute();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void findTargetVersion() {
        if (this.targetVersion == null || this.targetVersion.isEmpty()) {
            this.targetVersion = this.mojo.getPlugin().getVersion();
        }
        this.getLog().info((CharSequence)("Upgrading to Thorntail " + this.targetVersion));
    }

    private Set<Path> findPomXmls(Path rootDir) throws IOException {
        try (Stream<Path> pomXmls = Files.walk(rootDir, new FileVisitOption[0]);){
            Set<Path> set = pomXmls.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> "pom.xml".equals(p.getFileName().toString())).collect(Collectors.toSet());
            return set;
        }
    }

    private Set<MigrationAction> prepareMigrationActions(Path pomXml) throws IOException, SAXException, ParserConfigurationException {
        Match pom = MavenUtils.parsePomXml(pomXml);
        HashSet<MigrationAction> result = new HashSet<MigrationAction>();
        Match nonProfile = pom.xpath("/m:project");
        result.addAll(this.prepareMigrationActionsForProfile(pomXml, nonProfile, ProfileLocation.none()));
        pom.xpath("/m:project/m:profiles/m:profile").each(profile -> result.addAll(this.prepareMigrationActionsForProfile(pomXml, MavenUtils.$$(profile), ProfileLocation.profile(JOOX.$((Context)profile)))));
        return result;
    }

    private Set<MigrationAction> prepareMigrationActionsForProfile(Path pomXml, Match profile, ProfileLocation profileLocation) {
        HashSet<MigrationAction> result = new HashSet<MigrationAction>();
        Match dependencies = profile.xpath("m:dependencies/m:dependency");
        result.addAll(this.prepareMigrationActionsForDependencies(pomXml, dependencies, dependency -> DependencyLocation.dependencies(PluginLocation.none(profileLocation), dependency)));
        Match dependencyManagement = profile.xpath("m:dependencyManagement/m:dependencies/m:dependency");
        result.addAll(this.prepareMigrationActionsForDependencies(pomXml, dependencyManagement, dependency -> DependencyLocation.dependencyManagement(PluginLocation.none(profileLocation), dependency)));
        Match plugins = profile.xpath("m:build/m:plugins/m:plugin");
        result.addAll(this.prepareMigrationActionsForPlugins(pomXml, plugins, plugin -> PluginLocation.plugins(profileLocation, plugin)));
        Match pluginManagement = profile.xpath("m:build/m:pluginManagement/m:plugins/m:plugin");
        result.addAll(this.prepareMigrationActionsForPlugins(pomXml, pluginManagement, plugin -> PluginLocation.pluginManagement(profileLocation, plugin)));
        return result;
    }

    private Set<MigrationAction> prepareMigrationActionsForDependencies(Path pomXml, Match dependencies, Function<Match, DependencyLocation> locator) {
        HashSet<MigrationAction> result = new HashSet<MigrationAction>();
        dependencies.each(dependency -> {
            String groupId = JOOX.$((Context)dependency).child("groupId").text();
            String version = JOOX.$((Context)dependency).child("version").text();
            if (MigrationMojo.isWildFlySwarmGroupId(groupId)) {
                result.add(new MigrateWildFlySwarmDependency(pomXml, (DependencyLocation)locator.apply(JOOX.$((Context)dependency)), this.targetThorntailVersion(version)));
                if (MavenUtils.refersToProperty(version)) {
                    for (String property : MavenUtils.propertyNamesReferredFrom(version)) {
                        result.add(new MigrateWildFlySwarmVersionProperty(this.rootDir, property, this.targetVersion));
                    }
                }
            }
            JOOX.$((Context)dependency).find("exclusion").each(exclusion -> {
                String exclusionGroupId = JOOX.$((Context)exclusion).child("groupId").text();
                String exclusionArtifactId = JOOX.$((Context)exclusion).child("artifactId").text();
                if (MigrationMojo.isWildFlySwarmGroupId(exclusionGroupId)) {
                    result.add(new MigrateWildFlySwarmDependencyExclusion(pomXml, (DependencyLocation)locator.apply(JOOX.$((Context)dependency)), exclusionGroupId, exclusionArtifactId));
                }
            });
        });
        return result;
    }

    private Set<MigrationAction> prepareMigrationActionsForPlugins(Path pomXml, Match plugins, Function<Match, PluginLocation> locator) {
        HashSet<MigrationAction> result = new HashSet<MigrationAction>();
        plugins.each(plugin -> {
            String groupId = JOOX.$((Context)plugin).child("groupId").text();
            String artifactId = JOOX.$((Context)plugin).child("artifactId").text();
            String version = JOOX.$((Context)plugin).child("version").text();
            if (MigrationMojo.isWildFlySwarmGroupId(groupId) && "wildfly-swarm-plugin".equals(artifactId)) {
                result.add(new MigrateWildFlySwarmPlugin(pomXml, (PluginLocation)locator.apply(JOOX.$((Context)plugin)), this.targetThorntailVersion(version)));
                if (MavenUtils.refersToProperty(version)) {
                    for (String property : MavenUtils.propertyNamesReferredFrom(version)) {
                        result.add(new MigrateWildFlySwarmVersionProperty(this.rootDir, property, this.targetVersion));
                    }
                }
            }
            Function<Match, DependencyLocation> dependencyLocator = dependency -> DependencyLocation.dependencies((PluginLocation)locator.apply(JOOX.$((Context)plugin)), dependency);
            result.addAll(this.prepareMigrationActionsForDependencies(pomXml, JOOX.$((Context)plugin).find("dependency"), dependencyLocator));
        });
        return result;
    }

    private String targetThorntailVersion(String currentWildFlySwarmVersion) {
        if (currentWildFlySwarmVersion == null || MavenUtils.refersToProperty(currentWildFlySwarmVersion)) {
            return null;
        }
        return this.targetVersion;
    }

    private static boolean isWildFlySwarmGroupId(String groupId) {
        return "org.wildfly.swarm".equals(groupId);
    }
}

