/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.nio.file.Path;
import java.util.Objects;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.MavenUtils;
import org.wildfly.swarm.plugin.maven.migrate.MigrationAction;
import org.wildfly.swarm.plugin.maven.migrate.PluginLocation;

final class MigrateWildFlySwarmPlugin
implements MigrationAction {
    private final Path pomXml;
    private final PluginLocation location;
    private final String targetVersion;

    public MigrateWildFlySwarmPlugin(Path pomXml, PluginLocation location, String targetVersion) {
        this.pomXml = pomXml;
        this.location = location;
        this.targetVersion = targetVersion;
    }

    @Override
    public String describe() {
        return this.pomXml + ": migrate " + this.location + " (target version: " + this.targetVersion + ")";
    }

    @Override
    public void execute() throws Exception {
        Match pom = MavenUtils.parsePomXml(this.pomXml);
        this.location.find(pom).each(plugin -> {
            JOOX.$((Context)plugin).child("groupId").text("io.thorntail");
            JOOX.$((Context)plugin).child("artifactId").text("thorntail-maven-plugin");
            if (this.targetVersion != null) {
                JOOX.$((Context)plugin).child("version").text(this.targetVersion);
            }
        });
        MavenUtils.writePomXml(this.pomXml, pom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrateWildFlySwarmPlugin)) {
            return false;
        }
        MigrateWildFlySwarmPlugin that = (MigrateWildFlySwarmPlugin)o;
        return Objects.equals(this.pomXml, that.pomXml) && Objects.equals(this.location, that.location) && Objects.equals(this.targetVersion, that.targetVersion);
    }

    public int hashCode() {
        return Objects.hash(this.pomXml, this.location, this.targetVersion);
    }
}

