/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.nio.file.Path;
import java.util.Objects;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.DependencyLocation;
import org.wildfly.swarm.plugin.maven.migrate.MavenUtils;
import org.wildfly.swarm.plugin.maven.migrate.MigrationAction;

final class MigrateWildFlySwarmDependency
implements MigrationAction {
    private final Path pomXml;
    private final DependencyLocation location;
    private final String targetVersion;

    MigrateWildFlySwarmDependency(Path pomXml, DependencyLocation location, String targetVersion) {
        this.pomXml = pomXml;
        this.location = location;
        this.targetVersion = targetVersion;
    }

    @Override
    public String describe() {
        return this.pomXml + ": migrate " + this.location + " (target version: " + this.targetVersion + ")";
    }

    @Override
    public void execute() throws Exception {
        Match pom = MavenUtils.parsePomXml(this.pomXml);
        this.location.find(pom).each(dependency -> {
            JOOX.$((Context)dependency).child("groupId").text("io.thorntail");
            if (this.targetVersion != null) {
                JOOX.$((Context)dependency).child("version").text(this.targetVersion);
            }
        });
        MavenUtils.writePomXml(this.pomXml, pom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrateWildFlySwarmDependency)) {
            return false;
        }
        MigrateWildFlySwarmDependency that = (MigrateWildFlySwarmDependency)o;
        return Objects.equals(this.pomXml, that.pomXml) && Objects.equals(this.location, that.location) && Objects.equals(this.targetVersion, that.targetVersion);
    }

    public int hashCode() {
        return Objects.hash(this.pomXml, this.location, this.targetVersion);
    }
}

