/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import io.grpc.Context;
import io.temporal.api.testservice.v1.LockTimeSkippingRequest;
import io.temporal.api.testservice.v1.TestServiceGrpc;
import io.temporal.api.testservice.v1.UnlockTimeSkippingRequest;
import io.temporal.serviceclient.TestServiceStubs;
import java.util.concurrent.atomic.AtomicInteger;

class IdempotentTimeLocker {
    private final TestServiceStubs testServiceStubs;
    private final AtomicInteger count = new AtomicInteger(0);

    IdempotentTimeLocker(TestServiceStubs testServiceStubs) {
        this.testServiceStubs = testServiceStubs;
    }

    public void lockTimeSkipping() {
        int newCount = this.count.incrementAndGet();
        if (newCount == 0 || newCount == 1) {
            Context.ROOT.run(() -> ((TestServiceGrpc.TestServiceBlockingStub)this.testServiceStubs.blockingStub()).lockTimeSkipping(LockTimeSkippingRequest.newBuilder().build()));
        }
    }

    public void unlockTimeSkipping() {
        int newCount = this.count.decrementAndGet();
        if (newCount == 0 || newCount == -1) {
            Context.ROOT.run(() -> ((TestServiceGrpc.TestServiceBlockingStub)this.testServiceStubs.blockingStub()).unlockTimeSkipping(UnlockTimeSkippingRequest.newBuilder().build()));
        }
    }
}

