/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.docker;

import com.google.protobuf.util.Durations;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.workflowservice.v1.DescribeNamespaceResponse;
import io.temporal.api.workflowservice.v1.ListNamespacesRequest;
import io.temporal.api.workflowservice.v1.ListNamespacesResponse;
import io.temporal.api.workflowservice.v1.RegisterNamespaceRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;

public class RegisterTestNamespace {
    public static final String NAMESPACE = "UnitTest";
    private static final boolean useDockerService = Boolean.parseBoolean(System.getenv("USE_DOCKER_SERVICE"));
    private static final String serviceAddress = System.getenv("TEMPORAL_SERVICE_ADDRESS");

    public static void main(String[] args) throws InterruptedException {
        if (!useDockerService) {
            return;
        }
        WorkflowServiceStubsOptions.Builder options = WorkflowServiceStubsOptions.newBuilder();
        if (serviceAddress != null) {
            options.setTarget(serviceAddress);
        }
        WorkflowServiceStubs service = null;
        try {
            service = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)options.build());
            if (RegisterTestNamespace.doesNamespaceExist(service)) {
                System.out.println("Namespace UnitTest already exists");
            } else {
                RegisterTestNamespace.registerNamespace(service);
                RegisterTestNamespace.waitForNamespace(service);
            }
            System.exit(0);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        System.exit(0);
    }

    private static void registerNamespace(WorkflowServiceStubs service) throws InterruptedException {
        RegisterNamespaceRequest request = RegisterNamespaceRequest.newBuilder().setNamespace(NAMESPACE).setWorkflowExecutionRetentionPeriod(Durations.fromDays((long)1L)).build();
        while (true) {
            try {
                ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).registerNamespace(request);
                System.out.println("Namespace UnitTest registered");
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.ALREADY_EXISTS) {
                    System.out.println("Namespace UnitTest already exists");
                    break;
                }
                if (e.getStatus().getCode() != Status.Code.DEADLINE_EXCEEDED && e.getStatus().getCode() != Status.Code.UNAVAILABLE) continue;
                e.printStackTrace();
                Thread.sleep(500L);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private static void waitForNamespace(WorkflowServiceStubs service) throws InterruptedException {
        System.out.println("Waiting for the namespace propagation...");
        Thread.sleep(10000L);
    }

    private static boolean doesNamespaceExist(WorkflowServiceStubs service) {
        ListNamespacesRequest request = ListNamespacesRequest.newBuilder().build();
        ListNamespacesResponse listNamespacesResponse = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).listNamespaces(request);
        for (DescribeNamespaceResponse namespaceResponse : listNamespacesResponse.getNamespacesList()) {
            if (!namespaceResponse.getNamespaceInfo().getName().equals(NAMESPACE)) continue;
            return true;
        }
        return false;
    }
}

