/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

class TaskQueue<E> {
    private final LinkedList<E> backlog = new LinkedList();
    private final LinkedList<PollFuture> waiters = new LinkedList();

    TaskQueue() {
    }

    synchronized void add(E element) {
        PollFuture future = this.waiters.poll();
        while (future != null) {
            if (future.set(element)) {
                return;
            }
            future = this.waiters.pop();
        }
        this.backlog.push(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Future<E> poll() {
        E element;
        PollFuture future = new PollFuture();
        TaskQueue taskQueue = this;
        synchronized (taskQueue) {
            if (this.backlog.isEmpty()) {
                this.waiters.push(future);
                return future;
            }
            element = this.backlog.pop();
        }
        future.set(element);
        return future;
    }

    private class PollFuture
    implements Future<E> {
        boolean cancelled = false;
        E value;

        private PollFuture() {
        }

        private synchronized boolean set(E element) {
            Preconditions.checkState((this.value == null ? 1 : 0) != 0);
            if (this.cancelled) {
                return false;
            }
            this.value = element;
            this.notifyAll();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean ignored) {
            Object object = TaskQueue.this;
            synchronized (object) {
                TaskQueue.this.waiters.remove(this);
            }
            object = this;
            synchronized (object) {
                if (this.value != null) {
                    return false;
                }
                this.cancelled = true;
                this.notifyAll();
                return true;
            }
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public synchronized boolean isDone() {
            return this.value != null;
        }

        @Override
        public synchronized E get() throws InterruptedException, ExecutionException {
            while (this.value == null && !this.cancelled) {
                this.wait();
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            return this.value;
        }

        @Override
        public synchronized E get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            while (this.value == null && !this.cancelled) {
                unit.timedWait(this, timeout);
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            return this.value;
        }
    }
}

