/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.WorkflowThreadContext;

public class PotentialDeadlockException
extends RuntimeException {
    private final WorkflowThreadContext workflowThreadContext;
    private final long detectionTimestamp;
    private String triggerThreadStackTrace;
    private String otherThreadsDump;
    private long threadDumpTimestamp;

    PotentialDeadlockException(String threadName, WorkflowThreadContext workflowThreadContext, long detectionTimestamp) {
        super("Potential deadlock detected. Workflow thread \"" + threadName + "\" didn't yield control for over a second.");
        this.workflowThreadContext = workflowThreadContext;
        this.detectionTimestamp = detectionTimestamp;
    }

    void setStackDump(String triggerThreadStackTrace, String otherThreadsDump, long threadDumpTimestamp) {
        this.triggerThreadStackTrace = triggerThreadStackTrace;
        this.otherThreadsDump = otherThreadsDump;
        this.threadDumpTimestamp = threadDumpTimestamp;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " {" + "detectionTimestamp=" + this.detectionTimestamp + ", threadDumpTimestamp=" + this.threadDumpTimestamp + "} \n\n" + this.triggerThreadStackTrace + (!this.otherThreadsDump.isEmpty() ? "\n Other workflow threads: [\n" + this.otherThreadsDump + "]\n" : "");
    }

    public WorkflowThreadContext getWorkflowThreadContext() {
        return this.workflowThreadContext;
    }
}

