/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.replay.WorkflowHistoryIterator;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.time.Duration;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ServiceWorkflowHistoryIterator
implements WorkflowHistoryIterator {
    private final Duration retryServiceOperationInitialInterval = Duration.ofMillis(200L);
    private final Duration retryServiceOperationMaxInterval = Duration.ofSeconds(4L);
    public final WorkflowServiceStubs service;
    private final String namespace;
    private final Scope metricsScope;
    private final PollWorkflowTaskQueueResponseOrBuilder task;
    private final GrpcRetryer grpcRetryer;
    private Deadline deadline;
    private Iterator<HistoryEvent> current;
    ByteString nextPageToken;

    ServiceWorkflowHistoryIterator(WorkflowServiceStubs service, String namespace, PollWorkflowTaskQueueResponseOrBuilder task, Scope metricsScope) {
        this.service = service;
        this.namespace = namespace;
        this.task = task;
        this.metricsScope = metricsScope;
        this.grpcRetryer = service != null ? new GrpcRetryer(service.getServerCapabilities()) : null;
        History history = task.getHistory();
        this.current = history.getEventsList().iterator();
        this.nextPageToken = task.getNextPageToken();
    }

    @Override
    public boolean hasNext() {
        if (this.current.hasNext()) {
            return true;
        }
        if (this.nextPageToken.isEmpty()) {
            return false;
        }
        GetWorkflowExecutionHistoryResponse response = this.queryWorkflowExecutionHistory();
        this.current = response.getHistory().getEventsList().iterator();
        this.nextPageToken = response.getNextPageToken();
        return this.current.hasNext();
    }

    @Override
    public HistoryEvent next() {
        if (this.hasNext()) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void initDeadline(Deadline deadline) {
        this.deadline = deadline;
    }

    GetWorkflowExecutionHistoryResponse queryWorkflowExecutionHistory() {
        RpcRetryOptions retryOptions = RpcRetryOptions.newBuilder().setInitialInterval(this.retryServiceOperationInitialInterval).setMaximumInterval(this.retryServiceOperationMaxInterval).validateBuildWithDefaults();
        GrpcRetryer.GrpcRetryerOptions grpcRetryerOptions = new GrpcRetryer.GrpcRetryerOptions(retryOptions, this.deadline);
        GetWorkflowExecutionHistoryRequest request = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.namespace).setExecution(this.task.getWorkflowExecution()).setNextPageToken(this.nextPageToken).build();
        try {
            return (GetWorkflowExecutionHistoryResponse)this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).getWorkflowExecutionHistory(request), grpcRetryerOptions);
        }
        catch (StatusRuntimeException ex) {
            if (Status.DEADLINE_EXCEEDED.equals((Object)ex.getStatus())) {
                throw Status.DEADLINE_EXCEEDED.withDescription("getWorkflowExecutionHistory pagination took longer than workflow task timeout").withCause((Throwable)ex).asRuntimeException();
            }
            throw ex;
        }
    }
}

