/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequestOrBuilder;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.internal.client.EagerWorkflowTaskDispatcher;
import io.temporal.internal.client.WorkerFactoryRegistry;
import io.temporal.internal.client.WorkflowClientLongPollAsyncHelper;
import io.temporal.internal.client.WorkflowClientLongPollHelper;
import io.temporal.internal.client.WorkflowClientRequestFactory;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.payload.context.WorkflowSerializationContext;
import io.temporal.worker.WorkflowTaskDispatchHandle;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootWorkflowClientInvoker
implements WorkflowClientCallsInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RootWorkflowClientInvoker.class);
    private final GenericWorkflowClient genericClient;
    private final WorkflowClientOptions clientOptions;
    private final EagerWorkflowTaskDispatcher eagerWorkflowTaskDispatcher;
    private final WorkflowClientRequestFactory requestsHelper;

    public RootWorkflowClientInvoker(GenericWorkflowClient genericClient, WorkflowClientOptions clientOptions, WorkerFactoryRegistry workerFactoryRegistry) {
        this.genericClient = genericClient;
        this.clientOptions = clientOptions;
        this.eagerWorkflowTaskDispatcher = new EagerWorkflowTaskDispatcher(workerFactoryRegistry);
        this.requestsHelper = new WorkflowClientRequestFactory(clientOptions);
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowStartOutput start(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowId()));
        Optional<Payloads> inputArgs = dataConverterWithWorkflowContext.toPayloads(input.getArguments());
        Memo memo = input.getOptions().getMemo() != null ? Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(this.clientOptions.getDataConverter(), input.getOptions().getMemo())).build() : null;
        StartWorkflowExecutionRequest.Builder request = this.requestsHelper.newStartWorkflowExecutionRequest(input.getWorkflowId(), input.getWorkflowType(), input.getHeader(), input.getOptions(), inputArgs.orElse(null), memo);
        try (WorkflowTaskDispatchHandle eagerDispatchHandle = this.obtainDispatchHandle(input);){
            PollWorkflowTaskQueueResponse eagerWorkflowTask;
            boolean requestEagerExecution = eagerDispatchHandle != null;
            request.setRequestEagerExecution(requestEagerExecution);
            StartWorkflowExecutionResponse response = this.genericClient.start(request.build());
            WorkflowExecution execution = WorkflowExecution.newBuilder().setRunId(response.getRunId()).setWorkflowId(request.getWorkflowId()).build();
            PollWorkflowTaskQueueResponse pollWorkflowTaskQueueResponse = eagerWorkflowTask = requestEagerExecution && response.hasEagerWorkflowTask() ? response.getEagerWorkflowTask() : null;
            if (eagerWorkflowTask != null) {
                try {
                    eagerDispatchHandle.dispatch(eagerWorkflowTask);
                }
                catch (Exception e) {
                    log.error("[BUG] Eager Workflow Task was received from the Server, but failed to be dispatched on the local worker", (Throwable)e);
                }
            }
            WorkflowClientCallsInterceptor.WorkflowStartOutput workflowStartOutput = new WorkflowClientCallsInterceptor.WorkflowStartOutput(execution);
            return workflowStartOutput;
        }
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowSignalOutput signal(WorkflowClientCallsInterceptor.WorkflowSignalInput input) {
        SignalWorkflowExecutionRequest.Builder request = SignalWorkflowExecutionRequest.newBuilder().setSignalName(input.getSignalName()).setWorkflowExecution(input.getWorkflowExecution()).setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace());
        DataConverter dataConverterWitSignalContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> inputArgs = dataConverterWitSignalContext.toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((SignalWorkflowExecutionRequest.Builder)request).setInput(arg_0));
        this.genericClient.signal(request.build());
        return new WorkflowClientCallsInterceptor.WorkflowSignalOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput signalWithStart(WorkflowClientCallsInterceptor.WorkflowSignalWithStartInput input) {
        WorkflowClientCallsInterceptor.WorkflowStartInput workflowStartInput = input.getWorkflowStartInput();
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), workflowStartInput.getWorkflowId()));
        Optional<Payloads> workflowInput = dataConverterWithWorkflowContext.toPayloads(workflowStartInput.getArguments());
        Memo memo = workflowStartInput.getOptions().getMemo() != null ? Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(this.clientOptions.getDataConverter(), workflowStartInput.getOptions().getMemo())).build() : null;
        StartWorkflowExecutionRequest.Builder startRequest = this.requestsHelper.newStartWorkflowExecutionRequest(workflowStartInput.getWorkflowId(), workflowStartInput.getWorkflowType(), workflowStartInput.getHeader(), workflowStartInput.getOptions(), workflowInput.orElse(null), memo);
        Optional<Payloads> signalInput = dataConverterWithWorkflowContext.toPayloads(input.getSignalArguments());
        SignalWithStartWorkflowExecutionRequest request = this.requestsHelper.newSignalWithStartWorkflowExecutionRequest((StartWorkflowExecutionRequestOrBuilder)startRequest, input.getSignalName(), signalInput.orElse(null)).build();
        SignalWithStartWorkflowExecutionResponse response = this.genericClient.signalWithStart(request);
        WorkflowExecution execution = WorkflowExecution.newBuilder().setRunId(response.getRunId()).setWorkflowId(request.getWorkflowId()).build();
        return new WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput(new WorkflowClientCallsInterceptor.WorkflowStartOutput(execution));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.GetResultOutput<R> getResult(WorkflowClientCallsInterceptor.GetResultInput<R> input) throws TimeoutException {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> resultValue = WorkflowClientLongPollHelper.getWorkflowExecutionResult(this.genericClient, this.requestsHelper, input.getWorkflowExecution(), input.getWorkflowType(), dataConverterWithWorkflowContext, input.getTimeout(), input.getTimeoutUnit());
        return new WorkflowClientCallsInterceptor.GetResultOutput<R>(RootWorkflowClientInvoker.convertResultPayloads(resultValue, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.GetResultAsyncOutput<R> getResultAsync(WorkflowClientCallsInterceptor.GetResultInput<R> input) {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        CompletableFuture<Optional<Payloads>> resultValue = WorkflowClientLongPollAsyncHelper.getWorkflowExecutionResultAsync(this.genericClient, this.requestsHelper, input.getWorkflowExecution(), input.getWorkflowType(), input.getTimeout(), input.getTimeoutUnit(), dataConverterWithWorkflowContext);
        return new WorkflowClientCallsInterceptor.GetResultAsyncOutput(resultValue.thenApply(payloads -> RootWorkflowClientInvoker.convertResultPayloads(payloads, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext)));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.QueryOutput<R> query(WorkflowClientCallsInterceptor.QueryInput<R> input) {
        WorkflowQuery.Builder query = WorkflowQuery.newBuilder().setQueryType(input.getQueryType());
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> inputArgs = dataConverterWithWorkflowContext.toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((WorkflowQuery.Builder)query).setQueryArgs(arg_0));
        QueryWorkflowRequest request = QueryWorkflowRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setExecution(WorkflowExecution.newBuilder().setWorkflowId(input.getWorkflowExecution().getWorkflowId()).setRunId(input.getWorkflowExecution().getRunId())).setQuery(query).setQueryRejectCondition(this.clientOptions.getQueryRejectCondition()).build();
        QueryWorkflowResponse result = this.genericClient.query(request);
        boolean queryRejected = result.hasQueryRejected();
        WorkflowExecutionStatus rejectStatus = queryRejected ? result.getQueryRejected().getStatus() : null;
        Optional<Payloads> queryResult = result.hasQueryResult() ? Optional.of(result.getQueryResult()) : Optional.empty();
        R resultValue = RootWorkflowClientInvoker.convertResultPayloads(queryResult, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext);
        return new WorkflowClientCallsInterceptor.QueryOutput<R>(rejectStatus, resultValue);
    }

    @Override
    public WorkflowClientCallsInterceptor.CancelOutput cancel(WorkflowClientCallsInterceptor.CancelInput input) {
        RequestCancelWorkflowExecutionRequest.Builder request = RequestCancelWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowExecution(input.getWorkflowExecution()).setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity());
        this.genericClient.requestCancel(request.build());
        return new WorkflowClientCallsInterceptor.CancelOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.TerminateOutput terminate(WorkflowClientCallsInterceptor.TerminateInput input) {
        TerminateWorkflowExecutionRequest.Builder request = TerminateWorkflowExecutionRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setWorkflowExecution(input.getWorkflowExecution());
        if (input.getReason() != null) {
            request.setReason(input.getReason());
        }
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> payloads = dataConverterWithWorkflowContext.toPayloads(input.getDetails());
        payloads.ifPresent(arg_0 -> ((TerminateWorkflowExecutionRequest.Builder)request).setDetails(arg_0));
        this.genericClient.terminate(request.build());
        return new WorkflowClientCallsInterceptor.TerminateOutput();
    }

    private static <R> R convertResultPayloads(Optional<Payloads> resultValue, Class<R> resultClass, Type resultType, DataConverter dataConverter) {
        return dataConverter.fromPayloads(0, resultValue, resultClass, resultType);
    }

    @Nullable
    private WorkflowTaskDispatchHandle obtainDispatchHandle(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        if (input.getOptions().isDisableEagerExecution()) {
            return null;
        }
        return this.eagerWorkflowTaskDispatcher.tryGetLocalDispatchHandler(input);
    }
}

