/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.activity.DynamicActivity;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.client.ActivityCanceledException;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.metadata.POJOActivityImplMetadata;
import io.temporal.common.metadata.POJOActivityMethodMetadata;
import io.temporal.internal.activity.ActivityExecutionContextFactory;
import io.temporal.internal.activity.ActivityInfoImpl;
import io.temporal.internal.activity.ActivityInfoInternal;
import io.temporal.internal.activity.ActivityTaskExecutors;
import io.temporal.internal.common.env.ReflectionUtils;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.worker.TypeAlreadyRegisteredException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ActivityTaskHandlerImpl
implements ActivityTaskHandler {
    public static final ImmutableSet<String> ACTIVITY_HANDLER_STACKTRACE_CUTOFF = ImmutableSet.builder().add((Object)ReflectionUtils.getMethodNameForStackTraceCutoff(ActivityTaskExecutors.POJOActivityImplementation.class, "execute", ActivityInfoInternal.class, Scope.class)).add((Object)ReflectionUtils.getMethodNameForStackTraceCutoff(ActivityTaskExecutors.DynamicActivityImplementation.class, "execute", ActivityInfoInternal.class, Scope.class)).build();
    private final DataConverter dataConverter;
    private final String namespace;
    private final String taskQueue;
    private final ActivityExecutionContextFactory executionContextFactory;
    private final Map<String, ActivityTaskExecutors.ActivityTaskExecutor> activities = Collections.synchronizedMap(new HashMap());
    private ActivityTaskExecutors.ActivityTaskExecutor dynamicActivity;
    private final WorkerInterceptor[] interceptors;
    private final List<ContextPropagator> contextPropagators;

    public ActivityTaskHandlerImpl(@Nonnull String namespace, @Nonnull String taskQueue, @Nonnull DataConverter dataConverter, @Nonnull ActivityExecutionContextFactory executionContextFactory, @Nonnull WorkerInterceptor[] interceptors, @Nullable List<ContextPropagator> contextPropagators) {
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.executionContextFactory = Objects.requireNonNull(executionContextFactory);
        this.interceptors = Objects.requireNonNull(interceptors);
        this.contextPropagators = contextPropagators;
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.activities.isEmpty() || this.dynamicActivity != null;
    }

    @Override
    public boolean isTypeSupported(String type) {
        return this.activities.get(type) != null || this.dynamicActivity != null;
    }

    public void registerActivityImplementations(Object[] activitiesImplementation) {
        for (Object activity : activitiesImplementation) {
            this.registerActivityImplementation(activity);
        }
    }

    @Override
    public ActivityTaskHandler.Result handle(ActivityTask activityTask, Scope metricsScope, boolean localActivity) {
        PollActivityTaskQueueResponseOrBuilder pollResponse = activityTask.getResponse();
        String activityType = pollResponse.getActivityType().getName();
        ActivityInfoImpl activityInfo = new ActivityInfoImpl(pollResponse, this.namespace, this.taskQueue, localActivity, activityTask.getCompletionCallback());
        ActivityTaskExecutors.ActivityTaskExecutor activity = this.activities.get(activityType);
        if (activity != null) {
            return activity.execute(activityInfo, metricsScope);
        }
        if (this.dynamicActivity != null) {
            return this.dynamicActivity.execute(activityInfo, metricsScope);
        }
        try {
            String knownTypes = Joiner.on((String)", ").join(this.activities.keySet());
            throw new IllegalArgumentException("Activity Type \"" + activityType + "\" is not registered with a worker. Known types are: " + knownTypes);
        }
        catch (Exception exception) {
            return ActivityTaskHandlerImpl.mapToActivityFailure(exception, pollResponse.getActivityId(), metricsScope, localActivity, this.dataConverter);
        }
    }

    private void registerActivityImplementation(Object activity) {
        if (activity instanceof Class) {
            throw new IllegalArgumentException("Activity object instance expected, not the class");
        }
        if (activity instanceof DynamicActivity) {
            if (this.dynamicActivity != null) {
                throw new TypeAlreadyRegisteredException("DynamicActivity", "An implementation of DynamicActivity is already registered with the worker");
            }
            this.dynamicActivity = new ActivityTaskExecutors.DynamicActivityImplementation((DynamicActivity)activity, this.dataConverter, this.contextPropagators, this.interceptors, this.executionContextFactory);
        } else {
            Class<?> cls = activity.getClass();
            POJOActivityImplMetadata activityImplMetadata = POJOActivityImplMetadata.newInstance(cls);
            for (POJOActivityMethodMetadata activityMetadata : activityImplMetadata.getActivityMethods()) {
                String typeName = activityMetadata.getActivityTypeName();
                if (this.activities.containsKey(typeName)) {
                    throw new TypeAlreadyRegisteredException(typeName, "\"" + typeName + "\" activity type is already registered with the worker");
                }
                Method method = activityMetadata.getMethod();
                ActivityTaskExecutors.POJOActivityImplementation implementation = new ActivityTaskExecutors.POJOActivityImplementation(method, activity, this.dataConverter, this.contextPropagators, this.interceptors, this.executionContextFactory);
                this.activities.put(typeName, implementation);
            }
        }
    }

    static ActivityTaskHandler.Result mapToActivityFailure(Throwable exception, String activityId, Scope metricsScope, boolean isLocalActivity, DataConverter dataConverter) {
        if (exception instanceof ActivityCanceledException) {
            if (isLocalActivity) {
                metricsScope.counter("temporal_local_activity_execution_cancelled").inc(1L);
                metricsScope.counter("temporal_local_activity_canceled").inc(1L);
            } else {
                metricsScope.counter("temporal_activity_execution_cancelled").inc(1L);
                metricsScope.counter("temporal_activity_canceled").inc(1L);
            }
            return new ActivityTaskHandler.Result(activityId, null, null, RespondActivityTaskCanceledRequest.newBuilder().build(), false);
        }
        Scope ms = metricsScope.tagged((Map)ImmutableMap.of((Object)"exception", (Object)exception.getClass().getSimpleName()));
        if (isLocalActivity) {
            ms.counter("temporal_local_activity_execution_failed").inc(1L);
            ms.counter("temporal_local_activity_failed").inc(1L);
        } else {
            ms.counter("temporal_activity_execution_failed").inc(1L);
        }
        Failure failure = dataConverter.exceptionToFailure(exception);
        RespondActivityTaskFailedRequest.Builder result = RespondActivityTaskFailedRequest.newBuilder().setFailure(failure);
        return new ActivityTaskHandler.Result(activityId, null, new ActivityTaskHandler.Result.TaskFailedResult(result.build(), exception), null, false);
    }
}

