/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.EncodingKeys;
import io.temporal.common.converter.PayloadConverter;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;

public final class GsonJsonPayloadConverter
implements PayloadConverter {
    private static final PayloadConverter INSTANCE = new GsonJsonPayloadConverter();
    private final Gson gson;

    public static PayloadConverter getInstance() {
        return INSTANCE;
    }

    public GsonJsonPayloadConverter() {
        this(b -> b);
    }

    public GsonJsonPayloadConverter(Function<GsonBuilder, GsonBuilder> builderInterceptor) {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        GsonBuilder intercepted = builderInterceptor.apply(gsonBuilder);
        this.gson = intercepted.create();
    }

    @Override
    public String getEncodingType() {
        return "json/plain";
    }

    @Override
    public Optional<Payload> toData(Object value) throws DataConverterException {
        try {
            String json = this.gson.toJson(value);
            return Optional.of(Payload.newBuilder().putMetadata("encoding", EncodingKeys.METADATA_ENCODING_JSON).setData(ByteString.copyFrom((String)json, (Charset)StandardCharsets.UTF_8)).build());
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromData(Payload content, Class<T> valueClass, Type valueType) throws DataConverterException {
        if (content == null) {
            return null;
        }
        ByteString data = content.getData();
        if (data.isEmpty()) {
            return null;
        }
        try {
            String json = data.toString(StandardCharsets.UTF_8);
            return (T)this.gson.fromJson(json, valueType);
        }
        catch (Exception e) {
            throw new DataConverterException(content, new Type[]{valueType}, (Throwable)e);
        }
    }
}

