/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.WorkflowId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

final class ActivityId {
    private final ExecutionId executionId;
    private final long scheduledEventId;

    ActivityId(String namespace, WorkflowExecution execution, long scheduledEventId) {
        this.executionId = new ExecutionId(Objects.requireNonNull(namespace), Objects.requireNonNull(execution));
        this.scheduledEventId = scheduledEventId;
    }

    ActivityId(String namespace, String workflowId, String runId, long scheduledEventId) {
        this(namespace, WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId).build(), scheduledEventId);
    }

    public ActivityId(ExecutionId executionId, long scheduledEventId) {
        this.executionId = executionId;
        this.scheduledEventId = scheduledEventId;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public long getScheduledEventId() {
        return this.scheduledEventId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityId that = (ActivityId)o;
        return this.scheduledEventId == that.scheduledEventId && com.google.common.base.Objects.equal((Object)this.executionId, (Object)that.executionId);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.executionId, this.scheduledEventId});
    }

    public String toString() {
        return "ActivityId{executionId=" + this.executionId + ", scheduledEventId=" + this.scheduledEventId + '}';
    }

    public ByteString toBytes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeUTF(this.executionId.getNamespace());
            WorkflowExecution execution = this.executionId.getExecution();
            out.writeUTF(execution.getWorkflowId());
            out.writeUTF(execution.getRunId());
            out.writeLong(this.scheduledEventId);
            return ByteString.copyFrom((byte[])bout.toByteArray());
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    static ActivityId fromBytes(ByteString serialized) {
        return ActivityId.fromBytes(serialized.toByteArray());
    }

    static ActivityId fromBytes(byte[] serialized) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(bin);
        try {
            String namespace = in.readUTF();
            String workflowId = in.readUTF();
            String runId = in.readUTF();
            long scheduledEventId = in.readLong();
            return new ActivityId(namespace, workflowId, runId, scheduledEventId);
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    public WorkflowId getWorkflowId() {
        return new WorkflowId(this.executionId.getNamespace(), this.executionId.getExecution().getWorkflowId());
    }
}

