/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.common.CheckedExceptionWrapper;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowFactory;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.POJOWorkflowImplMetadata;
import io.temporal.internal.sync.POJOWorkflowInterfaceMetadata;
import io.temporal.internal.sync.POJOWorkflowMethodMetadata;
import io.temporal.internal.sync.SyncWorkflow;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class POJOWorkflowImplementationFactory
implements ReplayWorkflowFactory {
    private static final Logger log = LoggerFactory.getLogger(POJOWorkflowImplementationFactory.class);
    private static final byte[] EMPTY_BLOB = new byte[0];
    private final WorkflowInterceptor[] workflowInterceptors;
    private DataConverter dataConverter;
    private final List<ContextPropagator> contextPropagators;
    private final Map<String, Functions.Func<SyncWorkflowDefinition>> workflowDefinitions = Collections.synchronizedMap(new HashMap());
    private final Map<String, WorkflowImplementationOptions> implementationOptions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Functions.Func<?>> workflowImplementationFactories = Collections.synchronizedMap(new HashMap());
    private final ExecutorService threadPool;
    private final WorkflowExecutorCache cache;

    POJOWorkflowImplementationFactory(DataConverter dataConverter, ExecutorService threadPool, WorkflowInterceptor[] workflowInterceptors, WorkflowExecutorCache cache, List<ContextPropagator> contextPropagators) {
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.workflowInterceptors = Objects.requireNonNull(workflowInterceptors);
        this.cache = cache;
        this.contextPropagators = contextPropagators;
    }

    void addWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        for (Class<?> type : workflowImplementationTypes) {
            this.addWorkflowImplementationType(options, type);
        }
    }

    <R> void addWorkflowImplementationFactory(Class<R> clazz, Functions.Func<R> factory) {
        WorkflowImplementationOptions unitTestingOptions = WorkflowImplementationOptions.newBuilder().setFailWorkflowExceptionTypes(Throwable.class).build();
        this.addWorkflowImplementationFactory(unitTestingOptions, clazz, factory);
    }

    <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        this.workflowImplementationFactories.put(clazz, factory);
        POJOWorkflowInterfaceMetadata workflowMetadata = POJOWorkflowInterfaceMetadata.newInstance(clazz);
        if (!workflowMetadata.getWorkflowMethod().isPresent()) {
            throw new IllegalArgumentException("Workflow interface doesn't contain a method annotated with @WorkflowMethod: " + clazz);
        }
        List<POJOWorkflowMethodMetadata> methodsMetadata = workflowMetadata.getMethodsMetadata();
        HashMap<String, Method> signalHandlers = new HashMap<String, Method>();
        for (POJOWorkflowMethodMetadata methodMetadata : methodsMetadata) {
            switch (methodMetadata.getType()) {
                case WORKFLOW: {
                    String workflowName = methodMetadata.getName();
                    if (this.workflowDefinitions.containsKey(workflowName)) {
                        throw new IllegalStateException(workflowName + " workflow type is already registered with the worker");
                    }
                    this.workflowDefinitions.put(workflowName, () -> new POJOWorkflowImplementation(clazz, methodMetadata.getWorkflowMethod(), signalHandlers));
                    this.implementationOptions.put(workflowName, options);
                    break;
                }
                case SIGNAL: {
                    signalHandlers.put(methodMetadata.getName(), methodMetadata.getWorkflowMethod());
                }
            }
        }
    }

    private void addWorkflowImplementationType(WorkflowImplementationOptions options, Class<?> workflowImplementationClass) {
        POJOWorkflowMethodMetadata methodMetadata;
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newInstance(workflowImplementationClass);
        Set<String> workflowMethodTypes = workflowMetadata.getWorkflowTypes();
        Set<String> signalTypes = workflowMetadata.getSignalTypes();
        HashMap<String, Method> signalHandlers = new HashMap<String, Method>();
        boolean hasWorkflowMethod = false;
        for (String workflowType : workflowMethodTypes) {
            methodMetadata = workflowMetadata.getWorkflowMethodMetadata(workflowType);
            Method method = methodMetadata.getWorkflowMethod();
            Functions.Func<SyncWorkflowDefinition> factory = () -> new POJOWorkflowImplementation(workflowImplementationClass, method, signalHandlers);
            String workflowName = methodMetadata.getName();
            if (this.workflowDefinitions.containsKey(workflowName)) {
                throw new IllegalStateException(workflowName + " workflow type is already registered with the worker");
            }
            this.workflowDefinitions.put(workflowName, factory);
            this.implementationOptions.put(workflowName, options);
            hasWorkflowMethod = true;
        }
        for (String signalType : signalTypes) {
            methodMetadata = workflowMetadata.getSignalMethodMetadata(signalType);
            signalHandlers.put(methodMetadata.getName(), methodMetadata.getWorkflowMethod());
        }
        if (!hasWorkflowMethod) {
            throw new IllegalArgumentException("Workflow implementation doesn't implement any interface with a workflow method annotated with @WorkflowMethod: " + workflowImplementationClass);
        }
    }

    private SyncWorkflowDefinition getWorkflowDefinition(WorkflowType workflowType) {
        Functions.Func<SyncWorkflowDefinition> factory = this.workflowDefinitions.get(workflowType.getName());
        if (factory == null) {
            throw new Error("Unknown workflow type \"" + workflowType.getName() + "\". Known types are " + this.workflowDefinitions.keySet());
        }
        try {
            return factory.apply();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public ReplayWorkflow getWorkflow(WorkflowType workflowType) {
        SyncWorkflowDefinition workflow = this.getWorkflowDefinition(workflowType);
        WorkflowImplementationOptions options = this.implementationOptions.get(workflowType.getName());
        return new SyncWorkflow(workflow, options, this.dataConverter, this.threadPool, this.cache, this.contextPropagators);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.workflowDefinitions.isEmpty();
    }

    void logSerializationException(String signalName, Long eventId, DataConverterException exception) {
        log.error("Failure deserializing signal input for \"" + signalName + "\" at eventId " + eventId + ". Dropping it.", (Throwable)exception);
        Workflow.getMetricsScope().counter("temporal_corrupted_signals").inc(1L);
    }

    static WorkflowExecutionException mapToWorkflowExecutionException(Throwable exception, DataConverter dataConverter) {
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (!(e instanceof TemporalFailure)) continue;
            ((TemporalFailure)e).setDataConverter(dataConverter);
        }
        Failure failure = FailureConverter.exceptionToFailure(exception);
        return new WorkflowExecutionException(failure);
    }

    public String toString() {
        return "POJOWorkflowImplementationFactory{registeredWorkflowTypes=" + this.workflowDefinitions.keySet() + '}';
    }

    private class POJOWorkflowImplementation
    implements SyncWorkflowDefinition {
        private final Method workflowMethod;
        private final Class<?> workflowImplementationClass;
        private final Map<String, Method> signalHandlers;
        private Object workflow;
        private WorkflowInboundCallsInterceptor workflowInvoker;

        public POJOWorkflowImplementation(Class<?> workflowImplementationClass, Method workflowMethod, Map<String, Method> signalHandlers) {
            this.workflowMethod = workflowMethod;
            this.workflowImplementationClass = workflowImplementationClass;
            this.signalHandlers = signalHandlers;
        }

        @Override
        public void initialize() {
            this.workflowInvoker = new RootWorkflowInboundCallsInterceptor();
            for (WorkflowInterceptor workflowInterceptor : POJOWorkflowImplementationFactory.this.workflowInterceptors) {
                this.workflowInvoker = workflowInterceptor.interceptWorkflow(this.workflowInvoker);
            }
            this.workflowInvoker.init(WorkflowInternal.getRootWorkflowContext());
        }

        @Override
        public Optional<Payloads> execute(Optional<Payloads> input) throws CanceledFailure, WorkflowExecutionException {
            Object[] args = DataConverter.arrayFromPayloads(POJOWorkflowImplementationFactory.this.dataConverter, input, this.workflowMethod.getParameterTypes(), this.workflowMethod.getGenericParameterTypes());
            Preconditions.checkNotNull((Object)this.workflowInvoker, (Object)"initialize not called");
            Object result = this.workflowInvoker.execute(args);
            if (this.workflowMethod.getReturnType() == Void.TYPE) {
                return Optional.empty();
            }
            return POJOWorkflowImplementationFactory.this.dataConverter.toPayloads(result);
        }

        private void newInstance() {
            if (this.workflow != null) {
                throw new IllegalStateException("Already called");
            }
            Functions.Func factory = (Functions.Func)POJOWorkflowImplementationFactory.this.workflowImplementationFactories.get(this.workflowImplementationClass);
            if (factory != null) {
                this.workflow = factory.apply();
            } else {
                try {
                    this.workflow = this.workflowImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new Error("Failure instantiating workflow implementation class " + this.workflowImplementationClass.getName(), e);
                }
            }
        }

        private class RootWorkflowInboundCallsInterceptor
        implements WorkflowInboundCallsInterceptor {
            private RootWorkflowInboundCallsInterceptor() {
            }

            @Override
            public Object execute(Object[] arguments) {
                WorkflowInfo info = Workflow.getInfo();
                try {
                    return POJOWorkflowImplementation.this.workflowMethod.invoke(POJOWorkflowImplementation.this.workflow, arguments);
                }
                catch (IllegalAccessException e) {
                    throw new Error(POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(e, POJOWorkflowImplementationFactory.this.dataConverter));
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    if (target instanceof DestroyWorkflowThreadError) {
                        throw (DestroyWorkflowThreadError)target;
                    }
                    Throwable exception = WorkflowInternal.unwrap(target);
                    WorkflowImplementationOptions options = (WorkflowImplementationOptions)POJOWorkflowImplementationFactory.this.implementationOptions.get(info.getWorkflowType());
                    Class<? extends Throwable>[] failTypes = options.getFailWorkflowExceptionTypes();
                    if (exception instanceof TemporalFailure) {
                        this.logWorkflowExecutionException(info, exception);
                        throw POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(exception, POJOWorkflowImplementationFactory.this.dataConverter);
                    }
                    for (Class<? extends Throwable> failType : failTypes) {
                        boolean cancelRequested;
                        if (!failType.isAssignableFrom(exception.getClass())) continue;
                        if (!(!log.isErrorEnabled() || (cancelRequested = WorkflowInternal.getRootWorkflowContext().getContext().isCancelRequested()) && FailureConverter.isCanceledCause(exception))) {
                            this.logWorkflowExecutionException(info, exception);
                        }
                        throw POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(exception, POJOWorkflowImplementationFactory.this.dataConverter);
                    }
                    throw CheckedExceptionWrapper.wrap(exception);
                }
            }

            private void logWorkflowExecutionException(WorkflowInfo info, Throwable exception) {
                log.error("Workflow execution failure WorkflowId=" + info.getWorkflowId() + ", RunId=" + info.getRunId() + ", WorkflowType=" + info.getWorkflowType(), exception);
            }

            @Override
            public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
                WorkflowInternal.getRootWorkflowContext().setHeadInterceptor(outboundCalls);
                POJOWorkflowImplementation.this.newInstance();
                WorkflowInternal.registerListener(POJOWorkflowImplementation.this.workflow);
            }

            @Override
            public void processSignal(String signalName, Object[] arguments, long eventId) {
                Method signalMethod = (Method)POJOWorkflowImplementation.this.signalHandlers.get(signalName);
                try {
                    signalMethod.invoke(POJOWorkflowImplementation.this.workflow, arguments);
                }
                catch (IllegalAccessException e) {
                    throw new Error("Failure processing \"" + signalName + "\" at eventId " + eventId, e);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof DataConverterException) {
                        POJOWorkflowImplementationFactory.this.logSerializationException(signalName, eventId, (DataConverterException)targetException);
                    }
                    if (targetException instanceof Error) {
                        throw (Error)targetException;
                    }
                    throw new Error("Failure processing \"" + signalName + "\" at eventId " + eventId, targetException);
                }
            }
        }
    }
}

