/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.logging;

import io.temporal.internal.replay.ReplayAware;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ReplayAwareLogger
implements Logger {
    private final Logger log;
    private final ReplayAware context;
    private final Supplier<Boolean> enableLoggingInReplay;

    public ReplayAwareLogger(Logger logger, ReplayAware context, Supplier<Boolean> enableLoggingInReplay) {
        this.log = logger;
        this.context = context;
        this.enableLoggingInReplay = enableLoggingInReplay;
    }

    public String getName() {
        return this.log.getName();
    }

    public boolean isTraceEnabled() {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(msg);
    }

    public void trace(String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(format, arguments);
    }

    public void trace(String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(msg);
    }

    public void debug(String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(format, arguments);
    }

    public void debug(String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(marker, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.debug(marker, msg, t);
    }

    public boolean isInfoEnabled() {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(msg);
    }

    public void info(String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(format, arguments);
    }

    public void info(String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(marker, format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.info(marker, msg, t);
    }

    public boolean isWarnEnabled() {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(msg);
    }

    public void warn(String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(format, arg);
    }

    public void warn(String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(marker, format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.warn(marker, msg, t);
    }

    public boolean isErrorEnabled() {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(msg);
    }

    public void error(String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(format, arguments);
    }

    public void error(String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        if (this.shouldSkipLogging()) {
            return false;
        }
        return this.log.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(marker, format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.shouldSkipLogging()) {
            return;
        }
        this.log.error(marker, msg, t);
    }

    private boolean shouldSkipLogging() {
        return this.context.isReplaying() && this.enableLoggingInReplay.get() == false;
    }
}

