/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.external;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.external.ManualActivityCompletionClient;
import io.temporal.internal.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.external.ManualActivityCompletionClientImpl;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Map;
import java.util.Objects;

public class ManualActivityCompletionClientFactoryImpl
implements ManualActivityCompletionClientFactory {
    private final WorkflowServiceStubs service;
    private final DataConverter dataConverter;
    private final String namespace;
    private final Scope metricsScope;

    public ManualActivityCompletionClientFactoryImpl(WorkflowServiceStubs service, String namespace, DataConverter dataConverter, Scope metricsScope) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.dataConverter = Objects.requireNonNull(dataConverter);
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"Namespace", (Object)namespace).build();
        this.metricsScope = metricsScope.tagged((Map)tags);
    }

    public WorkflowServiceStubs getService() {
        return this.service;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    @Override
    public ManualActivityCompletionClient getClient(byte[] taskToken) {
        if (this.service == null) {
            throw new IllegalStateException("required property service is null");
        }
        if (this.dataConverter == null) {
            throw new IllegalStateException("required property dataConverter is null");
        }
        if (taskToken == null || taskToken.length == 0) {
            throw new IllegalArgumentException("null or empty task token");
        }
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, taskToken, this.dataConverter, this.metricsScope);
    }

    @Override
    public ManualActivityCompletionClient getClient(WorkflowExecution execution, String activityId) {
        if (execution == null) {
            throw new IllegalArgumentException("null execution");
        }
        if (activityId == null) {
            throw new IllegalArgumentException("null activityId");
        }
        return new ManualActivityCompletionClientImpl(this.service, this.namespace, execution, activityId, this.dataConverter, this.metricsScope);
    }
}

