/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.swaggerhub.tasks;

import io.swagger.swaggerhub.client.SwaggerHubClient;
import io.swagger.swaggerhub.client.SwaggerHubRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;

public class UploadTask
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(UploadTask.class);
    private String owner;
    private String api;
    private String version;
    private String token;
    private String inputFile;
    private Boolean isPrivate = false;
    private String host = "api.swaggerhub.com";
    private Integer port = 443;
    private String protocol = "https";
    private String format = "json";
    private String oas = "2.0";
    private Boolean onPremise = false;
    private String onPremiseAPISuffix = "v1";
    private SwaggerHubClient swaggerHubClient;

    @Input
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Input
    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    @Input
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Input
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @InputFile
    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    @Input
    @Optional
    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public void isPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Input
    @Optional
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Input
    @Optional
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @Input
    @Optional
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Input
    @Optional
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Input
    @Optional
    public String getOas() {
        return this.oas;
    }

    public void setOas(String oas) {
        this.oas = oas;
    }

    @Input
    @Optional
    public Boolean getOnPremise() {
        return this.onPremise;
    }

    public void setOnPremise(Boolean onPremise) {
        this.onPremise = onPremise;
    }

    @Input
    @Optional
    public String getOnPremiseAPISuffix() {
        return this.onPremiseAPISuffix;
    }

    public void setOnPremiseAPISuffix(String onPremiseAPISuffix) {
        this.onPremiseAPISuffix = onPremiseAPISuffix;
    }

    @TaskAction
    public void uploadDefinition() throws GradleException {
        this.swaggerHubClient = new SwaggerHubClient(this.host, this.port, this.protocol, this.token, this.onPremise, this.onPremiseAPISuffix);
        LOGGER.info("Uploading to {}: api: {}, owner: {}, version: {}, inputFile: {}, format: {}, isPrivate: {}, oas: {}, onPremise: {}, onPremiseAPISuffix: {} ", new Object[]{this.host, this.api, this.owner, this.version, this.inputFile, this.format, this.isPrivate, this.oas, this.onPremise, this.onPremiseAPISuffix});
        try {
            String content = new String(Files.readAllBytes(Paths.get(this.inputFile, new String[0])), StandardCharsets.UTF_8);
            SwaggerHubRequest swaggerHubRequest = new SwaggerHubRequest.Builder(this.api, this.owner, this.version).swagger(content).format(this.format).isPrivate(this.isPrivate).oas(this.oas).build();
            this.swaggerHubClient.saveDefinition(swaggerHubRequest);
        }
        catch (IOException | GradleException e) {
            throw new GradleException(e.getMessage(), e);
        }
    }
}

