/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.swaggerhub.client;

import io.swagger.swaggerhub.client.SwaggerHubRequest;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.gradle.api.GradleException;

public class SwaggerHubClient {
    private static final String DOWNLOAD_FAILED_ERROR = "Failed to download API definition: ";
    private static final String UPLOAD_FAILED_ERROR = "Failed to upload API definition: ";
    private final OkHttpClient client = new OkHttpClient();
    private final String host;
    private final int port;
    private final String token;
    private final String protocol;
    private final Boolean onPremise;
    private final String onPremiseAPISuffix;
    private static final String APIS = "apis";

    public SwaggerHubClient(String host, int port, String protocol, String token) {
        this(host, port, protocol, token, false, null);
    }

    public SwaggerHubClient(String host, int port, String protocol, String token, Boolean onPremise, String onPremiseAPISuffix) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.token = token;
        this.onPremise = onPremise;
        this.onPremiseAPISuffix = onPremiseAPISuffix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDefinition(SwaggerHubRequest swaggerHubRequest) throws GradleException {
        HttpUrl httpUrl = this.getDownloadUrl(swaggerHubRequest);
        MediaType mediaType = this.getMediaType(swaggerHubRequest);
        Request requestBuilder = this.buildGetRequest(httpUrl, mediaType);
        try (Response response = this.client.newCall(requestBuilder).execute();){
            if (response.body() == null) {
                throw new GradleException("Failed to download API definition: Response body is empty");
            }
            if (!response.isSuccessful()) {
                throw new GradleException(DOWNLOAD_FAILED_ERROR + response.body().string());
            }
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new GradleException(DOWNLOAD_FAILED_ERROR, (Throwable)e);
        }
    }

    private Request buildGetRequest(HttpUrl httpUrl, MediaType mediaType) {
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).addHeader("Accept", mediaType.toString()).addHeader("User-Agent", "swaggerhub-gradle-plugin");
        if (this.token != null) {
            requestBuilder.addHeader("Authorization", this.token);
        }
        return requestBuilder.build();
    }

    public void saveDefinition(SwaggerHubRequest swaggerHubRequest) throws GradleException {
        HttpUrl httpUrl = this.getUploadUrl(swaggerHubRequest);
        MediaType mediaType = this.getMediaType(swaggerHubRequest);
        Request httpRequest = this.buildPostRequest(httpUrl, mediaType, swaggerHubRequest.getSwagger());
        try (Response response = this.client.newCall(httpRequest).execute();){
            if (response.body() == null) {
                throw new GradleException("Failed to upload API definition: Response body is empty");
            }
            if (!response.isSuccessful()) {
                throw new GradleException(UPLOAD_FAILED_ERROR + response.body().string());
            }
        }
        catch (IOException e) {
            throw new GradleException(UPLOAD_FAILED_ERROR, (Throwable)e);
        }
    }

    private Request buildPostRequest(HttpUrl httpUrl, MediaType mediaType, String content) {
        return new Request.Builder().url(httpUrl).addHeader("Content-Type", mediaType.toString()).addHeader("Authorization", this.token).addHeader("User-Agent", "swaggerhub-gradle-plugin").post(RequestBody.create((String)content, (MediaType)mediaType)).build();
    }

    private HttpUrl getDownloadUrl(SwaggerHubRequest swaggerHubRequest) {
        return this.getBaseUrl(swaggerHubRequest.getOwner(), swaggerHubRequest.getApi()).addEncodedPathSegment(swaggerHubRequest.getVersion()).addQueryParameter("resolved", String.valueOf(swaggerHubRequest.resolved())).build();
    }

    private HttpUrl getUploadUrl(SwaggerHubRequest swaggerHubRequest) {
        return this.getBaseUrl(swaggerHubRequest.getOwner(), swaggerHubRequest.getApi()).addEncodedQueryParameter("version", swaggerHubRequest.getVersion()).addEncodedQueryParameter("isPrivate", Boolean.toString(swaggerHubRequest.isPrivate())).addEncodedQueryParameter("oas", swaggerHubRequest.getOas()).build();
    }

    private HttpUrl.Builder getBaseUrl(String owner, String api) {
        return new HttpUrl.Builder().scheme(this.protocol).host(this.host).port(this.port).addPathSegment(this.onPremise != false ? this.onPremiseAPISuffix : "").addPathSegment(APIS).addEncodedPathSegment(owner).addEncodedPathSegment(api);
    }

    private MediaType getMediaType(SwaggerHubRequest swaggerHubRequest) {
        String headerFormat = "application/%s; charset=utf-8";
        MediaType mediaType = MediaType.parse((String)String.format(headerFormat, swaggerHubRequest.getFormat()));
        if (mediaType == null) {
            mediaType = MediaType.parse((String)String.format(headerFormat, "json"));
        }
        return mediaType;
    }
}

