/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.mule;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ApiListingJSON {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiListingJSON.class);
    static boolean initialized = false;
    static Swagger swagger;

    public static void init(Swagger swagger) {
        ApiListingJSON.swagger = swagger;
    }

    protected synchronized void scan(Application app) {
        Scanner scanner = ScannerFactory.getScanner();
        LOGGER.debug("using scanner " + scanner);
        if (scanner != null) {
            SwaggerSerializers.setPrettyPrint((boolean)scanner.getPrettyPrint());
            Set classes = null;
            classes = scanner.classes();
            if (classes != null) {
                Reader reader = new Reader(swagger);
                swagger = reader.read(classes);
                if (scanner instanceof SwaggerConfig) {
                    swagger = ((SwaggerConfig)scanner).configure(swagger);
                }
            }
        }
        initialized = true;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/swagger.json")
    public Response getListingJson(@Context Application app, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        if (!initialized) {
            this.scan(app);
        }
        if (swagger != null) {
            try {
                return Response.ok().entity((Object)Json.mapper().writeValueAsString((Object)swagger)).build();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return Response.status((int)405).build();
            }
        }
        return Response.status((int)404).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="/swagger.yaml")
    public Response getListingYaml(@Context Application app, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        if (!initialized) {
            this.scan(app);
        }
        if (swagger != null) {
            try {
                String yaml = Yaml.mapper().writeValueAsString((Object)swagger);
                return Response.ok().entity((Object)yaml).type("text/plain").build();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return Response.status((int)405).build();
            }
        }
        return Response.status((int)404).build();
    }
}

