/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.swagger.v3.core.util.Json;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    static Map<String, JsonSchema> SCHEMA_CACHE = new HashMap<String, JsonSchema>();
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaValidator.class);

    public static boolean validate(Object argument, String schema, Direction direction) {
        try {
            JsonNode schemaObject = Json.mapper().readTree(schema);
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            JsonNode content = (JsonNode)Json.mapper().convertValue(argument, JsonNode.class);
            JsonSchema jsonSchema = factory.getJsonSchema(schemaObject);
            ProcessingReport report = jsonSchema.validate(content);
            if (!report.isSuccess()) {
                if (direction.equals((Object)Direction.INPUT)) {
                    LOGGER.warn("input: " + content.toString() + "\ndoes not match schema: \n" + schema);
                } else {
                    LOGGER.warn("response: " + content.toString() + "\ndoes not match schema: \n" + schema);
                }
            }
            return report.isSuccess();
        }
        catch (Exception e) {
            LOGGER.error("can't validate model against schema", (Throwable)e);
            return true;
        }
    }

    public static JsonSchema getValidationSchema(String schema) throws IOException, ProcessingException {
        JsonSchema output = SCHEMA_CACHE.get(schema = schema.trim());
        if (output == null) {
            JsonNode schemaObject = Json.mapper().readTree(schema);
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            JsonSchema jsonSchema = factory.getJsonSchema(schemaObject);
            SCHEMA_CACHE.put(schema, jsonSchema);
            output = jsonSchema;
        }
        return output;
    }

    public static enum Direction {
        INPUT,
        OUTPUT;

    }
}

