/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.InternetDomainName;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.migrate.resourcelisting.PathAppenderMigrator;
import io.swagger.transform.util.MutableJsonTree;
import io.swagger.transform.util.SwaggerMigrationException;
import io.swagger.transform.util.SwaggerMigrators;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class V11ResourceListingMigrator
implements SwaggerMigrator {
    private static final Pattern LEGAL_SCHEMES = Pattern.compile("https?", 2);

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        MutableJsonTree tree = new MutableJsonTree(input);
        SwaggerMigrator migrator = SwaggerMigrators.membersToString("swaggerVersion", "apiVersion");
        tree.applyMigrator(migrator);
        migrator = SwaggerMigrators.patchFromResource("/patches/v1.1/versionChange.json");
        tree.applyMigrator(migrator);
        if (input.path("basePath").isTextual()) {
            String basePath = input.get("basePath").textValue();
            ((ObjectNode)tree.getCurrentNode()).remove("basePath");
            try {
                basePath = V11ResourceListingMigrator.checkLegalBasePath(basePath);
            }
            catch (IllegalArgumentException e) {
                throw new SwaggerMigrationException(e.getMessage());
            }
            migrator = new PathAppenderMigrator(basePath);
            tree.setPointer(JsonPointer.of((Object)"apis", (Object[])new Object[0]));
            tree.applyMigratorToElements(migrator);
        }
        return tree.getBaseNode();
    }

    private static String checkLegalBasePath(@Nonnull String input) {
        URI uri = URI.create(input).normalize();
        Preconditions.checkArgument((boolean)uri.isAbsolute(), (Object)"basePath has no scheme");
        String tmp = uri.getScheme();
        Preconditions.checkArgument((boolean)LEGAL_SCHEMES.matcher(tmp).matches(), (Object)("basePath has scheme " + tmp + ", expected either http or https"));
        tmp = Strings.nullToEmpty((String)uri.getHost());
        Preconditions.checkArgument((boolean)InternetDomainName.isValid((String)tmp), (Object)("basePath has an invalid hostname " + tmp));
        tmp = Strings.nullToEmpty((String)uri.getPath());
        Preconditions.checkArgument((!tmp.endsWith("/") ? 1 : 0) != 0, (Object)("basePath's path component " + tmp + " must not end with a /"));
        return uri.toString();
    }
}

