/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.auth;

import io.swagger.models.auth.AuthorizationValue;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AuthParser {
    public static List<AuthorizationValue> parse(String urlEncodedAuthStr) {
        ArrayList<AuthorizationValue> auths = new ArrayList<AuthorizationValue>();
        if (StringUtils.isNotEmpty((CharSequence)urlEncodedAuthStr)) {
            String[] parts;
            for (String part : parts = urlEncodedAuthStr.split(",")) {
                String[] kvPair = part.split(":");
                if (kvPair.length != 2) continue;
                auths.add(new AuthorizationValue(URLDecoder.decode(kvPair[0]), URLDecoder.decode(kvPair[1]), "header"));
            }
        }
        return auths;
    }

    public static String reconstruct(List<AuthorizationValue> authorizationValueList) {
        if (authorizationValueList != null) {
            StringBuilder b = new StringBuilder();
            for (AuthorizationValue v : authorizationValueList) {
                try {
                    if (b.toString().length() > 0) {
                        b.append(",");
                    }
                    b.append(URLEncoder.encode(v.getKeyName(), "UTF-8")).append(":").append(URLEncoder.encode(v.getValue(), "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return b.toString();
        }
        return null;
    }
}

