/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.oas.models.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.XML;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Schema<T> {
    protected T _default;
    private String name;
    private String title = null;
    private BigDecimal multipleOf = null;
    private BigDecimal maximum = null;
    private Boolean exclusiveMaximum = null;
    private BigDecimal minimum = null;
    private Boolean exclusiveMinimum = null;
    private Integer maxLength = null;
    private Integer minLength = null;
    private String pattern = null;
    private Integer maxItems = null;
    private Integer minItems = null;
    private Boolean uniqueItems = null;
    private Integer maxProperties = null;
    private Integer minProperties = null;
    private List<String> required = null;
    private String type = null;
    private Schema not = null;
    private Map<String, Schema> properties = null;
    private Object additionalProperties = null;
    private String description = null;
    private String format = null;
    private String $ref = null;
    private Boolean nullable = null;
    private Boolean readOnly = null;
    private Boolean writeOnly = null;
    protected T example = null;
    private ExternalDocumentation externalDocs = null;
    private Boolean deprecated = null;
    private XML xml = null;
    private Map<String, Object> extensions = null;
    protected List<T> _enum = null;
    private Discriminator discriminator = null;

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Schema name(String name) {
        this.setName(name);
        return this;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator discriminator) {
        this.discriminator = discriminator;
    }

    public Schema discriminator(Discriminator discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Schema title(String title) {
        this.title = title;
        return this;
    }

    public T getDefault() {
        return this._default;
    }

    public void setDefault(Object _default) {
        this._default = this.cast(_default);
    }

    protected T cast(Object value) {
        return (T)value;
    }

    public List<T> getEnum() {
        return this._enum;
    }

    public void setEnum(List<T> _enum) {
        this._enum = _enum;
    }

    public void addEnumItemObject(T _enumItem) {
        T casted = this.cast(_enumItem);
        if (casted != null) {
            if (this._enum == null) {
                this._enum = new ArrayList<T>();
            }
            this._enum.add(casted);
        }
    }

    public BigDecimal getMultipleOf() {
        return this.multipleOf;
    }

    public void setMultipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
    }

    public Schema multipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    public Schema maximum(BigDecimal maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public Schema exclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    public Schema minimum(BigDecimal minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Schema exclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Schema maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Schema minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Schema pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Schema maxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    public Schema minItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public Schema uniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
    }

    public Schema maxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public void setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
    }

    public Schema minProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void setRequired(List<String> required) {
        ArrayList<String> list = new ArrayList<String>();
        if (required != null) {
            for (String req : required) {
                if (this.properties == null) {
                    list.add(req);
                    continue;
                }
                if (!this.properties.containsKey(req)) continue;
                list.add(req);
            }
        }
        Collections.sort(list);
        if (list.size() == 0) {
            list = null;
        }
        this.required = list;
    }

    public Schema required(List<String> required) {
        this.required = required;
        return this;
    }

    public Schema addRequiredItem(String requiredItem) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(requiredItem);
        Collections.sort(this.required);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Schema type(String type) {
        this.type = type;
        return this;
    }

    public Schema getNot() {
        return this.not;
    }

    public void setNot(Schema not) {
        this.not = not;
    }

    public Schema not(Schema not) {
        this.not = not;
        return this;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Schema> properties) {
        this.properties = properties;
    }

    public Schema properties(Map<String, Schema> properties) {
        this.properties = properties;
        return this;
    }

    public Schema addProperties(String key, Schema propertiesItem) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Schema>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    public Object getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Object additionalProperties) {
        if (additionalProperties != null && !(additionalProperties instanceof Boolean) && !(additionalProperties instanceof Schema)) {
            throw new IllegalArgumentException("additionalProperties must be either a Boolean or a Schema instance");
        }
        this.additionalProperties = additionalProperties;
    }

    public Schema additionalProperties(Object additionalProperties) {
        this.setAdditionalProperties(additionalProperties);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Schema description(String description) {
        this.description = description;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Schema format(String format) {
        this.format = format;
        return this;
    }

    public String get$ref() {
        return this.$ref;
    }

    public void set$ref(String $ref) {
        if ($ref != null && $ref.indexOf(".") == -1 && $ref.indexOf("/") == -1) {
            $ref = "#/components/schemas/" + $ref;
        }
        this.$ref = $ref;
    }

    public Schema $ref(String $ref) {
        this.set$ref($ref);
        return this;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Schema nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Schema readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public void setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    public Schema writeOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = this.cast(example);
    }

    public Schema example(Object example) {
        this.example = this.cast(example);
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public Schema externalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Schema deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public XML getXml() {
        return this.xml;
    }

    public void setXml(XML xml) {
        this.xml = xml;
    }

    public Schema xml(XML xml) {
        this.xml = xml;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return Objects.equals(this.title, schema.title) && Objects.equals(this.multipleOf, schema.multipleOf) && Objects.equals(this.maximum, schema.maximum) && Objects.equals(this.exclusiveMaximum, schema.exclusiveMaximum) && Objects.equals(this.minimum, schema.minimum) && Objects.equals(this.exclusiveMinimum, schema.exclusiveMinimum) && Objects.equals(this.maxLength, schema.maxLength) && Objects.equals(this.minLength, schema.minLength) && Objects.equals(this.pattern, schema.pattern) && Objects.equals(this.maxItems, schema.maxItems) && Objects.equals(this.minItems, schema.minItems) && Objects.equals(this.uniqueItems, schema.uniqueItems) && Objects.equals(this.maxProperties, schema.maxProperties) && Objects.equals(this.minProperties, schema.minProperties) && Objects.equals(this.required, schema.required) && Objects.equals(this.type, schema.type) && Objects.equals(this.not, schema.not) && Objects.equals(this.properties, schema.properties) && Objects.equals(this.additionalProperties, schema.additionalProperties) && Objects.equals(this.description, schema.description) && Objects.equals(this.format, schema.format) && Objects.equals(this.$ref, schema.$ref) && Objects.equals(this.nullable, schema.nullable) && Objects.equals(this.readOnly, schema.readOnly) && Objects.equals(this.writeOnly, schema.writeOnly) && Objects.equals(this.example, schema.example) && Objects.equals(this.externalDocs, schema.externalDocs) && Objects.equals(this.deprecated, schema.deprecated) && Objects.equals(this.xml, schema.xml) && Objects.equals(this.extensions, schema.extensions) && Objects.equals(this.discriminator, schema.discriminator) && Objects.equals(this._enum, schema._enum) && Objects.equals(this._default, schema._default);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.multipleOf, this.maximum, this.exclusiveMaximum, this.minimum, this.exclusiveMinimum, this.maxLength, this.minLength, this.pattern, this.maxItems, this.minItems, this.uniqueItems, this.maxProperties, this.minProperties, this.required, this.type, this.not, this.properties, this.additionalProperties, this.description, this.format, this.$ref, this.nullable, this.readOnly, this.writeOnly, this.example, this.externalDocs, this.deprecated, this.xml, this.extensions, this.discriminator, this._enum, this._default);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void addExtension(String name, Object value) {
        if (name == null || name.isEmpty() || !name.startsWith("x-")) {
            return;
        }
        if (this.extensions == null) {
            this.extensions = new LinkedHashMap<String, Object>();
        }
        this.extensions.put(name, value);
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public Schema<T> extensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Schema {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    multipleOf: ").append(this.toIndentedString(this.multipleOf)).append("\n");
        sb.append("    maximum: ").append(this.toIndentedString(this.maximum)).append("\n");
        sb.append("    exclusiveMaximum: ").append(this.toIndentedString(this.exclusiveMaximum)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("    exclusiveMinimum: ").append(this.toIndentedString(this.exclusiveMinimum)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    maxItems: ").append(this.toIndentedString(this.maxItems)).append("\n");
        sb.append("    minItems: ").append(this.toIndentedString(this.minItems)).append("\n");
        sb.append("    uniqueItems: ").append(this.toIndentedString(this.uniqueItems)).append("\n");
        sb.append("    maxProperties: ").append(this.toIndentedString(this.maxProperties)).append("\n");
        sb.append("    minProperties: ").append(this.toIndentedString(this.minProperties)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    not: ").append(this.toIndentedString(this.not)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    $ref: ").append(this.toIndentedString(this.$ref)).append("\n");
        sb.append("    nullable: ").append(this.toIndentedString(this.nullable)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    writeOnly: ").append(this.toIndentedString(this.writeOnly)).append("\n");
        sb.append("    example: ").append(this.toIndentedString(this.example)).append("\n");
        sb.append("    externalDocs: ").append(this.toIndentedString(this.externalDocs)).append("\n");
        sb.append("    deprecated: ").append(this.toIndentedString(this.deprecated)).append("\n");
        sb.append("    discriminator: ").append(this.toIndentedString(this.discriminator)).append("\n");
        sb.append("    xml: ").append(this.toIndentedString(this.xml)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

