/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.plugin.maven;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.GenericOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="resolve", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, configurator="include-project-dependencies")
public class SwaggerMojo
extends AbstractMojo {
    @Parameter(property="resolve.outputFileName", defaultValue="openapi")
    private String outputFileName = "openapi";
    @Parameter(property="resolve.outputPath")
    private String outputPath;
    @Parameter(property="resolve.outputFormat", defaultValue="JSON")
    private Format outputFormat = Format.JSON;
    @Parameter(property="resolve.resourcePackages")
    private Set<String> resourcePackages;
    @Parameter(property="resolve.resourceClasses")
    private Set<String> resourceClasses;
    @Parameter(property="resolve.modelConverterClasses")
    private LinkedHashSet<String> modelConverterClasses;
    @Parameter(property="resolve.filterClass")
    private String filterClass;
    @Parameter(property="resolve.readerClass")
    private String readerClass;
    @Parameter(property="resolve.scannerClass")
    private String scannerClass;
    @Parameter(property="resolve.objectMapperProcessorClass")
    private String objectMapperProcessorClass;
    @Parameter(property="resolve.prettyPrint")
    private Boolean prettyPrint;
    @Parameter(property="resolve.readAllResources")
    private Boolean readAllResources;
    @Parameter(property="resolve.ignoredRoutes")
    private Collection<String> ignoredRoutes;
    @Parameter(property="resolve.contextId", defaultValue="${project.artifactId}")
    private String contextId;
    @Parameter(property="resolve.skip")
    private Boolean skip = Boolean.FALSE;
    @Parameter(property="resolve.openapiFilePath")
    private String openapiFilePath;
    @Parameter(property="resolve.configurationFilePath")
    private String configurationFilePath;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="resolve.encoding")
    private String encoding;
    @Parameter(property="resolve.sortOutput")
    private Boolean sortOutput;
    private String projectEncoding = "UTF-8";
    private SwaggerConfiguration config;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String pEnc;
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping OpenAPI specification resolution");
            return;
        }
        this.getLog().info((CharSequence)"Resolving OpenAPI specification..");
        if (this.project != null && StringUtils.isNotBlank((String)(pEnc = this.project.getProperties().getProperty("project.build.sourceEncoding")))) {
            this.projectEncoding = pEnc;
        }
        if (StringUtils.isBlank((String)this.encoding)) {
            this.encoding = this.projectEncoding;
        }
        Optional<SwaggerConfiguration> swaggerConfiguration = this.readStructuredDataFromFile(this.configurationFilePath, SwaggerConfiguration.class, "configurationFilePath");
        Optional<OpenAPI> openAPIInput = this.readStructuredDataFromFile(this.openapiFilePath, OpenAPI.class, "openapiFilePath");
        this.config = this.mergeConfig(openAPIInput.orElse(null), swaggerConfiguration.orElse(new SwaggerConfiguration()));
        this.setDefaultsIfMissing(this.config);
        try {
            Path path;
            File parentFile;
            GenericOpenApiContextBuilder builder = new JaxrsOpenApiContextBuilder().openApiConfiguration((OpenAPIConfiguration)this.config);
            if (StringUtils.isNotBlank((String)this.contextId)) {
                builder.ctxId(this.contextId);
            }
            OpenApiContext context = builder.buildContext(true);
            OpenAPI openAPI = context.read();
            if (StringUtils.isNotBlank((String)this.filterClass)) {
                try {
                    OpenAPISpecFilter filterImpl = (OpenAPISpecFilter)((Object)((Object)this)).getClass().getClassLoader().loadClass(this.filterClass).newInstance();
                    SpecFilter f = new SpecFilter();
                    openAPI = f.filter(openAPI, filterImpl, new HashMap(), new HashMap(), new HashMap());
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Error applying filter to API specification", (Throwable)e);
                    throw new MojoExecutionException("Error applying filter to API specification: " + e.getMessage(), e);
                }
            }
            String openapiJson = null;
            String openapiYaml = null;
            if (Format.JSON.equals((Object)this.outputFormat) || Format.JSONANDYAML.equals((Object)this.outputFormat)) {
                openapiJson = this.prettyPrint != null && this.prettyPrint != false ? context.getOutputJsonMapper().writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)openAPI) : context.getOutputJsonMapper().writeValueAsString((Object)openAPI);
            }
            if (Format.YAML.equals((Object)this.outputFormat) || Format.JSONANDYAML.equals((Object)this.outputFormat)) {
                openapiYaml = this.prettyPrint != null && this.prettyPrint != false ? context.getOutputYamlMapper().writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)openAPI) : context.getOutputYamlMapper().writeValueAsString((Object)openAPI);
            }
            if ((parentFile = (path = Paths.get(this.outputPath, "temp")).toFile().getParentFile()) != null) {
                parentFile.mkdirs();
            }
            if (openapiJson != null) {
                path = Paths.get(this.outputPath, this.outputFileName + ".json");
                Files.write(path, openapiJson.getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
                this.getLog().info((CharSequence)("JSON output: " + path.toFile().getCanonicalPath()));
            }
            if (openapiYaml != null) {
                path = Paths.get(this.outputPath, this.outputFileName + ".yaml");
                Files.write(path, openapiYaml.getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
                this.getLog().info((CharSequence)("YAML output: " + path.toFile().getCanonicalPath()));
            }
        }
        catch (OpenApiConfigurationException e) {
            this.getLog().error((CharSequence)"Error resolving API specification", (Throwable)e);
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing API specification", (Throwable)e);
            throw new MojoExecutionException("Failed to write API definition", (Exception)e);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error resolving API specification", (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void setDefaultsIfMissing(SwaggerConfiguration config) {
        if (this.prettyPrint == null) {
            this.prettyPrint = Boolean.FALSE;
        }
        if (this.readAllResources == null) {
            this.readAllResources = Boolean.TRUE;
        }
        if (this.sortOutput == null) {
            this.sortOutput = Boolean.FALSE;
        }
        if (config.isPrettyPrint() == null) {
            config.prettyPrint(this.prettyPrint);
        }
        if (config.isReadAllResources() == null) {
            config.readAllResources(this.readAllResources);
        }
        if (config.isSortOutput() == null) {
            config.sortOutput(this.sortOutput);
        }
    }

    private <T> Optional<T> readStructuredDataFromFile(String filePath, Class<T> outputClass, String configName) throws MojoFailureException {
        try {
            if (StringUtils.isBlank((String)filePath)) {
                return Optional.empty();
            }
            Path pathObj = Paths.get(filePath, new String[0]);
            if (!pathObj.toFile().exists() || !pathObj.toFile().isFile()) {
                throw new IllegalArgumentException(String.format("passed path does not exist or is not a file: '%s'", filePath));
            }
            String fileContent = new String(Files.readAllBytes(pathObj), this.encoding);
            if (StringUtils.isBlank((String)fileContent)) {
                this.getLog().warn((CharSequence)String.format("It seems that file '%s' defined in config %s is empty", pathObj.toString(), configName));
                return Optional.empty();
            }
            List<BiFunction<String, Class<T>, T>> mappers = this.getSortedMappers(pathObj);
            Object instance = null;
            Exception caughtEx = null;
            for (BiFunction<String, Class<String>, String> biFunction : mappers) {
                try {
                    instance = biFunction.apply(fileContent, outputClass);
                    break;
                }
                catch (Exception e) {
                    caughtEx = e;
                }
            }
            if (instance == null) {
                if (caughtEx == null) {
                    caughtEx = new IllegalStateException("undefined state");
                }
                this.getLog().error((CharSequence)String.format("Could not read file '%s' for config %s", pathObj.toString(), configName), (Throwable)caughtEx);
                throw new IllegalStateException(caughtEx.getMessage(), caughtEx);
            }
            return Optional.of(instance);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Error reading/deserializing config %s file", configName), (Throwable)e);
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private <T> List<BiFunction<String, Class<T>, T>> getSortedMappers(Path pathObj) {
        String ext = FileUtils.extension((String)pathObj.toString());
        boolean yamlPreferred = false;
        if (ext.equalsIgnoreCase("yaml") || ext.equalsIgnoreCase("yml")) {
            yamlPreferred = true;
        }
        ArrayList<BiFunction<String, Class, Object>> list = new ArrayList<BiFunction<String, Class, Object>>(2);
        list.add((content, typeClass) -> {
            try {
                return Json.mapper().readValue(content, typeClass);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        list.add((content, typeClass) -> {
            try {
                return Yaml.mapper().readValue(content, typeClass);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        if (yamlPreferred) {
            Collections.reverse(list);
        }
        return Collections.unmodifiableList(list);
    }

    private SwaggerConfiguration mergeConfig(OpenAPI openAPIInput, SwaggerConfiguration config) {
        if (StringUtils.isNotBlank((String)this.filterClass)) {
            config.filterClass(this.filterClass);
        }
        if (this.isCollectionNotBlank(this.ignoredRoutes)) {
            config.ignoredRoutes(this.ignoredRoutes);
        }
        if (this.prettyPrint != null) {
            config.prettyPrint(this.prettyPrint);
        }
        if (this.sortOutput != null) {
            config.sortOutput(this.sortOutput);
        }
        if (this.readAllResources != null) {
            config.readAllResources(this.readAllResources);
        }
        if (StringUtils.isNotBlank((String)this.readerClass)) {
            config.readerClass(this.readerClass);
        }
        if (StringUtils.isNotBlank((String)this.scannerClass)) {
            config.scannerClass(this.scannerClass);
        }
        if (this.isCollectionNotBlank(this.resourceClasses)) {
            config.resourceClasses(this.resourceClasses);
        }
        if (openAPIInput != null) {
            config.openAPI(openAPIInput);
        }
        if (this.isCollectionNotBlank(this.resourcePackages)) {
            config.resourcePackages(this.resourcePackages);
        }
        if (StringUtils.isNotBlank((String)this.objectMapperProcessorClass)) {
            config.objectMapperProcessorClass(this.objectMapperProcessorClass);
        }
        if (this.isCollectionNotBlank(this.modelConverterClasses)) {
            config.modelConverterClasses(this.modelConverterClasses);
        }
        return config;
    }

    private boolean isCollectionNotBlank(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getOpenapiFilePath() {
        return this.openapiFilePath;
    }

    String getConfigurationFilePath() {
        return this.configurationFilePath;
    }

    void setContextId(String contextId) {
        this.contextId = contextId;
    }

    SwaggerConfiguration getInternalConfiguration() {
        return this.config;
    }

    public static enum Format {
        JSON,
        YAML,
        JSONANDYAML;

    }
}

