/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.plugins.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;

@CacheableTask
public class ResolveTask
extends DefaultTask {
    @Input
    @Optional
    public final Property<String> outputFileName = this.getProject().getObjects().property(String.class);
    @OutputDirectory
    public final DirectoryProperty outputDir = this.getProject().getObjects().directoryProperty();
    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public final RegularFileProperty openApiFile = this.getProject().getObjects().fileProperty();
    @Input
    @Optional
    public final Property<Format> outputFormat = this.getProject().getObjects().property(Format.class);
    @Input
    @Optional
    public final SetProperty<String> resourcePackages = this.getProject().getObjects().setProperty(String.class);
    @Input
    @Optional
    public final SetProperty<String> resourceClasses = this.getProject().getObjects().setProperty(String.class);
    @Input
    @Optional
    public final Property<String> filterClass = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final Property<String> readerClass = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final Property<String> scannerClass = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final Property<Boolean> prettyPrint = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<Boolean> readAllResources = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final SetProperty<String> ignoredRoutes = this.getProject().getObjects().setProperty(String.class);
    @Classpath
    @Optional
    public final ConfigurableFileCollection buildClasspath = this.getProject().getObjects().fileCollection();
    @Classpath
    public final ConfigurableFileCollection classpath = this.getProject().getObjects().fileCollection();
    @Deprecated
    @Input
    @Optional
    public final Property<Boolean> skip = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<String> encoding = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final SetProperty<String> modelConverterClasses = this.getProject().getObjects().setProperty(String.class);
    @Input
    @Optional
    public final Property<String> objectMapperProcessorClass = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final Property<Boolean> sortOutput = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<Boolean> alwaysResolveAppPath = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<Boolean> skipResolveAppPath = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<String> contextId = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final Property<Boolean> openAPI31 = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<Boolean> convertToOpenAPI31 = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    public final Property<String> schemaResolution = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    private Property<String> openAPIVersion = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    public final Property<String> defaultResponseCode = this.getProject().getObjects().property(String.class);

    public Property<String> getOutputFileName() {
        return this.outputFileName;
    }

    public RegularFileProperty getOpenApiFile() {
        return this.openApiFile;
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputPath) {
        this.outputDir.set(this.getProject().file((Object)outputPath));
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName.set((Object)outputFileName);
    }

    public void setOpenApiFile(File openApiFile) {
        this.openApiFile.set(openApiFile);
    }

    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Iterable<File> classpath) {
        this.classpath.setFrom(classpath);
    }

    public ConfigurableFileCollection getBuildClasspath() {
        return this.buildClasspath;
    }

    public void setBuildClasspath(Iterable<File> buildClasspath) {
        this.buildClasspath.setFrom(buildClasspath);
    }

    @Deprecated
    @Internal
    public Provider<String> getOutputPath() {
        return this.outputDir.map(dir -> dir.getAsFile().getPath());
    }

    @Deprecated
    public void setOutputPath(String outputPath) {
        this.outputDir.set(this.getProject().file((Object)outputPath));
    }

    public Property<Format> getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat.set((Object)Format.valueOf(outputFormat));
    }

    public void setOutputFormat(Format outputFormat) {
        this.outputFormat.set((Object)outputFormat);
    }

    public SetProperty<String> getResourcePackages() {
        return this.resourcePackages;
    }

    public void setResourcePackages(Set<String> resourcePackages) {
        this.resourcePackages.set(resourcePackages);
    }

    public SetProperty<String> getModelConverterClasses() {
        return this.modelConverterClasses;
    }

    public void setModelConverterClasses(Set<String> modelConverterClasses) {
        this.modelConverterClasses.set(modelConverterClasses);
    }

    public SetProperty<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(Set<String> resourceClasses) {
        this.resourceClasses.set(resourceClasses);
    }

    public Property<String> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass.set((Object)filterClass);
    }

    public Property<String> getReaderClass() {
        return this.readerClass;
    }

    public void setReaderClass(String readerClass) {
        this.readerClass.set((Object)readerClass);
    }

    public Property<String> getObjectMapperProcessorClass() {
        return this.objectMapperProcessorClass;
    }

    public void setObjectMapperProcessorClass(String objectMapperProcessorClass) {
        this.objectMapperProcessorClass.set((Object)objectMapperProcessorClass);
    }

    public Property<String> getDefaultResponseCode() {
        return this.defaultResponseCode;
    }

    public void setDefaultResponseCode(String defaultResponseCode) {
        this.defaultResponseCode.set((Object)defaultResponseCode);
    }

    public Property<String> getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId.set((Object)contextId);
    }

    public Property<String> getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(String scannerClass) {
        this.scannerClass.set((Object)scannerClass);
    }

    public Property<Boolean> getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(@Nullable String prettyPrint) {
        this.setPrettyPrint(prettyPrint == null ? null : Boolean.valueOf(prettyPrint));
    }

    public void setPrettyPrint(@Nullable Boolean prettyPrint) {
        this.prettyPrint.set((Object)prettyPrint);
    }

    public Property<Boolean> getReadAllResources() {
        return this.readAllResources;
    }

    public void setReadAllResources(Boolean readAllResources) {
        this.readAllResources.set((Object)readAllResources);
    }

    public void setReadAllResources(@Nullable String readAllResources) {
        this.setReadAllResources(readAllResources == null ? null : Boolean.valueOf(readAllResources));
    }

    public SetProperty<String> getIgnoredRoutes() {
        return this.ignoredRoutes;
    }

    public void setIgnoredRoutes(Collection<String> ignoredRoutes) {
        this.ignoredRoutes.set(ignoredRoutes);
    }

    public Property<Boolean> getSkip() {
        return this.skip;
    }

    public void setSkip(Boolean skip) {
        this.skip.set((Object)skip);
    }

    public Property<String> getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding.set((Object)encoding);
    }

    public Property<Boolean> getSortOutput() {
        return this.sortOutput;
    }

    public void setSortOutput(Boolean sortOutput) {
        this.sortOutput.set((Object)sortOutput);
    }

    public Property<Boolean> getAlwaysResolveAppPath() {
        return this.alwaysResolveAppPath;
    }

    public void setAlwaysResolveAppPath(Boolean alwaysResolveAppPath) {
        this.alwaysResolveAppPath.set((Object)alwaysResolveAppPath);
    }

    public void setAlwaysResolveAppPath(@Nullable String alwaysResolveAppPath) {
        this.setAlwaysResolveAppPath(alwaysResolveAppPath == null ? null : Boolean.valueOf(alwaysResolveAppPath));
    }

    public Property<Boolean> getSkipResolveAppPath() {
        return this.skipResolveAppPath;
    }

    public void setSkipResolveAppPath(Boolean skipResolveAppPath) {
        this.skipResolveAppPath.set((Object)skipResolveAppPath);
    }

    public Property<Boolean> getOpenAPI31() {
        return this.openAPI31;
    }

    public void setOpenAPI31(Boolean openAPI31) {
        this.openAPI31.set((Object)openAPI31);
    }

    public void setOpenAPI31(@Nullable String openAPI31) {
        this.setOpenAPI31(openAPI31 == null ? null : Boolean.valueOf(openAPI31));
    }

    public Property<Boolean> getConvertToOpenAPI31() {
        return this.convertToOpenAPI31;
    }

    public void setConvertToOpenAPI31(Boolean convertToOpenAPI31) {
        this.convertToOpenAPI31.set((Object)convertToOpenAPI31);
        if (Boolean.TRUE.equals(convertToOpenAPI31)) {
            this.openAPI31.set((Object)Boolean.TRUE);
        }
    }

    public void setConvertToOpenAPI31(@Nullable String convertToOpenAPI31) {
        this.setConvertToOpenAPI31(convertToOpenAPI31 == null ? null : Boolean.valueOf(convertToOpenAPI31));
    }

    public Property<String> getSchemaResolution() {
        return this.schemaResolution;
    }

    public void setSchemaResolution(String schemaResolution) {
        this.schemaResolution.set((Object)schemaResolution);
    }

    public Property<String> getOpenAPIVersion() {
        return this.openAPIVersion;
    }

    public void setOpenAPIVersion(String openAPIVersion) {
        this.openAPIVersion.set((Object)openAPIVersion);
    }

    @TaskAction
    public void resolve() throws GradleException {
        if (((Boolean)this.skip.getOrElse((Object)false)).booleanValue()) {
            this.getLogger().warn("You use the deprecated 'skip' property. For better performance prevent the execution instead (for example by calling the `compileJava` task instead)");
            this.getLogger().info("Skipping OpenAPI specification resolution");
            return;
        }
        this.getLogger().info("Resolving OpenAPI specification..");
        Stream<URL> classpathStream = this.classpath.getFiles().stream().map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new GradleException(String.format("Could not create classpath for annotations task %s.", this.getName()), (Throwable)e);
            }
        });
        Stream<URL> buildClasspathStream = this.buildClasspath.getFiles().stream().map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new GradleException(String.format("Could not create classpath for annotations task %s.", this.getName()), (Throwable)e);
            }
        });
        URL[] urls = (URL[])Stream.concat(classpathStream, buildClasspathStream).distinct().toArray(URL[]::new);
        try (URLClassLoader classLoader = new URLClassLoader(urls);){
            Path path;
            String openapiFileContent;
            File openApiFileHandle;
            Class<?> swaggerLoaderClass = classLoader.loadClass("io.swagger.v3.jaxrs2.integration.SwaggerLoader");
            Object swaggerLoader = swaggerLoaderClass.newInstance();
            Method method = null;
            method = swaggerLoaderClass.getDeclaredMethod("setOutputFormat", String.class);
            method.invoke(swaggerLoader, ((Format)((Object)this.outputFormat.get())).name());
            if (this.openApiFile.isPresent() && (openApiFileHandle = ((RegularFile)this.openApiFile.get()).getAsFile()).exists() && openApiFileHandle.isFile() && StringUtils.isNotBlank((CharSequence)(openapiFileContent = new String(Files.readAllBytes(openApiFileHandle.toPath()), (String)this.encoding.get())))) {
                method = swaggerLoaderClass.getDeclaredMethod("setOpenapiAsString", String.class);
                method.invoke(swaggerLoader, openapiFileContent);
            }
            if (this.resourcePackages.isPresent() && !((Set)this.resourcePackages.get()).isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setResourcePackages", String.class);
                method.invoke(swaggerLoader, ((Set)this.resourcePackages.get()).stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.resourceClasses.isPresent() && !((Set)this.resourceClasses.get()).isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setResourceClasses", String.class);
                method.invoke(swaggerLoader, ((Set)this.resourceClasses.get()).stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.modelConverterClasses.isPresent() && !((Set)this.modelConverterClasses.get()).isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setModelConverterClasses", String.class);
                method.invoke(swaggerLoader, ((Set)this.modelConverterClasses.get()).stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.ignoredRoutes.isPresent() && !((Set)this.ignoredRoutes.get()).isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setIgnoredRoutes", String.class);
                method.invoke(swaggerLoader, ((Set)this.ignoredRoutes.get()).stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.filterClass.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)this.filterClass.get()))) {
                method = swaggerLoaderClass.getDeclaredMethod("setFilterClass", String.class);
                method.invoke(swaggerLoader, this.filterClass.get());
            }
            if (this.readerClass.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)this.readerClass.get()))) {
                method = swaggerLoaderClass.getDeclaredMethod("setReaderClass", String.class);
                method.invoke(swaggerLoader, this.readerClass.get());
            }
            if (this.scannerClass.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)this.scannerClass.get()))) {
                method = swaggerLoaderClass.getDeclaredMethod("setScannerClass", String.class);
                method.invoke(swaggerLoader, this.scannerClass.get());
            }
            if (this.contextId.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)this.contextId.get()))) {
                method = swaggerLoaderClass.getDeclaredMethod("setContextId", String.class);
                method.invoke(swaggerLoader, this.contextId.get());
            }
            if (this.objectMapperProcessorClass.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)this.objectMapperProcessorClass.get()))) {
                method = swaggerLoaderClass.getDeclaredMethod("setObjectMapperProcessorClass", String.class);
                method.invoke(swaggerLoader, this.objectMapperProcessorClass.get());
            }
            if (this.defaultResponseCode.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)this.defaultResponseCode.get()))) {
                method = swaggerLoaderClass.getDeclaredMethod("setDefaultResponseCode", String.class);
                method.invoke(swaggerLoader, this.defaultResponseCode.get());
            }
            method = swaggerLoaderClass.getDeclaredMethod("setPrettyPrint", Boolean.class);
            method.invoke(swaggerLoader, this.prettyPrint.get());
            method = swaggerLoaderClass.getDeclaredMethod("setSortOutput", Boolean.class);
            method.invoke(swaggerLoader, this.sortOutput.get());
            method = swaggerLoaderClass.getDeclaredMethod("setAlwaysResolveAppPath", Boolean.class);
            method.invoke(swaggerLoader, this.alwaysResolveAppPath.get());
            method = swaggerLoaderClass.getDeclaredMethod("setSkipResolveAppPath", Boolean.class);
            method.invoke(swaggerLoader, this.skipResolveAppPath.get());
            method = swaggerLoaderClass.getDeclaredMethod("setReadAllResources", Boolean.class);
            method.invoke(swaggerLoader, this.readAllResources.get());
            if (this.openAPI31.isPresent() && !((Boolean)this.openAPI31.get()).booleanValue() && ((Boolean)this.convertToOpenAPI31.get()).booleanValue()) {
                throw new GradleException("`convertToOpenAPI31` can't be enabled when `openAPI31` support is explicity disabled");
            }
            if (this.openAPI31.isPresent()) {
                method = swaggerLoaderClass.getDeclaredMethod("setOpenAPI31", Boolean.class);
                method.invoke(swaggerLoader, this.openAPI31.get());
            }
            if (this.convertToOpenAPI31.isPresent()) {
                method = swaggerLoaderClass.getDeclaredMethod("setConvertToOpenAPI31", Boolean.class);
                method.invoke(swaggerLoader, this.convertToOpenAPI31.get());
            }
            if (this.schemaResolution.isPresent()) {
                method = swaggerLoaderClass.getDeclaredMethod("setSchemaResolution", String.class);
                method.invoke(swaggerLoader, this.schemaResolution.get());
            }
            if (this.openAPIVersion.isPresent()) {
                method = swaggerLoaderClass.getDeclaredMethod("setOpenAPIVersion", String.class);
                method.invoke(swaggerLoader, this.openAPIVersion.get());
            }
            method = swaggerLoaderClass.getDeclaredMethod("resolve", new Class[0]);
            Map specs = (Map)method.invoke(swaggerLoader, new Object[0]);
            Path outputFile = ((File)this.outputDir.getAsFile().get()).toPath();
            if (specs.get("JSON") != null) {
                path = outputFile.resolve(String.format("%s.json", this.outputFileName.get()));
                Files.write(path, ((String)specs.get("JSON")).getBytes(Charset.forName((String)this.encoding.get())), new OpenOption[0]);
                this.getLogger().debug("Saved openapi to {}", (Object)path.toAbsolutePath());
            }
            if (specs.get("YAML") != null) {
                path = outputFile.resolve(String.format("%s.yaml", this.outputFileName.get()));
                Files.write(path, ((String)specs.get("YAML")).getBytes(Charset.forName((String)this.encoding.get())), new OpenOption[0]);
                this.getLogger().debug("Saved openapi to {}", (Object)path.toAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new GradleException("Failed to write API definition: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    public static enum Format {
        JSON,
        YAML,
        JSONANDYAML;

    }
}

