/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.plugins.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;

@CacheableTask
public class ResolveTask
extends DefaultTask {
    private static Logger LOGGER = Logging.getLogger(ResolveTask.class);
    private String outputFileName = "openapi";
    private String outputPath;
    private File outputDir;
    private File openApiFile;
    private Format outputFormat = Format.JSON;
    private Set<String> resourcePackages;
    private Set<String> resourceClasses;
    private String filterClass;
    private String readerClass;
    private String scannerClass;
    private Boolean prettyPrint = false;
    private Boolean readAllResources = Boolean.TRUE;
    private Collection<String> ignoredRoutes;
    private Iterable<File> buildClasspath;
    private Iterable<File> classpath;
    private Boolean skip = Boolean.FALSE;
    private String encoding = "UTF-8";
    private LinkedHashSet<String> modelConverterClasses;
    private String objectMapperProcessorClass;
    private Boolean sortOutput = Boolean.FALSE;
    private String contextId;

    @Input
    @Optional
    public String getOutputFileName() {
        return this.outputFileName;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getOpenApiFile() {
        return this.openApiFile;
    }

    public void setOpenApiFile(File openApiFile) {
        this.openApiFile = openApiFile;
    }

    @Classpath
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Iterable<File> classpath) {
        this.classpath = classpath;
    }

    @Classpath
    @Optional
    public Iterable<File> getBuildClasspath() {
        return this.buildClasspath;
    }

    public void setBuildClasspath(Iterable<File> buildClasspath) {
        this.buildClasspath = buildClasspath;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Deprecated
    @Input
    @Optional
    public String getOutputPath() {
        return this.outputPath;
    }

    @Deprecated
    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
        this.outputDir = new File(outputPath);
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    @Optional
    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(Format outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Input
    @Optional
    public Set<String> getResourcePackages() {
        return this.resourcePackages;
    }

    public void setResourcePackages(Set<String> resourcePackages) {
        this.resourcePackages = resourcePackages;
    }

    @Input
    @Optional
    public LinkedHashSet<String> getModelConverterClasses() {
        return this.modelConverterClasses;
    }

    public void setModelConverterClasses(LinkedHashSet<String> modelConverterClasses) {
        this.modelConverterClasses = modelConverterClasses;
    }

    @Input
    @Optional
    public Set<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(Set<String> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    @Input
    @Optional
    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    @Input
    @Optional
    public String getReaderClass() {
        return this.readerClass;
    }

    public void setReaderClass(String readerClass) {
        this.readerClass = readerClass;
    }

    @Input
    @Optional
    public String getObjectMapperProcessorClass() {
        return this.objectMapperProcessorClass;
    }

    public void setObjectMapperProcessorClass(String objectMapperProcessorClass) {
        this.objectMapperProcessorClass = objectMapperProcessorClass;
    }

    @Input
    @Optional
    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @Input
    @Optional
    public String getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(String scannerClass) {
        this.scannerClass = scannerClass;
    }

    @Input
    @Optional
    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Input
    @Optional
    public Boolean getReadAllResources() {
        return this.readAllResources;
    }

    public void setReadAllResources(Boolean readAllResources) {
        this.readAllResources = readAllResources;
    }

    @Input
    @Optional
    public Collection<String> getIgnoredRoutes() {
        return this.ignoredRoutes;
    }

    public void setIgnoredRoutes(Collection<String> ignoredRoutes) {
        this.ignoredRoutes = ignoredRoutes;
    }

    @Input
    @Optional
    public Boolean getSkip() {
        return this.skip;
    }

    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String resourceClasses) {
        this.encoding = this.encoding;
    }

    @Input
    @Optional
    public Boolean getSortOutput() {
        return this.sortOutput;
    }

    public void setSortOutput(Boolean sortOutput) {
        this.sortOutput = sortOutput;
    }

    @TaskAction
    public void resolve() throws GradleException {
        if (this.skip.booleanValue()) {
            LOGGER.info("Skipping OpenAPI specification resolution");
            return;
        }
        LOGGER.info("Resolving OpenAPI specification..");
        Set<URL> urls = StreamSupport.stream(this.getClasspath().spliterator(), false).map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new GradleException(String.format("Could not create classpath for annotations task %s.", this.getName()), (Throwable)e);
            }
        }).collect(Collectors.toSet());
        Set buildUrls = StreamSupport.stream(this.getBuildClasspath().spliterator(), false).map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new GradleException(String.format("Could not create classpath for annotations task %s.", this.getName()), (Throwable)e);
            }
        }).collect(Collectors.toSet());
        urls.addAll(buildUrls);
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        try {
            Path path;
            String openapiFileContent;
            Class<?> swaggerLoaderClass = classLoader.loadClass("io.swagger.v3.jaxrs2.integration.SwaggerLoader");
            Object swaggerLoader = swaggerLoaderClass.newInstance();
            Method method = null;
            method = swaggerLoaderClass.getDeclaredMethod("setOutputFormat", String.class);
            method.invoke(swaggerLoader, this.outputFormat.name());
            if (this.openApiFile != null && this.openApiFile.exists() && this.openApiFile.isFile() && StringUtils.isNotBlank((CharSequence)(openapiFileContent = new String(Files.readAllBytes(this.openApiFile.toPath()), this.encoding)))) {
                method = swaggerLoaderClass.getDeclaredMethod("setOpenapiAsString", String.class);
                method.invoke(swaggerLoader, openapiFileContent);
            }
            if (this.resourcePackages != null && !this.resourcePackages.isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setResourcePackages", String.class);
                method.invoke(swaggerLoader, this.resourcePackages.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.resourceClasses != null && !this.resourceClasses.isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setResourceClasses", String.class);
                method.invoke(swaggerLoader, this.resourceClasses.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.modelConverterClasses != null && !this.modelConverterClasses.isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setModelConverterClasses", String.class);
                method.invoke(swaggerLoader, this.modelConverterClasses.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (this.ignoredRoutes != null && !this.ignoredRoutes.isEmpty()) {
                method = swaggerLoaderClass.getDeclaredMethod("setIgnoredRoutes", String.class);
                method.invoke(swaggerLoader, this.ignoredRoutes.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            if (StringUtils.isNotBlank((CharSequence)this.filterClass)) {
                method = swaggerLoaderClass.getDeclaredMethod("setFilterClass", String.class);
                method.invoke(swaggerLoader, this.filterClass);
            }
            if (StringUtils.isNotBlank((CharSequence)this.readerClass)) {
                method = swaggerLoaderClass.getDeclaredMethod("setReaderClass", String.class);
                method.invoke(swaggerLoader, this.readerClass);
            }
            if (StringUtils.isNotBlank((CharSequence)this.scannerClass)) {
                method = swaggerLoaderClass.getDeclaredMethod("setScannerClass", String.class);
                method.invoke(swaggerLoader, this.scannerClass);
            }
            if (StringUtils.isNotBlank((CharSequence)this.contextId)) {
                method = swaggerLoaderClass.getDeclaredMethod("setContextId", String.class);
                method.invoke(swaggerLoader, this.contextId);
            }
            if (StringUtils.isNotBlank((CharSequence)this.objectMapperProcessorClass)) {
                method = swaggerLoaderClass.getDeclaredMethod("setObjectMapperProcessorClass", String.class);
                method.invoke(swaggerLoader, this.objectMapperProcessorClass);
            }
            method = swaggerLoaderClass.getDeclaredMethod("setPrettyPrint", Boolean.class);
            method.invoke(swaggerLoader, this.prettyPrint);
            method = swaggerLoaderClass.getDeclaredMethod("setSortOutput", Boolean.class);
            method.invoke(swaggerLoader, this.sortOutput);
            method = swaggerLoaderClass.getDeclaredMethod("setReadAllResources", Boolean.class);
            method.invoke(swaggerLoader, this.readAllResources);
            method = swaggerLoaderClass.getDeclaredMethod("resolve", new Class[0]);
            Map specs = (Map)method.invoke(swaggerLoader, new Object[0]);
            if (specs.get("JSON") != null) {
                path = this.outputDir.toPath().resolve(String.format("%s.json", this.outputFileName));
                Files.write(path, ((String)specs.get("JSON")).getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
            }
            if (specs.get("YAML") != null) {
                path = this.outputDir.toPath().resolve(String.format("%s.yaml", this.outputFileName));
                Files.write(path, ((String)specs.get("YAML")).getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new GradleException("Failed to write API definition: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    public static enum Format {
        JSON,
        YAML,
        JSONANDYAML;

    }
}

