/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.generator.online;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfigLoader;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.service.GenerationRequest;
import io.swagger.codegen.v3.service.GeneratorService;
import io.swagger.codegen.v3.service.RenderRequest;
import io.swagger.codegen.v3.service.RenderResponse;
import io.swagger.oas.inflector.models.RequestContext;
import io.swagger.oas.inflector.models.ResponseContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.generator.model.HiddenOptions;
import io.swagger.v3.generator.util.FileAccessSecurityManager;
import io.swagger.v3.generator.util.ZipUtil;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeneratorController {
    static Logger LOGGER = LoggerFactory.getLogger(GeneratorController.class);
    static Map<io.swagger.codegen.v3.CodegenType, List<String>> TYPES = new LinkedHashMap();
    static Map<CodegenType, List<String>> TYPESV2 = new LinkedHashMap();
    private static ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static HiddenOptions hiddenOptions;
    private static String HIDDEN_OPTIONS_CONFIG_FILE;
    private static String PROP_HIDDEN_OPTIONS_PATH;
    private static String PROP_HIDDEN_OPTIONS;

    public static HiddenOptions loadHiddenOptions() {
        HiddenOptions options = null;
        String hidden = System.getProperty(PROP_HIDDEN_OPTIONS);
        if (StringUtils.isNotBlank((CharSequence)hidden)) {
            options = GeneratorController.loadHiddenOptionsFromEnv((String)hidden);
        }
        if (options == null) {
            String hiddenPath = System.getProperty(PROP_HIDDEN_OPTIONS_PATH);
            if (StringUtils.isNotBlank((CharSequence)hiddenPath)) {
                options = GeneratorController.loadHiddenOptions((String)hiddenPath);
            }
            if (options == null) {
                InputStream inputStream = GeneratorController.class.getClassLoader().getResourceAsStream(HIDDEN_OPTIONS_CONFIG_FILE);
                try {
                    options = (HiddenOptions)yamlMapper.readValue(inputStream, HiddenOptions.class);
                }
                catch (Exception e) {
                    LOGGER.info("Failed to parse hidden options configuration file {}", (Object)HIDDEN_OPTIONS_CONFIG_FILE, (Object)e);
                    return HiddenOptions.getEmpty();
                }
            }
        }
        if (options != null) {
            LOGGER.debug("Parsed hidden options config");
            LOGGER.debug("Hidden clients: {}", (Object)options.clients());
            LOGGER.debug("Hidden servers: {}", (Object)options.servers());
            LOGGER.debug("Hidden clientsV3: {}", (Object)options.clientsV3());
            LOGGER.debug("Hidden serversV3: {}", (Object)options.serversV3());
            return options;
        }
        return HiddenOptions.getEmpty();
    }

    public static HiddenOptions loadHiddenOptionsFromEnv(String csv) {
        try {
            String[] sections;
            HiddenOptions options = new HiddenOptions();
            block14: for (String section : sections = csv.split("\\|")) {
                String[] keyval = section.split("\\:");
                switch (keyval[0]) {
                    case "clients": {
                        options.getClients().addAll(Arrays.asList(keyval[1].split("\\,")));
                        continue block14;
                    }
                    case "clientsV3": {
                        options.getClientsV3().addAll(Arrays.asList(keyval[1].split("\\,")));
                        continue block14;
                    }
                    case "servers": {
                        options.getServers().addAll(Arrays.asList(keyval[1].split("\\,")));
                        continue block14;
                    }
                    case "serversV3": {
                        options.getServersV3().addAll(Arrays.asList(keyval[1].split("\\,")));
                        continue block14;
                    }
                }
            }
            return options;
        }
        catch (Exception e) {
            LOGGER.info("Failed to parse hidden options. String {}", (Object)csv, (Object)e);
            return null;
        }
    }

    public static HiddenOptions loadHiddenOptions(String location) {
        try {
            String data = "";
            location = location.replaceAll("\\\\", "/");
            if (location.toLowerCase().startsWith("http")) {
                data = RemoteUrl.urlToString((String)location, null);
            } else {
                String fileScheme = "file:";
                Path path = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
                data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath((String)location);
            }
            return (HiddenOptions)yamlMapper.readValue(data, HiddenOptions.class);
        }
        catch (Exception e) {
            LOGGER.info("Failed to parse hidden options. Path {}", (Object)location, (Object)e);
            return null;
        }
    }

    @Deprecated
    public ResponseContext clientLanguages(RequestContext requestContext, String version, Boolean clientOnly) {
        ArrayList clientAndDoc = new ArrayList();
        if ("V2".equals(version)) {
            clientAndDoc.addAll((Collection)TYPESV2.get(CodegenType.CLIENT));
            if (!Boolean.TRUE.equals(clientOnly)) {
                clientAndDoc.addAll((Collection)TYPESV2.get(CodegenType.DOCUMENTATION));
            }
            Collections.sort(clientAndDoc, String.CASE_INSENSITIVE_ORDER);
            return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(clientAndDoc);
        }
        clientAndDoc.addAll((Collection)TYPES.get(io.swagger.codegen.v3.CodegenType.CLIENT));
        if (!Boolean.TRUE.equals(clientOnly)) {
            clientAndDoc.addAll((Collection)TYPES.get(io.swagger.codegen.v3.CodegenType.DOCUMENTATION));
        }
        Collections.sort(clientAndDoc, String.CASE_INSENSITIVE_ORDER);
        return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(clientAndDoc);
    }

    @Deprecated
    public ResponseContext serverLanguages(RequestContext requestContext, String version) {
        if ("V2".equals(version)) {
            return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(TYPESV2.get(CodegenType.SERVER));
        }
        return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(TYPES.get(io.swagger.codegen.v3.CodegenType.SERVER));
    }

    @Deprecated
    public ResponseContext documentationLanguages(RequestContext requestContext, String version) {
        if ("V2".equals(version)) {
            return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(TYPESV2.get(CodegenType.DOCUMENTATION));
        }
        return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(TYPES.get(io.swagger.codegen.v3.CodegenType.DOCUMENTATION));
    }

    public ResponseContext languages(RequestContext requestContext, String type, String version) {
        if ("V2".equals(version)) {
            CodegenType codegenType = CodegenType.forValue((String)type);
            return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(TYPESV2.get(codegenType));
        }
        io.swagger.codegen.v3.CodegenType codegenTypeV3 = io.swagger.codegen.v3.CodegenType.forValue((String)type);
        return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(TYPES.get(codegenTypeV3));
    }

    public ResponseContext languagesMulti(RequestContext requestContext, List<String> types, String version) {
        ArrayList languages = new ArrayList();
        if ("V2".equals(version)) {
            types.forEach(s -> {
                List typeLanguages = (List)TYPESV2.get(CodegenType.forValue((String)s));
                if (typeLanguages != null) {
                    languages.addAll(typeLanguages);
                }
            });
            Collections.sort(languages, String.CASE_INSENSITIVE_ORDER);
            return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(languages);
        }
        types.forEach(s -> {
            List typeLanguages = (List)TYPES.get(io.swagger.codegen.v3.CodegenType.forValue((String)s));
            if (typeLanguages != null) {
                languages.addAll(typeLanguages);
            }
        });
        Collections.sort(languages, String.CASE_INSENSITIVE_ORDER);
        return new ResponseContext().status(Response.Status.OK.getStatusCode()).entity(languages);
    }

    public ResponseContext listOptions(RequestContext requestContext, String language, String version) {
        if ("V2".equals(version)) {
            io.swagger.codegen.CodegenConfig config = null;
            try {
                config = CodegenConfigLoader.forName((String)language);
            }
            catch (Exception e) {
                String msg = String.format("Unsupported target %s supplied.", language);
                LOGGER.error(msg, (Throwable)e);
                return new ResponseContext().status(400).contentType("text/plain").entity((Object)msg);
            }
            LinkedHashMap<String, CliOption> map = new LinkedHashMap<String, CliOption>();
            for (CliOption option : config.cliOptions()) {
                map.put(option.getOpt(), option);
            }
            if (!map.isEmpty()) {
                return new ResponseContext().status(200).entity(map);
            }
            return new ResponseContext().status(404);
        }
        CodegenConfig config = null;
        try {
            config = io.swagger.codegen.v3.CodegenConfigLoader.forName((String)language);
        }
        catch (Exception e) {
            String msg = String.format("Unsupported target %s supplied.", language);
            LOGGER.error(msg, (Throwable)e);
            return new ResponseContext().status(400).contentType("text/plain").entity((Object)msg);
        }
        LinkedHashMap<String, io.swagger.codegen.v3.CliOption> map = new LinkedHashMap<String, io.swagger.codegen.v3.CliOption>();
        for (io.swagger.codegen.v3.CliOption option : config.cliOptions()) {
            map.put(option.getOpt(), option);
        }
        if (!map.isEmpty()) {
            return new ResponseContext().status(200).entity(map);
        }
        return new ResponseContext().status(404);
    }

    public ResponseContext generateFromURL(RequestContext context, String codegenOptionsURL) {
        String content;
        LOGGER.debug("generateFromURL start - " + codegenOptionsURL);
        try {
            content = RemoteUrl.urlToString((String)codegenOptionsURL, null);
        }
        catch (Exception e) {
            String msg = "Unable to read URL: " + codegenOptionsURL;
            LOGGER.error(msg, (Throwable)e);
            return new ResponseContext().status(400).contentType("text/plain").entity((Object)msg);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            String msg = "Empty content found in URL: " + codegenOptionsURL;
            LOGGER.error(msg);
            return new ResponseContext().status(404).contentType("text/plain").entity((Object)msg);
        }
        GenerationRequest generationRequest = null;
        try {
            generationRequest = (GenerationRequest)Json.mapper().readValue(content, GenerationRequest.class);
        }
        catch (Exception e) {
            try {
                generationRequest = (GenerationRequest)Yaml.mapper().readValue(content, GenerationRequest.class);
            }
            catch (Exception ee) {
                String msg = "Could not process content of URL: " + codegenOptionsURL;
                LOGGER.error(msg, (Throwable)ee);
                return new ResponseContext().status(400).contentType("text/plain").entity((Object)msg);
            }
        }
        ResponseContext responseContext = this.generate(context, generationRequest);
        LOGGER.debug("generateFromURL end - " + codegenOptionsURL);
        return responseContext;
    }

    private String requestLog(GenerationRequest generationRequest) {
        int maxLength = 41;
        StringBuffer requestLog = new StringBuffer();
        requestLog.append("lang: ");
        requestLog.append(generationRequest.getLang());
        requestLog.append(", ");
        requestLog.append("version: ");
        requestLog.append(generationRequest.getCodegenVersion().name());
        requestLog.append(", ");
        requestLog.append("specURL: ");
        requestLog.append(generationRequest.getSpecURL());
        requestLog.append(", ");
        if (generationRequest.getSpec() != null) {
            String spec = null;
            if (generationRequest.getSpec() instanceof String && StringUtils.isNotBlank((CharSequence)((String)generationRequest.getSpec()))) {
                spec = ((String)generationRequest.getSpec()).length() > 41 ? ((String)generationRequest.getSpec()).substring(0, 40) : (String)generationRequest.getSpec();
                requestLog.append("spec: ");
                requestLog.append(spec);
                requestLog.append(", ");
            } else {
                try {
                    spec = Json.pretty((Object)generationRequest.getSpec());
                    if (spec.length() > 41) {
                        spec = spec.substring(0, 40);
                    }
                    requestLog.append("spec: ");
                    requestLog.append(spec);
                    requestLog.append(", ");
                }
                catch (Exception e) {
                    requestLog.append("spec: ");
                    requestLog.append(spec);
                    requestLog.append(", ");
                }
            }
        }
        if (generationRequest.getOptions() != null && StringUtils.isNotBlank((CharSequence)generationRequest.getOptions().getLibrary())) {
            requestLog.append("lib: ");
            requestLog.append(generationRequest.getOptions().getLibrary());
        }
        return requestLog.toString();
    }

    public ResponseContext generate(RequestContext context, GenerationRequest generationRequest) {
        Object destPathObj;
        String requestLog = this.requestLog(generationRequest);
        LOGGER.debug("generate start - " + requestLog);
        File outputRootFolder = GeneratorController.getTmpFolder();
        String destPath = null;
        if (generationRequest != null && generationRequest.getOptions() != null && (destPathObj = generationRequest.getOptions().getAdditionalProperties().get("outputFolder")) != null && destPathObj instanceof String) {
            destPath = (String)destPathObj;
        }
        if (destPath == null) {
            destPath = "";
        }
        destPath.replaceAll("//", "/");
        if (destPath.indexOf("..") != -1) {
            return new ResponseContext().status(400).contentType("text/plain").entity((Object)"Illegal output folder");
        }
        if (destPath.indexOf("/") == 0 && destPath.length() > 1) {
            destPath = destPath.substring(1);
        }
        LOGGER.info("using destination path " + destPath);
        File outputContentFolder = null;
        outputContentFolder = !StringUtils.isBlank((CharSequence)destPath.trim()) ? new File(outputRootFolder, destPath) : outputRootFolder;
        generationRequest.getOptions().setOutputDir(outputContentFolder.getAbsolutePath());
        File outputFile = new File(GeneratorController.getTmpFolder(), generationRequest.getLang() + "-bundle.zip");
        LOGGER.info("file zip file: " + outputFile.getAbsolutePath());
        ResponseContext responseContext = this.generate(generationRequest, outputRootFolder, outputContentFolder, outputFile);
        LOGGER.debug("generate end - " + requestLog);
        return responseContext;
    }

    public ResponseContext renderTemplate(RequestContext context, RenderRequest renderRequest) {
        String result = new GeneratorService().renderTemplate(renderRequest);
        RenderResponse response = new RenderResponse();
        response.setValue(result);
        return new ResponseContext().status(200).contentType(MediaType.APPLICATION_JSON_TYPE).entity((Object)response);
    }

    public ResponseContext generateBundle(RequestContext context, GenerationRequest generationRequest) {
        Object destPathObj;
        String requestLog = this.requestLog(generationRequest);
        LOGGER.debug("generate start - " + requestLog);
        File outputRootFolder = GeneratorController.getTmpFolder();
        String destPath = null;
        if (generationRequest != null && generationRequest.getOptions() != null && (destPathObj = generationRequest.getOptions().getAdditionalProperties().get("outputFolder")) != null && destPathObj instanceof String) {
            destPath = (String)destPathObj;
        }
        if (destPath == null) {
            destPath = "";
        }
        destPath.replaceAll("//", "/");
        if (destPath.indexOf("..") != -1) {
            return new ResponseContext().status(400).contentType("text/plain").entity((Object)"Illegal output folder");
        }
        if (destPath.indexOf("/") == 0 && destPath.length() > 1) {
            destPath = destPath.substring(1);
        }
        LOGGER.info("using destination path " + destPath);
        File outputContentFolder = null;
        outputContentFolder = !StringUtils.isBlank((CharSequence)destPath.trim()) ? new File(outputRootFolder, destPath) : outputRootFolder;
        generationRequest.getOptions().setOutputDir(outputContentFolder.getAbsolutePath());
        File outputFile = new File(GeneratorController.getTmpFolder(), generationRequest.getLang() + "-bundle.zip");
        LOGGER.info("file zip file: " + outputFile.getAbsolutePath());
        ResponseContext responseContext = this.generateBundle(generationRequest, outputRootFolder, outputContentFolder, outputFile);
        LOGGER.debug("generate end - " + requestLog);
        return responseContext;
    }

    protected static File getTmpFolder() {
        try {
            File outputFolder = Files.createTempDirectory("codegen-", new FileAttribute[0]).toFile();
            outputFolder.deleteOnExit();
            return outputFolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ResponseContext generate(GenerationRequest generationRequest, File outputRootFolder, File outputContentFolder, File outputFile) {
        List files;
        GeneratorService generatorService = new GeneratorService();
        try {
            generatorService.generationRequest(generationRequest);
        }
        catch (Exception e2) {
            String msg = "Error processing generation request: " + e2.getMessage();
            LOGGER.error(msg, (Throwable)e2);
            return new ResponseContext().status(400).contentType("text/plain").entity((Object)msg);
        }
        try {
            files = generatorService.generate();
        }
        catch (Exception e3) {
            String msg = String.format("Error generating `%s` code : %s", generationRequest.getLang(), e3.getMessage());
            LOGGER.error(msg, (Throwable)e3);
            return new ResponseContext().status(500).contentType("text/plain").entity((Object)msg);
        }
        if (files.size() > 0) {
            if (generationRequest.getType() == null) {
                String lang = generationRequest.getLang();
                if (GenerationRequest.CodegenVersion.V2.equals((Object)generationRequest.getCodegenVersion())) {
                    TYPESV2.entrySet().stream().filter(e -> ((List)e.getValue()).contains(lang)).findFirst().ifPresent(e -> generationRequest.type(GenerationRequest.Type.fromValue((String)((CodegenType)e.getKey()).toValue())));
                } else {
                    TYPES.entrySet().stream().filter(e -> ((List)e.getValue()).contains(lang)).findFirst().ifPresent(e -> generationRequest.type(GenerationRequest.Type.fromValue((String)((io.swagger.codegen.v3.CodegenType)e.getKey()).toValue())));
                }
                if (generationRequest.getType() == null) {
                    generationRequest.type(GenerationRequest.Type.CLIENT);
                }
            }
            return this.downloadFile(outputRootFolder, outputContentFolder, outputFile, generationRequest.getLang(), generationRequest.getType());
        }
        return new ResponseContext().status(500).contentType("text/plain").entity((Object)"A target generation was attempted, but no files were created");
    }

    private ResponseContext generateBundle(GenerationRequest generationRequest, File outputRootFolder, File outputContentFolder, File outputFile) {
        Map files;
        GeneratorService generatorService = new GeneratorService();
        try {
            generatorService.generationRequest(generationRequest);
        }
        catch (Exception e) {
            String msg = "Error processing generation request: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            return new ResponseContext().status(400).contentType("text/plain").entity((Object)msg);
        }
        try {
            files = generatorService.generateBundle();
        }
        catch (Exception e) {
            String msg = String.format("Error generating `%s` code : %s", generationRequest.getLang(), e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            return new ResponseContext().status(500).contentType("text/plain").entity((Object)msg);
        }
        if (files.size() > 0) {
            return new ResponseContext().status(200).contentType(MediaType.APPLICATION_JSON_TYPE).entity((Object)files);
        }
        return new ResponseContext().status(500).contentType("text/plain").entity((Object)"A target generation was attempted, but no files were created");
    }

    private ResponseContext downloadFile(File outputRootFolder, File outputContentFolder, File outputFile, String lang, GenerationRequest.Type type) {
        ZipUtil zipUtil = new ZipUtil();
        try {
            zipUtil.compressFiles(Arrays.asList(outputRootFolder.listFiles()), outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            return new ResponseContext().status(500).contentType("text/plain").entity((Object)"Could not generate zip file.");
        }
        if (!outputFile.exists()) {
            return new ResponseContext().status(500).contentType("text/plain").entity((Object)"File was not generated.");
        }
        byte[] bytes = null;
        try {
            bytes = FileUtils.readFileToByteArray((File)outputFile);
        }
        catch (IOException ex) {
            LOGGER.error("Error converting file to bytes.", (Throwable)ex);
            bytes = null;
        }
        try {
            FileUtils.deleteDirectory((File)outputRootFolder);
        }
        catch (IOException ex) {
            LOGGER.error("Could not delete files.", (Throwable)ex);
        }
        if (bytes != null) {
            String friendlyName = lang + "-" + type.getTypeName();
            return new ResponseContext().status(200).entity((Object)bytes).contentType(MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", String.format("attachment; filename=\"%s-generated.zip\"", friendlyName)).header("Accept-Range", "bytes").header("Content-Length", String.valueOf(bytes.length));
        }
        return new ResponseContext().status(500).contentType("text/plain").entity((Object)"Could not generate files.");
    }

    static {
        HIDDEN_OPTIONS_CONFIG_FILE = "hiddenOptions.yaml";
        PROP_HIDDEN_OPTIONS_PATH = "HIDDEN_OPTIONS_PATH";
        PROP_HIDDEN_OPTIONS = "HIDDEN_OPTIONS";
        System.setSecurityManager((SecurityManager)new FileAccessSecurityManager());
        Security.setProperty("networkaddress.cache.ttl", "60");
        hiddenOptions = GeneratorController.loadHiddenOptions();
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class);
        loader.forEach(config -> {
            boolean isServer = io.swagger.codegen.v3.CodegenType.SERVER.equals((Object)config.getTag());
            boolean process = false;
            if (isServer && !hiddenOptions.isHiddenServerV3(config.getName())) {
                process = true;
            } else if (!isServer && !hiddenOptions.isHiddenClientV3(config.getName())) {
                process = true;
            }
            if (process) {
                ArrayList<String> typeLanguages = (ArrayList<String>)TYPES.get(config.getTag());
                if (typeLanguages == null) {
                    typeLanguages = new ArrayList<String>();
                    TYPES.put(config.getTag(), typeLanguages);
                }
                typeLanguages.add(config.getName());
            }
        });
        TYPES.forEach((k, v) -> Collections.sort(v, String.CASE_INSENSITIVE_ORDER));
        ServiceLoader<io.swagger.codegen.CodegenConfig> loaderV2 = ServiceLoader.load(io.swagger.codegen.CodegenConfig.class);
        loaderV2.forEach(config -> {
            boolean isServer = CodegenType.SERVER.equals((Object)config.getTag());
            boolean process = false;
            if (isServer && !hiddenOptions.isHiddenServer(config.getName())) {
                process = true;
            } else if (!isServer && !hiddenOptions.isHiddenClient(config.getName())) {
                process = true;
            }
            if (process) {
                ArrayList<String> typeLanguages = (ArrayList<String>)TYPESV2.get(config.getTag());
                if (typeLanguages == null) {
                    typeLanguages = new ArrayList<String>();
                    TYPESV2.put(config.getTag(), typeLanguages);
                }
                typeLanguages.add(config.getName());
            }
        });
        TYPESV2.forEach((k, v) -> Collections.sort(v, String.CASE_INSENSITIVE_ORDER));
    }
}

