/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.templates;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.templates.TemplateEngine;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HandlebarTemplateEngine
implements TemplateEngine {
    private CodegenConfig config;

    public HandlebarTemplateEngine(CodegenConfig config) {
        this.config = config;
    }

    @Override
    public String getRendered(String templateFile, Map<String, Object> templateData) throws IOException {
        Template hTemplate = this.getHandlebars(templateFile);
        return hTemplate.apply(templateData);
    }

    @Override
    public String getName() {
        return "handlebars";
    }

    private Template getHandlebars(String templateFile) throws IOException {
        boolean needFileTemplateLoader = StringUtils.isNotBlank((CharSequence)this.config.customTemplateDir());
        boolean fileExist = new File(templateFile).exists();
        templateFile = templateFile.replace(".mustache", "").replace("\\", "/");
        FileTemplateLoader templateLoader = null;
        if (needFileTemplateLoader && fileExist) {
            String templateDir = this.config.customTemplateDir().replace("\\", "/");
            templateFile = this.resolveTemplateFile(templateDir, templateFile);
            templateLoader = new FileTemplateLoader(templateDir, ".mustache");
        } else {
            String templateDir = this.config.templateDir().replace("\\", "/");
            templateFile = this.resolveTemplateFile(templateDir, templateFile);
            templateLoader = new ClassPathTemplateLoader("/" + templateDir, ".mustache");
        }
        Handlebars handlebars = new Handlebars((TemplateLoader)templateLoader);
        handlebars.prettyPrint(true);
        this.config.addHandlebarHelpers(handlebars);
        return handlebars.compile(templateFile);
    }

    private String resolveTemplateFile(String templateDir, String templateFile) {
        if (templateFile.startsWith(templateDir)) {
            templateFile = StringUtils.replaceOnce((String)templateFile, (String)templateDir, (String)"");
        }
        return templateFile;
    }
}

