/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.utils;

import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLPathUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(URLPathUtil.class);
    public static String DEFAULT_PATH = "/";
    public static final String LOCAL_HOST = "http://localhost:8080/";

    public static URL getServerURL(OpenAPI openAPI) {
        List servers = openAPI.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        Server server = (Server)servers.get(0);
        String url = server.getUrl();
        if (url.equals(DEFAULT_PATH)) {
            url = LOCAL_HOST;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Not valid URL: " + server.getUrl(), (Throwable)e);
            return null;
        }
    }

    public static String getScheme(OpenAPI openAPI, CodegenConfig config) {
        URL url = URLPathUtil.getServerURL(openAPI);
        String scheme = url != null ? url.getProtocol() : "https";
        if (config != null) {
            scheme = config.escapeText(scheme);
        }
        return scheme;
    }

    public static String getHost(OpenAPI openAPI) {
        if (openAPI.getServers() != null && openAPI.getServers().size() > 0) {
            return ((Server)openAPI.getServers().get(0)).getUrl();
        }
        return LOCAL_HOST;
    }
}

