/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.typescript;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.typescript.AbstractTypeScriptClientCodegen;
import io.swagger.codegen.v3.utils.SemVer;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptAngularClientCodegen
extends AbstractTypeScriptClientCodegen {
    private static Logger LOGGER = LoggerFactory.getLogger(TypeScriptAngularClientCodegen.class);
    private static final SimpleDateFormat SNAPSHOT_SUFFIX_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String SNAPSHOT = "snapshot";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String NG_VERSION = "ngVersion";
    public static final String NG_PACKAGR = "useNgPackagr";
    public static final String PROVIDED_IN_ROOT = "providedInRoot";
    public static final String KEBAB_FILE_NAME = "kebab-file-name";
    public static final String USE_OVERRIDE = "useOverride";
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String npmRepository = null;
    protected boolean kebabFileNaming;

    public TypeScriptAngularClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "typescript-angular";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package"));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(SNAPSHOT, "When setting this property to true the version will be suffixed with -SNAPSHOT.yyyyMMddHHmm", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(NG_VERSION, "The version of Angular. Default is '4.3'"));
        this.cliOptions.add(new CliOption(PROVIDED_IN_ROOT, "Use this property to provide Injectables in root (it is only valid in angular version greater or equal to 6.0.0).", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(USE_OVERRIDE, "Use this property to place `override` keyword in encoder methods.", "boolean").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        if (schema instanceof MapSchema && TypeScriptAngularClientCodegen.hasSchemaProperties(schema)) {
            codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)schema.getAdditionalProperties());
            this.addImport(codegenModel, codegenModel.additionalPropertiesType);
        } else if (schema instanceof MapSchema && TypeScriptAngularClientCodegen.hasTrueAdditionalProperties(schema)) {
            codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)new ObjectSchema());
        }
    }

    public String getName() {
        return "typescript-angular";
    }

    public String getHelp() {
        return "Generates a TypeScript Angular (2.x or 4.x) client library.";
    }

    @Override
    public void processOpts() {
        boolean withInterfaces;
        super.processOpts();
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.service.mustache", ".ts");
        this.languageSpecificPrimitives.add("Blob");
        this.typeMapping.put("file", "Blob");
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', '/'), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', '/'), "api.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("api.module.mustache", this.getIndexDirectory(), "api.module.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.getIndexDirectory(), "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("variables.mustache", this.getIndexDirectory(), "variables.ts"));
        this.supportingFiles.add(new SupportingFile("encoder.mustache", this.getIndexDirectory(), "encoder.ts"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("npmignore", "", ".npmignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        SemVer ngVersion = this.determineNgVersion();
        this.additionalProperties.put(NG_VERSION, ngVersion);
        if (!ngVersion.atLeast("4.0.0")) {
            LOGGER.warn("Please update your legacy Angular " + ngVersion + " project to benefit from 'Angular Package Format' support.");
            this.additionalProperties.put(NG_PACKAGR, false);
        } else {
            this.additionalProperties.put(NG_PACKAGR, true);
        }
        if (ngVersion.atLeast("8.0.0")) {
            this.additionalProperties.put("rxjsVersion", "6.5.0");
            this.additionalProperties.put("useRxJS6", true);
        } else if (ngVersion.atLeast("7.0.0")) {
            this.additionalProperties.put("rxjsVersion", "6.3.0");
            this.additionalProperties.put("useRxJS6", true);
        } else if (ngVersion.atLeast("6.0.0")) {
            this.additionalProperties.put("rxjsVersion", "6.1.0");
            this.additionalProperties.put("useRxJS6", true);
        } else {
            this.additionalProperties.put("rxjsVersion", "5.4.0");
        }
        if (!ngVersion.atLeast("4.3.0")) {
            this.supportingFiles.add(new SupportingFile("rxjs-operators.mustache", this.getIndexDirectory(), "rxjs-operators.ts"));
        }
        if (ngVersion.atLeast("7.0.0")) {
            this.additionalProperties.put("genericModuleWithProviders", true);
        }
        if (!ngVersion.atLeast("4.0.0")) {
            LOGGER.warn("Please update your legacy Angular " + ngVersion + " project to benefit from 'Angular Package Format' support.");
            this.additionalProperties.put(NG_PACKAGR, false);
        } else {
            this.additionalProperties.put(NG_PACKAGR, true);
            this.supportingFiles.add(new SupportingFile("ng-package.mustache", this.getIndexDirectory(), "ng-package.json"));
        }
        this.additionalProperties.put("useOldNgPackagr", !ngVersion.atLeast("5.0.0"));
        if (ngVersion.atLeast("8.0.0")) {
            this.additionalProperties.put("useHttpClient", true);
        } else if (ngVersion.atLeast("4.3.0")) {
            this.additionalProperties.put("useHttpClient", true);
        } else {
            this.additionalProperties.put("useHttpClient", false);
        }
        if (this.additionalProperties.containsKey(PROVIDED_IN_ROOT) && !ngVersion.atLeast("6.0.0")) {
            this.additionalProperties.put(PROVIDED_IN_ROOT, false);
        }
        this.additionalProperties.put("injectionToken", ngVersion.atLeast("4.0.0") ? "InjectionToken" : "OpaqueToken");
        this.additionalProperties.put("injectionTokenTyped", ngVersion.atLeast("4.0.0"));
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.addNpmPackageGeneration(ngVersion);
        }
        if (this.additionalProperties.containsKey(WITH_INTERFACES) && (withInterfaces = Boolean.parseBoolean(this.additionalProperties.get(WITH_INTERFACES).toString()))) {
            this.apiTemplateFiles.put("apiInterface.mustache", "Interface.ts");
        }
        if (this.additionalProperties.containsKey(USE_OVERRIDE)) {
            boolean useOverride = Boolean.parseBoolean(String.valueOf(this.additionalProperties.get(USE_OVERRIDE)));
            this.additionalProperties.put(USE_OVERRIDE, useOverride);
        }
        this.kebabFileNaming = Boolean.parseBoolean(String.valueOf(this.additionalProperties.get(KEBAB_FILE_NAME)));
    }

    private SemVer determineNgVersion() {
        SemVer ngVersion;
        if (this.additionalProperties.containsKey(NG_VERSION)) {
            ngVersion = new SemVer(this.additionalProperties.get(NG_VERSION).toString());
        } else {
            ngVersion = new SemVer("8.0.0");
            LOGGER.info("generating code for Angular {} ...", (Object)ngVersion);
            LOGGER.info("  (you can select the angular version by setting the additionalProperty ngVersion)");
        }
        return ngVersion;
    }

    private void addNpmPackageGeneration(SemVer ngVersion) {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.parseBoolean(this.additionalProperties.get(SNAPSHOT).toString())) {
            this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
        }
        this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.additionalProperties.put("useHttpClientPackage", false);
        if (ngVersion.atLeast("15.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.8.2 <4.10.0");
            this.additionalProperties.put("rxjsVersion", "7.5.5");
            this.additionalProperties.put("ngPackagrVersion", "15.0.2");
            this.additionalProperties.put("zonejsVersion", "0.11.5");
        } else if (ngVersion.atLeast("14.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.6.0 <=4.8.0");
            this.additionalProperties.put("rxjsVersion", "7.5.5");
            this.additionalProperties.put("ngPackagrVersion", "14.0.2");
            this.additionalProperties.put("zonejsVersion", "0.11.5");
        } else if (ngVersion.atLeast("13.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.4.2 <4.5.0");
            this.additionalProperties.put("rxjsVersion", "7.4.0");
            this.additionalProperties.put("ngPackagrVersion", "13.0.3");
            this.additionalProperties.put("zonejsVersion", "0.11.4");
        } else if (ngVersion.atLeast("12.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.3.0 <4.4.0");
            this.additionalProperties.put("rxjsVersion", "7.4.0");
            this.additionalProperties.put("ngPackagrVersion", "12.2.1");
            this.additionalProperties.put("zonejsVersion", "0.11.4");
        } else if (ngVersion.atLeast("11.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.0.0 <4.1.0");
            this.additionalProperties.put("rxjsVersion", "6.6.0");
            this.additionalProperties.put("ngPackagrVersion", "11.0.2");
            this.additionalProperties.put("zonejsVersion", "0.11.3");
        } else if (ngVersion.atLeast("10.0.0")) {
            this.additionalProperties.put("tsVersion", ">=3.9.2 <4.0.0");
            this.additionalProperties.put("rxjsVersion", "6.6.0");
            this.additionalProperties.put("ngPackagrVersion", "10.0.3");
            this.additionalProperties.put("zonejsVersion", "0.10.2");
        } else if (ngVersion.atLeast("9.0.0")) {
            this.additionalProperties.put("tsVersion", ">=3.6.0 <3.8.0");
            this.additionalProperties.put("rxjsVersion", "6.5.3");
            this.additionalProperties.put("ngPackagrVersion", "9.0.1");
            this.additionalProperties.put("zonejsVersion", "0.10.2");
        } else if (ngVersion.atLeast("8.0.0")) {
            this.additionalProperties.put("tsVersion", ">=3.4.0 <3.6.0");
            this.additionalProperties.put("rxjsVersion", "6.5.0");
            this.additionalProperties.put("ngPackagrVersion", "5.4.0");
            this.additionalProperties.put("zonejsVersion", "0.9.1");
        } else if (ngVersion.atLeast("7.0.0")) {
            this.additionalProperties.put("tsVersion", ">=3.1.1 <3.2.0");
            this.additionalProperties.put("rxjsVersion", "6.3.0");
            this.additionalProperties.put("ngPackagrVersion", "5.1.0");
            this.additionalProperties.put("zonejsVersion", "0.8.26");
            this.additionalProperties.put("useHttpClientPackage", true);
        } else if (ngVersion.atLeast("6.0.0")) {
            this.additionalProperties.put("tsVersion", ">=2.7.2 and <2.10.0");
            this.additionalProperties.put("rxjsVersion", "6.1.0");
            this.additionalProperties.put("ngPackagrVersion", "3.0.6");
            this.additionalProperties.put("zonejsVersion", "0.8.26");
            this.additionalProperties.put("useHttpClientPackage", true);
        } else {
            this.additionalProperties.put("tsVersion", ">=2.1.5 and <2.8");
            this.additionalProperties.put("rxjsVersion", "6.1.0");
            this.additionalProperties.put("ngPackagrVersion", "3.0.6");
            this.additionalProperties.put("zonejsVersion", "0.8.26");
            this.additionalProperties.put("useHttpClientPackage", true);
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getIndexDirectory(), "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", this.getIndexDirectory(), "package.json"));
        this.supportingFiles.add(new SupportingFile("typings.mustache", this.getIndexDirectory(), "typings.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getIndexDirectory(), "tsconfig.json"));
        if (this.additionalProperties.containsKey(NG_PACKAGR) && Boolean.valueOf(this.additionalProperties.get(NG_PACKAGR).toString()).booleanValue()) {
            this.supportingFiles.add(new SupportingFile("ng-package.mustache", this.getIndexDirectory(), "ng-package.json"));
        }
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("Blob");
    }

    @Override
    public String getArgumentsLocation() {
        return null;
    }

    @Override
    public String getDefaultTemplateDir() {
        return "typescript-angular";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            Schema inner = arraySchema.getItems();
            return this.getSchemaType(propertySchema) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (propertySchema instanceof MapSchema && TypeScriptAngularClientCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return "{ [key: string]: " + this.getTypeDeclaration(inner) + "; }";
        }
        if (propertySchema instanceof MapSchema && TypeScriptAngularClientCodegen.hasTrueAdditionalProperties(propertySchema)) {
            ObjectSchema inner = new ObjectSchema();
            return "{ [key: string]: " + this.getTypeDeclaration((Schema)inner) + "; }";
        }
        if (propertySchema instanceof FileSchema || propertySchema instanceof BinarySchema) {
            return "Blob";
        }
        if (propertySchema instanceof ObjectSchema) {
            return "any";
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        if (this.isLanguagePrimitive(swaggerType) || this.isLanguageGenericType(swaggerType)) {
            return swaggerType;
        }
        this.applyLocalTypeMapping(swaggerType);
        return swaggerType;
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addOperationImports(CodegenOperation codegenOperation, Set<String> operationImports) {
        for (String operationImport : operationImports) {
            if (operationImport.contains("|")) {
                String[] importNames;
                for (String importName : importNames = operationImport.split("\\|")) {
                    if (!this.needToImport(importName = importName.trim())) continue;
                    codegenOperation.imports.add(importName);
                }
                continue;
            }
            if (!this.needToImport(operationImport)) continue;
            codegenOperation.imports.add(operationImport);
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.applyLocalTypeMapping(parameter.dataType);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> operations) {
        Map objs = (Map)operations.get("operations");
        objs.put("apiFilename", this.getApiFilenameFromClassname(objs.get("classname").toString()));
        List ops = (List)objs.get("operation");
        for (CodegenOperation op : ops) {
            if (((Boolean)this.additionalProperties.get("useHttpClient")).booleanValue()) {
                op.httpMethod = op.httpMethod.toLowerCase(Locale.ENGLISH);
            } else {
                switch (op.httpMethod) {
                    case "GET": {
                        op.httpMethod = "RequestMethod.Get";
                        break;
                    }
                    case "POST": {
                        op.httpMethod = "RequestMethod.Post";
                        break;
                    }
                    case "PUT": {
                        op.httpMethod = "RequestMethod.Put";
                        break;
                    }
                    case "DELETE": {
                        op.httpMethod = "RequestMethod.Delete";
                        break;
                    }
                    case "OPTIONS": {
                        op.httpMethod = "RequestMethod.Options";
                        break;
                    }
                    case "HEAD": {
                        op.httpMethod = "RequestMethod.Head";
                        break;
                    }
                    case "PATCH": {
                        op.httpMethod = "RequestMethod.Patch";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown HTTP Method " + op.httpMethod + " not allowed");
                    }
                }
            }
            StringBuilder pathBuffer = new StringBuilder();
            StringBuilder parameterName = new StringBuilder();
            int insideCurly = 0;
            block23: for (int i = 0; i < op.path.length(); ++i) {
                switch (op.path.charAt(i)) {
                    case '{': {
                        ++insideCurly;
                        pathBuffer.append("${encodeURIComponent(String(");
                        continue block23;
                    }
                    case '}': {
                        --insideCurly;
                        pathBuffer.append(this.toVarName(parameterName.toString()));
                        pathBuffer.append("))}");
                        parameterName.setLength(0);
                        continue block23;
                    }
                    default: {
                        if (insideCurly > 0) {
                            parameterName.append(op.path.charAt(i));
                            continue block23;
                        }
                        pathBuffer.append(op.path.charAt(i));
                    }
                }
            }
            op.path = pathBuffer.toString();
        }
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", im.get("import"));
            im.put("classname", this.getModelnameFromModelFilename(im.get("filename").toString()));
        }
        return operations;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessModels(objs);
        List models = (List)this.postProcessModelsEnum(result).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            mo.put("tsImports", this.toTsImports(cm, cm.imports));
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> processedModels) {
        for (Map.Entry<String, Object> entry : processedModels.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel codegenModel = (CodegenModel)mo.get("model");
                if (!codegenModel.getIsAlias().booleanValue() || codegenModel.imports == null || codegenModel.imports.isEmpty()) continue;
                mo.put("tsImports", this.toTsImports(codegenModel, codegenModel.imports));
            }
        }
        return processedModels;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(im));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return this.initialCaps(name) + "Service";
    }

    @Override
    public String toApiFilename(String name) {
        if (name.length() == 0) {
            return "default.service";
        }
        if (this.kebabFileNaming) {
            return this.dashize(name);
        }
        return TypeScriptAngularClientCodegen.camelize(name, true) + ".service";
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.kebabFileNaming) {
            return this.dashize(name);
        }
        return TypeScriptAngularClientCodegen.camelize(this.toModelName(name), true);
    }

    @Override
    public String toModelImport(String name) {
        return this.modelPackage() + "/" + this.toModelFilename(name);
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private String getApiFilenameFromClassname(String classname) {
        String name = classname.substring(0, classname.length() - "Service".length());
        return this.toApiFilename(name);
    }

    private String getModelnameFromModelFilename(String filename) {
        String name = filename.substring((this.modelPackage() + File.separator).length());
        return TypeScriptAngularClientCodegen.camelize(name);
    }
}

