/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.swift;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swift5Codegen
extends DefaultCodegenConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Swift5Codegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String RESPONSE_AS = "responseAs";
    public static final String UNWRAP_REQUIRED = "unwrapRequired";
    public static final String OBJC_COMPATIBLE = "objcCompatible";
    public static final String POD_SOURCE = "podSource";
    public static final String POD_AUTHORS = "podAuthors";
    public static final String POD_SOCIAL_MEDIA_URL = "podSocialMediaURL";
    public static final String POD_DOCSET_URL = "podDocsetURL";
    public static final String POD_LICENSE = "podLicense";
    public static final String POD_HOMEPAGE = "podHomepage";
    public static final String POD_SUMMARY = "podSummary";
    public static final String POD_DESCRIPTION = "podDescription";
    public static final String POD_SCREENSHOTS = "podScreenshots";
    public static final String POD_DOCUMENTATION_URL = "podDocumentationURL";
    public static final String SWIFT_USE_API_NAMESPACE = "swiftUseApiNamespace";
    public static final String DEFAULT_POD_AUTHORS = "Swagger Codegen";
    public static final String LENIENT_TYPE_CAST = "lenientTypeCast";
    private static final String LIBRARY_PROMISE_KIT = "PromiseKit";
    private static final String LIBRARY_RX_SWIFT = "RxSwift";
    private static final String[] RESPONSE_LIBRARIES = new String[]{"PromiseKit", "RxSwift"};
    protected String projectName = "SwaggerClient";
    private boolean unwrapRequired;
    private boolean objcCompatible = false;
    private boolean lenientTypeCast = false;
    protected boolean swiftUseApiNamespace;
    private String[] responseAs = new String[0];
    protected String sourceFolder = "Classes" + File.separator + "Swaggers";

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "swift5";
    }

    public String getHelp() {
        return "Generates a swift client library.";
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema swaggerModel) {
        Object additionalProperties = swaggerModel.getAdditionalProperties();
        if (additionalProperties != null && additionalProperties instanceof Schema) {
            codegenModel.additionalPropertiesType = this.getSchemaType((Schema)additionalProperties);
        }
    }

    public Swift5Codegen() {
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Int32", "Int64", "Float", "Double", "Bool", "Void", "String", "Character", "AnyObject", "Any"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Data", "Date", "URL", "UUID", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject", "Any"));
        this.reservedWords = new HashSet<String>(Arrays.asList("ErrorResponse", "Response", "id", "description", "NSArray", "NSURL", "CGFloat", "NSSet", "NSString", "NSInteger", "NSUInteger", "NSError", "NSDictionary", "associatedtype", "class", "deinit", "enum", "extension", "fileprivate", "func", "import", "init", "inout", "internal", "let", "open", "operator", "private", "protocol", "public", "static", "struct", "subscript", "typealias", "var", "break", "case", "continue", "default", "defer", "do", "else", "fallthrough", "for", "guard", "if", "in", "repeat", "return", "switch", "where", "while", "as", "Any", "catch", "false", "is", "nil", "rethrows", "super", "self", "Self", "throw", "throws", "true", "try", "_", "#available", "#colorLiteral", "#column", "#else", "#elseif", "#endif", "#file", "#fileLiteral", "#function", "#if", "#imageLiteral", "#line", "#selector", "#sourceLocation", "associativity", "convenience", "dynamic", "didSet", "final", "get", "infix", "indirect", "lazy", "left", "mutating", "none", "nonmutating", "optional", "override", "postfix", "precedence", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "willSet", "Bool", "Int", "Double", "Float", "Range", "ClosedRange", "Error", "Optional", "UInt", "UInt8", "UInt16", "UInt32", "UInt64", "Int8", "Int16", "Int32", "Int64", "Float80", "Float32", "Float64", "String", "Character", "Unicode", "StaticString", "Array", "Dictionary", "Set", "OptionSet", "CountableRange", "CountableClosedRange", "URL", "Data", "Codable", "Encodable", "Decodable", "Void", "AnyObject", "Class", "dynamicType", "COLUMN", "FILE", "FUNCTION", "LINE"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("Object", "Any");
        this.typeMapping.put("file", "URL");
        this.typeMapping.put("binary", "Data");
        this.typeMapping.put("ByteArray", "Data");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("BigDecimal", "Decimal");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "Project name in Xcode"));
        this.cliOptions.add(new CliOption(RESPONSE_AS, "Optionally use libraries to manage response.  Currently " + StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption(UNWRAP_REQUIRED, "Treat 'required' properties in response as non-optional (which would crash the app if api returns null as opposed to required option specified in json schema"));
        this.cliOptions.add(new CliOption(OBJC_COMPATIBLE, "Add additional properties and methods for Objective-C compatibility (default: false)"));
        this.cliOptions.add(new CliOption(POD_SOURCE, "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption(POD_AUTHORS, "Authors used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SOCIAL_MEDIA_URL, "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCSET_URL, "Docset URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_LICENSE, "License used for Podspec"));
        this.cliOptions.add(new CliOption(POD_HOMEPAGE, "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SUMMARY, "Summary used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DESCRIPTION, "Description used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SCREENSHOTS, "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCUMENTATION_URL, "Documentation URL used for Podspec"));
        this.cliOptions.add(new CliOption(SWIFT_USE_API_NAMESPACE, "Flag to make all the API classes inner-class of {{projectName}}API"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(LENIENT_TYPE_CAST, "Accept and cast values for simple types (string->bool, string->int, int->string)").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isBlank((CharSequence)this.templateDir)) {
            this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
        }
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        } else {
            this.additionalProperties.put(PROJECT_NAME, this.projectName);
        }
        this.sourceFolder = this.projectName + File.separator + this.sourceFolder;
        if (this.additionalProperties.containsKey(UNWRAP_REQUIRED)) {
            this.setUnwrapRequired(this.convertPropertyToBooleanAndWriteBack(UNWRAP_REQUIRED));
        }
        this.additionalProperties.put(UNWRAP_REQUIRED, this.unwrapRequired);
        if (this.additionalProperties.containsKey(OBJC_COMPATIBLE)) {
            this.setObjcCompatible(this.convertPropertyToBooleanAndWriteBack(OBJC_COMPATIBLE));
        }
        this.additionalProperties.put(OBJC_COMPATIBLE, this.objcCompatible);
        if (this.additionalProperties.containsKey(RESPONSE_AS)) {
            Object responseAsObject = this.additionalProperties.get(RESPONSE_AS);
            if (responseAsObject instanceof String) {
                this.setResponseAs(((String)responseAsObject).split(","));
            } else {
                this.setResponseAs((String[])responseAsObject);
            }
        }
        this.additionalProperties.put(RESPONSE_AS, this.responseAs);
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_PROMISE_KIT)) {
            this.additionalProperties.put("usePromiseKit", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_RX_SWIFT)) {
            this.additionalProperties.put("useRxSwift", true);
        }
        if (this.additionalProperties.containsKey(SWIFT_USE_API_NAMESPACE)) {
            this.setSwiftUseApiNamespace(this.convertPropertyToBooleanAndWriteBack(SWIFT_USE_API_NAMESPACE));
        }
        if (!this.additionalProperties.containsKey(POD_AUTHORS)) {
            this.additionalProperties.put(POD_AUTHORS, DEFAULT_POD_AUTHORS);
        }
        this.setLenientTypeCast(this.convertPropertyToBooleanAndWriteBack(LENIENT_TYPE_CAST));
        this.supportingFiles.add(new SupportingFile("Podspec.mustache", "", this.projectName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("Cartfile.mustache", "", "Cartfile"));
        this.supportingFiles.add(new SupportingFile("APIHelper.mustache", this.sourceFolder, "APIHelper.swift"));
        this.supportingFiles.add(new SupportingFile("AlamofireImplementations.mustache", this.sourceFolder, "AlamofireImplementations.swift"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.sourceFolder, "Configuration.swift"));
        this.supportingFiles.add(new SupportingFile("Extensions.mustache", this.sourceFolder, "Extensions.swift"));
        this.supportingFiles.add(new SupportingFile("Models.mustache", this.sourceFolder, "Models.swift"));
        this.supportingFiles.add(new SupportingFile("APIs.mustache", this.sourceFolder, "APIs.swift"));
        this.supportingFiles.add(new SupportingFile("CodableHelper.mustache", this.sourceFolder, "CodableHelper.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodableEncoding.mustache", this.sourceFolder, "JSONEncodableEncoding.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodingHelper.mustache", this.sourceFolder, "JSONEncodingHelper.swift"));
        this.supportingFiles.add(new SupportingFile("JSONValue.mustache", this.sourceFolder, "JSONValue.swift"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String getDefaultTemplateDir() {
        return "swift5";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema prop) {
        MapSchema mp;
        Object inner;
        if (prop instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)prop;
            Schema inner2 = arraySchema.getItems();
            return "[" + this.getTypeDeclaration(inner2) + "]";
        }
        if (prop instanceof MapSchema && (inner = (mp = (MapSchema)prop).getAdditionalProperties()) instanceof Schema) {
            return "[String:" + this.getTypeDeclaration((Schema)inner) + "]";
        }
        return super.getTypeDeclaration(prop);
    }

    @Override
    public String getSchemaType(Schema prop) {
        String type;
        String schemaType = super.getSchemaType(prop);
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return this.toModelName(type);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("URL");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("Data");
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (this.isReservedWord(name = Swift5Codegen.camelize(name))) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toDefaultValue(Schema prop) {
        return null;
    }

    @Override
    public String toInstantiationType(Schema prop) {
        if (prop instanceof MapSchema) {
            MapSchema mapSchema = (MapSchema)prop;
            if (mapSchema.getAdditionalProperties() != null && mapSchema.getAdditionalProperties() instanceof Schema) {
                return this.getSchemaType((Schema)mapSchema.getAdditionalProperties());
            }
        } else if (prop instanceof ArraySchema) {
            ArraySchema ap = (ArraySchema)prop;
            String inner = this.getSchemaType(ap.getItems());
            return "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return this.initialCaps(name) + "API";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)(operationId = Swift5Codegen.camelize(this.sanitizeName(operationId), true)))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = Swift5Codegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = Swift5Codegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = Swift5Codegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (allDefinitions != null) {
            String parentSchema = codegenModel.parentSchema;
            while (parentSchema != null) {
                Schema parentModel = allDefinitions.get(parentSchema);
                CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allDefinitions);
                Swift5Codegen.reconcileProperties(codegenModel, parentCodegenModel);
                parentSchema = parentCodegenModel.parentSchema;
            }
        }
        return codegenModel;
    }

    @Override
    protected void updateCodegenModelEnumVars(CodegenModel codegenModel) {
        super.updateCodegenModelEnumVars(codegenModel);
        for (CodegenProperty var : codegenModel.allVars) {
            this.updateCodegenPropertyEnum(var);
        }
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI openAPI) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, definitions, openAPI);
        if (codegenOperation.returnType != null && codegenOperation.returnType.equals("Any")) {
            codegenOperation.returnType = null;
        }
        return codegenOperation;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setUnwrapRequired(boolean unwrapRequired) {
        this.unwrapRequired = unwrapRequired;
    }

    public void setObjcCompatible(boolean objcCompatible) {
        this.objcCompatible = objcCompatible;
    }

    public void setLenientTypeCast(boolean lenientTypeCast) {
        this.lenientTypeCast = lenientTypeCast;
    }

    public void setResponseAs(String[] responseAs) {
        this.responseAs = responseAs;
    }

    public void setSwiftUseApiNamespace(boolean swiftUseApiNamespace) {
        this.swiftUseApiNamespace = swiftUseApiNamespace;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return String.valueOf(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String nameLowercase;
        if (name.length() == 0) {
            return "empty";
        }
        Pattern startWithNumberPattern = Pattern.compile("^\\d+");
        Matcher startWithNumberMatcher = startWithNumberPattern.matcher(name);
        if (startWithNumberMatcher.find()) {
            String startingNumbers = startWithNumberMatcher.group(0);
            String nameWithoutStartingNumbers = name.substring(startingNumbers.length());
            return "_" + startingNumbers + Swift5Codegen.camelize(nameWithoutStartingNumbers, true);
        }
        if (this.getSymbolName(name) != null) {
            return Swift5Codegen.camelize(WordUtils.capitalizeFully((String)this.getSymbolName(name).toUpperCase()), true);
        }
        boolean camelized = false;
        if (name.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            name = Swift5Codegen.camelize(name, true);
            camelized = true;
        }
        if (this.isReservedWord(nameLowercase = StringUtils.lowerCase((String)name))) {
            return this.escapeReservedWord(nameLowercase);
        }
        if ("Int".equals(datatype) || "Int32".equals(datatype) || "Int64".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "number" + Swift5Codegen.camelize(name);
            varName = varName.replaceAll("-", "minus");
            varName = varName.replaceAll("\\+", "plus");
            varName = varName.replaceAll("\\.", "dot");
            return varName;
        }
        if (camelized) {
            return name;
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '(', ')'};
        return Swift5Codegen.camelize(WordUtils.capitalizeFully((String)StringUtils.lowerCase((String)name), (char[])separators).replaceAll("[-_ :()]", ""), true);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if (this.isReservedWord(property.datatypeWithEnum) || this.toVarName(property.name).equals(property.datatypeWithEnum)) {
            enumName = property.datatypeWithEnum + "Enum";
        }
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> postProcessedModelsEnum = this.postProcessModelsEnum(objs);
        List models = (List)postProcessedModelsEnum.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean modelHasPropertyWithEscapedName = false;
            for (CodegenProperty prop : cm.allVars) {
                if (prop.name.equals(prop.baseName)) continue;
                prop.vendorExtensions.put("x-codegen-escaped-property-name", true);
                modelHasPropertyWithEscapedName = true;
            }
            if (!modelHasPropertyWithEscapedName) continue;
            cm.vendorExtensions.put("x-codegen-has-escaped-property-names", true);
        }
        return postProcessedModelsEnum;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isSwiftScalarType;
        super.postProcessModelProperty(model, property);
        boolean isSwiftOptional = !this.unwrapRequired || !property.required;
        boolean bl = isSwiftScalarType = ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-integer") || ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-long") || ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-float") || ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-double") || ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-boolean");
        if (isSwiftOptional && isSwiftScalarType) {
            property.vendorExtensions.put("x-swift-optional-scalar", true);
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private static void reconcileProperties(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        List parentModelCodegenProperties = parentCodegenModel.vars;
        List codegenProperties = codegenModel.vars;
        codegenModel.allVars = new ArrayList(codegenProperties);
        codegenModel.parentVars = parentCodegenModel.allVars;
        boolean removedChildProperty = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            Iterator iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = (CodegenProperty)iterator.next();
                if (!codegenProperty.baseName.equals(parentModelCodegenProperty.baseName)) continue;
                iterator.remove();
                removedChildProperty = true;
            }
        }
        if (removedChildProperty) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.getVendorExtensions().put("x-has-more", ++count < numVars);
            }
            codegenModel.vars = codegenProperties;
        }
    }

    @Override
    protected boolean copyFirstAllOfProperties(Schema allOfSchema) {
        return false;
    }
}

