/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.handlebars.lambda;

import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.Template;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import java.io.IOException;

public class CamelCaseLambda
implements Lambda {
    private CodegenConfig generator = null;
    private Boolean escapeParam = false;

    public CamelCaseLambda generator(CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    public CamelCaseLambda escapeAsParamName(Boolean escape) {
        this.escapeParam = escape;
        return this;
    }

    public Object apply(Object o, Template template) throws IOException {
        String executed = template.apply(o);
        String text = DefaultCodegenConfig.camelize(executed, true);
        if (this.generator != null) {
            text = ((DefaultCodegenConfig)this.generator).sanitizeName(text);
            if (this.generator.reservedWords().contains(text)) {
                text = this.generator.escapeReservedWord(text);
            }
            if (this.escapeParam.booleanValue()) {
                text = this.generator.toParamName(text);
            }
        }
        return text;
    }
}

