/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.java.AbstractJavaJAXRSServerCodegen;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaJAXRSSpecServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String GENERATE_POM = "generatePom";
    private boolean interfaceOnly = false;
    private boolean generatePom = true;

    public JavaJAXRSSpecServerCodegen() {
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-server";
        this.outputFolder = "generated-code/JavaJaxRS-Spec";
        this.additionalProperties.put("title", this.title);
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!"library".equals(((CliOption)this.cliOptions.get(i)).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault("<default>");
        LinkedHashMap<String, String> supportedLibraries = new LinkedHashMap<String, String>();
        supportedLibraries.put("<default>", "JAXRS");
        library.setEnum(supportedLibraries);
        this.cliOptions.add(library);
        this.cliOptions.add(CliOption.newBoolean((String)GENERATE_POM, (String)"Whether to generate pom.xml if the file does not already exist.").defaultValue(String.valueOf(this.generatePom)));
        this.cliOptions.add(CliOption.newBoolean((String)INTERFACE_ONLY, (String)"Whether to generate only API interface stubs without the server files.").defaultValue(String.valueOf(this.interfaceOnly)));
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(GENERATE_POM)) {
            this.generatePom = Boolean.valueOf(this.additionalProperties.get(GENERATE_POM).toString());
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.interfaceOnly = Boolean.valueOf(this.additionalProperties.get(INTERFACE_ONLY).toString());
        }
        if (this.interfaceOnly) {
            this.artifactId = "swagger-jaxrs-client";
        }
        super.processOpts();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        if (StringUtils.isEmpty((CharSequence)this.apiPackage)) {
            this.apiPackage = "io.swagger.api";
        }
        if (StringUtils.isEmpty((CharSequence)this.modelPackage)) {
            this.modelPackage = "io.swagger.model";
        }
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.supportingFiles.clear();
        if (this.generatePom) {
            this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        }
        if (!this.interfaceOnly) {
            this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        }
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaJaxRS/spec";
    }

    public String getName() {
        return "jaxrs-spec";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (this.useOas2) {
            model.imports.remove("ApiModelProperty");
            model.imports.remove("ApiModel");
        } else {
            model.imports.remove("Schema");
        }
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
        model.imports.remove("JsonValue");
        model.imports.remove("JsonProperty");
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        try {
            String swaggerJson = Json.pretty((Object)openAPI);
            FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + "swagger.json"), (String)swaggerJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        super.preprocessOpenAPI(openAPI);
    }

    public String getHelp() {
        return "[WORK IN PROGRESS: generated code depends from Swagger v2 libraries] Generates a Java JAXRS Server according to JAXRS 2.0 specification.";
    }
}

