/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.util;

import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;

public class OpenAPIUtil {
    private OpenAPI openAPI;

    public OpenAPIUtil(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }

    public void addPropertiesFromRef(Schema refSchema, CodegenProperty codegenProperty) {
        Map allSchemas = this.openAPI.getComponents().getSchemas();
        if (allSchemas == null || allSchemas.isEmpty()) {
            return;
        }
        Schema schema = (Schema)allSchemas.get(OpenAPIUtil.getSimpleRef(refSchema.get$ref()));
        if (schema == null) {
            return;
        }
        codegenProperty.pattern = schema.getPattern();
        codegenProperty.minLength = schema.getMinLength();
        codegenProperty.maxLength = schema.getMaxLength();
        if (codegenProperty.pattern != null || codegenProperty.minLength != null || codegenProperty.maxLength != null) {
            codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
        }
    }

    public static String getSimpleRef(String ref) {
        if (ref.startsWith("#/components/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        }
        return ref;
    }
}

