/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.openapi;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.templates.HandlebarTemplateEngine;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIGenerator
extends DefaultCodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIGenerator.class);
    public static final String OUTPUT_NAME = "outputFile";
    public static final String FLATTEN_SPEC = "flattenSpec";
    public static final String OPENAPI_FILENAME_DEFAULT_JSON = "openapi.json";
    private String outputFile = "openapi.json";
    protected boolean flattenSpec = true;

    public OpenAPIGenerator() {
        this.outputFolder = "generated-code/openapi";
        this.cliOptions.add(new CliOption(OUTPUT_NAME, "output filename").defaultValue(this.getOutputFile()));
        this.cliOptions.add(new CliOption(FLATTEN_SPEC, "flatten the spec by moving all inline complex schema to components, and add a ref in element", "boolean").defaultValue(Boolean.TRUE.toString()));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
    }

    protected String getOutputFile() {
        return this.outputFile;
    }

    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    public String getName() {
        return "openapi";
    }

    public String getHelp() {
        return "Creates a static openapi.json file.";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        String outputString = this.flattenSpec ? Json.pretty((Object)openAPI) : Json.pretty((Object)this.unflattenedOpenAPI);
        try {
            String outputFile = this.outputFolder + File.separator + this.outputFile;
            FileUtils.writeStringToFile((File)new File(outputFile), (String)outputString);
            LOGGER.debug("wrote file to " + outputFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OUTPUT_NAME) && !StringUtils.isBlank((CharSequence)((String)this.additionalProperties.get(OUTPUT_NAME)))) {
            this.setOutputFile((String)this.additionalProperties.get(OUTPUT_NAME));
        }
        if (!(!this.additionalProperties.containsKey(FLATTEN_SPEC) || this.additionalProperties.get(FLATTEN_SPEC) instanceof String && StringUtils.isBlank((CharSequence)((String)this.additionalProperties.get(FLATTEN_SPEC))))) {
            this.flattenSpec = Boolean.valueOf(this.additionalProperties.get(FLATTEN_SPEC).toString());
        }
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String getArgumentsLocation() {
        return null;
    }

    @Override
    public String getDefaultTemplateDir() {
        return "openapi";
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    protected void setTemplateEngine() {
        this.templateEngine = new HandlebarTemplateEngine((CodegenConfig)this);
    }

    @Override
    public boolean needsUnflattenedSpec() {
        return true;
    }
}

