/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.typescript;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.typescript.AbstractTypeScriptClientCodegen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class TypeScriptAxiosClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_NAME = "npmName";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String DEFAULT_API_PACKAGE = "apis";
    public static final String DEFAULT_MODEL_PACKAGE = "models";
    protected String npmRepository = null;
    private String tsModelPackage = "";

    public TypeScriptAxiosClientCodegen() {
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-axios";
    }

    public String getName() {
        return "typescript-axios";
    }

    public String getHelp() {
        return "Generates a TypeScript Axios client library.";
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private static String getRelativeToRoot(String path) {
        StringBuilder sb = new StringBuilder();
        int slashCount = path.split("/").length;
        if (slashCount == 0) {
            sb.append("./");
        } else {
            for (int i = 0; i < slashCount; ++i) {
                sb.append("../");
            }
        }
        return sb.toString();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isBlank((CharSequence)this.modelPackage)) {
            this.modelPackage = DEFAULT_MODEL_PACKAGE;
        }
        if (StringUtils.isBlank((CharSequence)this.apiPackage)) {
            this.apiPackage = DEFAULT_API_PACKAGE;
        }
        this.tsModelPackage = this.modelPackage.replaceAll("\\.", "/");
        String tsApiPackage = this.apiPackage.replaceAll("\\.", "/");
        String modelRelativeToRoot = TypeScriptAxiosClientCodegen.getRelativeToRoot(this.tsModelPackage);
        String apiRelativeToRoot = TypeScriptAxiosClientCodegen.getRelativeToRoot(tsApiPackage);
        this.additionalProperties.put("tsModelPackage", this.tsModelPackage);
        this.additionalProperties.put("tsApiPackage", tsApiPackage);
        this.additionalProperties.put("apiRelativeToRoot", apiRelativeToRoot);
        this.additionalProperties.put("modelRelativeToRoot", modelRelativeToRoot);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("baseApi.mustache", "", "base.ts"));
        this.supportingFiles.add(new SupportingFile("api.mustache", "", "api.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("npmignore", "", ".npmignore"));
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("apiInner.mustache", ".ts");
        this.supportingFiles.add(new SupportingFile("modelIndex.mustache", this.tsModelPackage, "index.ts"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> operations) {
        boolean hasImports;
        boolean bl = hasImports = operations.get("hasImport") != null && Boolean.parseBoolean(operations.get("hasImport").toString());
        if (hasImports) {
            List imports = (List)operations.get("imports");
            for (Map importMap : imports) {
                String importValue = (String)importMap.get("import");
                if (!StringUtils.isNotBlank((CharSequence)importValue) || !importValue.contains(".")) continue;
                int index = importValue.indexOf(".");
                importMap.put("import", importValue.substring(index + 1));
            }
        }
        return operations;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map vals = objs.getOrDefault("operations", new HashMap());
        List operations = vals.getOrDefault("operation", new ArrayList());
        operations.stream().filter(op -> ExtensionHelper.getBooleanValue((VendorExtendable)op, "x-has-consumes")).filter(op -> op.consumes.stream().anyMatch(opc -> opc.values().stream().anyMatch("multipart/form-data"::equals))).forEach(op -> op.vendorExtensions.putIfAbsent("multipartFormData", true));
        return objs;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get(DEFAULT_MODEL_PACKAGE);
            for (Map model : models) {
                CodegenModel codegenModel = (CodegenModel)model.get("model");
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get(DEFAULT_MODEL_PACKAGE);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.classFilename = cm.classname.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
            cm.imports = new TreeSet(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!ExtensionHelper.getBooleanValue((VendorExtendable)var, "x-is-enum")) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = var.enumName.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!ExtensionHelper.getBooleanValue((VendorExtendable)var, "x-is-enum")) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = var.enumName.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        for (Map m : (List)objs.get("imports")) {
            String javaImport = ((String)m.get("import")).substring(this.modelPackage.length() + 1);
            String tsImport = this.tsModelPackage + "/" + javaImport;
            m.put("tsImport", tsImport);
            m.put("class", javaImport);
            m.put("filename", javaImport.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT));
        }
        return objs;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String toModelFilename(String name) {
        return super.toModelFilename(name).replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
    }

    @Override
    public String toApiFilename(String name) {
        return super.toApiFilename(name).replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
    }

    @Override
    public String getDefaultTemplateDir() {
        return "typescript-axios";
    }
}

