/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.php;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenSecurity;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpClientCodegen
extends DefaultCodegenConfig {
    private static Logger LOGGER = LoggerFactory.getLogger(PhpClientCodegen.class);
    public static final String VARIABLE_NAMING_CONVENTION = "variableNamingConvention";
    public static final String PACKAGE_PATH = "packagePath";
    public static final String SRC_BASE_PATH = "srcBasePath";
    public static final String COMPOSER_VENDOR_NAME = "composerVendorName";
    public static final String COMPOSER_PROJECT_NAME = "composerProjectName";
    protected String invokerPackage = "Swagger\\Client";
    protected String composerVendorName = null;
    protected String composerProjectName = null;
    protected String packagePath = "SwaggerClient-php";
    protected String artifactVersion = null;
    protected String srcBasePath = "lib";
    protected String testBasePath = "test";
    protected String docsBasePath = "docs";
    protected String apiDirName = "Api";
    protected String modelDirName = "Model";
    protected String variableNamingConvention = "snake_case";
    protected String apiDocPath = this.docsBasePath + "/" + this.apiDirName;
    protected String modelDocPath = this.docsBasePath + "/" + this.modelDirName;

    public PhpClientCodegen() {
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.outputFolder = "generated-code" + File.separator + "php";
        this.modelTemplateFiles.put("model.mustache", ".php");
        this.apiTemplateFiles.put("api.mustache", ".php");
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.apiTestTemplateFiles.put("api_test.mustache", ".php");
        this.embeddedTemplateDir = "php";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "httpBody", "queryParams", "headerParams", "formParams", "_header_accept", "_tempBody", "__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "boolean", "int", "integer", "double", "float", "string", "object", "DateTime", "mixed", "number", "void", "byte"));
        this.instantiationTypes.put("array", "array");
        this.instantiationTypes.put("map", "map");
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("byte", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "\\DateTime");
        this.typeMapping.put("Date", "\\DateTime");
        this.typeMapping.put("DateTime", "\\DateTime");
        this.typeMapping.put("file", "\\SplFileObject");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("list", "array");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("BigDecimal", "float");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption(VARIABLE_NAMING_CONVENTION, "naming convention of variable name, e.g. camelCase.").defaultValue("snake_case"));
        this.cliOptions.add(new CliOption("invokerPackage", "The main namespace to use for all classes. e.g. Yay\\Pets"));
        this.cliOptions.add(new CliOption(PACKAGE_PATH, "The main package name for classes. e.g. GeneratedPetstore"));
        this.cliOptions.add(new CliOption(SRC_BASE_PATH, "The directory under packagePath to serve as source root."));
        this.cliOptions.add(new CliOption(COMPOSER_VENDOR_NAME, "The vendor name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. yaypets. IMPORTANT NOTE (2016/03): composerVendorName will be deprecated and replaced by gitUserId in the next swagger-codegen release"));
        this.cliOptions.add(new CliOption("gitUserId", "Git user ID, e.g. swagger-api."));
        this.cliOptions.add(new CliOption(COMPOSER_PROJECT_NAME, "The project name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. petstore-client. IMPORTANT NOTE (2016/03): composerProjectName will be deprecated and replaced by gitRepoId in the next swagger-codegen release"));
        this.cliOptions.add(new CliOption("gitRepoId", "Git repo ID, e.g. swagger-codegen."));
        this.cliOptions.add(new CliOption("artifactVersion", "The version to use in the composer package version field. e.g. 1.2.3"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String toPackagePath(String packageName, String basePath) {
        return this.getPackagePath() + File.separatorChar + this.toSrcPath(packageName, basePath);
    }

    public String toSrcPath(String packageName, String basePath) {
        packageName = packageName.replace(this.invokerPackage, "");
        if (basePath != null && basePath.length() > 0) {
            basePath = basePath.replaceAll("[\\\\/]?$", "") + File.separatorChar;
        }
        String regFirstPathSeparator = "/".equals(File.separator) ? "^/" : "^\\\\";
        String regLastPathSeparator = "/".equals(File.separator) ? "/$" : "\\\\$";
        return (basePath + packageName.replaceAll("[\\.\\\\/]", Matcher.quoteReplacement(File.separator)).replaceAll(regFirstPathSeparator, "")).replaceAll(regLastPathSeparator + "$", "");
    }

    @Override
    public String escapeText(String input) {
        if (input != null) {
            return super.escapeText(input).trim();
        }
        return input;
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "php";
    }

    public String getHelp() {
        return "Generates a PHP client library.";
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
            this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("modelPackage");
        }
        this.additionalProperties.put("modelPackage", this.modelPackage);
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("apiPackage");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage);
        if (this.additionalProperties.containsKey(COMPOSER_PROJECT_NAME)) {
            this.setComposerProjectName((String)this.additionalProperties.get(COMPOSER_PROJECT_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_PROJECT_NAME, this.composerProjectName);
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(PACKAGE_PATH)) {
            this.setPackagePath((String)this.additionalProperties.get(PACKAGE_PATH));
        } else {
            this.additionalProperties.put(PACKAGE_PATH, this.packagePath);
        }
        if (this.additionalProperties.containsKey(SRC_BASE_PATH)) {
            this.setSrcBasePath((String)this.additionalProperties.get(SRC_BASE_PATH));
        } else {
            this.additionalProperties.put(SRC_BASE_PATH, this.srcBasePath);
        }
        if (this.additionalProperties.containsKey("gitUserId")) {
            this.setGitUserId((String)this.additionalProperties.get("gitUserId"));
        } else {
            this.additionalProperties.put("gitUserId", this.gitUserId);
        }
        if (this.additionalProperties.containsKey(COMPOSER_VENDOR_NAME)) {
            this.setComposerVendorName((String)this.additionalProperties.get(COMPOSER_VENDOR_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_VENDOR_NAME, this.composerVendorName);
        }
        if (this.additionalProperties.containsKey("gitRepoId")) {
            this.setGitRepoId((String)this.additionalProperties.get("gitRepoId"));
        } else {
            this.additionalProperties.put("gitRepoId", this.gitRepoId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey(VARIABLE_NAMING_CONVENTION)) {
            this.setParameterNamingConvention((String)this.additionalProperties.get(VARIABLE_NAMING_CONVENTION));
        }
        this.additionalProperties.put("escapedInvokerPackage", this.invokerPackage.replace("\\", "\\\\"));
        this.additionalProperties.put("apiSrcPath", "./" + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestPath", "./" + this.testBasePath + "/" + this.apiDirName);
        this.additionalProperties.put("modelTestPath", "./" + this.testBasePath + "/" + this.modelDirName);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("testBasePath", this.testBasePath);
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "ApiException.php"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "Configuration.php"));
        this.supportingFiles.add(new SupportingFile("ObjectSerializer.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "ObjectSerializer.php"));
        this.supportingFiles.add(new SupportingFile("ModelInterface.mustache", this.toPackagePath(this.modelPackage, this.srcBasePath), "ModelInterface.php"));
        this.supportingFiles.add(new SupportingFile("HeaderSelector.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "HeaderSelector.php"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.getPackagePath(), "composer.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getPackagePath(), "README.md"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", this.getPackagePath(), "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", this.getPackagePath(), ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php_cs", this.getPackagePath(), ".php_cs"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", this.getPackagePath(), "git_push.sh"));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.toPackagePath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.toPackagePath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.testBasePath + "/" + this.apiDirName;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.testBasePath + "/" + this.modelDirName;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            Schema inner = arraySchema.getItems();
            if (inner == null) {
                LOGGER.warn(arraySchema.getName() + "(array property) does not have a proper inner type defined");
                return "";
            }
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (propertySchema instanceof MapSchema && PhpClientCodegen.hasSchemaProperties(propertySchema)) {
            MapSchema mapSchema = (MapSchema)propertySchema;
            Schema inner = (Schema)mapSchema.getAdditionalProperties();
            if (inner == null) {
                LOGGER.warn(propertySchema.getName() + "(map property) does not have a proper inner type defined");
                return "";
            }
            return this.getSchemaType(propertySchema) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        if (propertySchema instanceof MapSchema && PhpClientCodegen.hasTrueAdditionalProperties(propertySchema)) {
            ObjectSchema inner = new ObjectSchema();
            return this.getSchemaType(propertySchema) + "[string," + this.getTypeDeclaration((Schema)inner) + "]";
        }
        if (StringUtils.isNotBlank((CharSequence)propertySchema.get$ref())) {
            String type = super.getTypeDeclaration(propertySchema);
            return !this.languageSpecificPrimitives.contains(type) ? "\\" + this.modelPackage + "\\" + type : type;
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (!this.languageSpecificPrimitives.contains(name)) {
            return "\\" + this.modelPackage + "\\" + name;
        }
        return super.getTypeDeclaration(name);
    }

    @Override
    public String getSchemaType(Schema property) {
        String schemaType = super.getSchemaType(property);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
            if (this.instantiationTypes.containsKey(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public void setSrcBasePath(String srcBasePath) {
        this.srcBasePath = srcBasePath;
    }

    public void setParameterNamingConvention(String variableNamingConvention) {
        this.variableNamingConvention = variableNamingConvention;
    }

    public void setComposerVendorName(String composerVendorName) {
        this.composerVendorName = composerVendorName;
    }

    public void setComposerProjectName(String composerProjectName) {
        this.composerProjectName = composerProjectName;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        name = "camelCase".equals(this.variableNamingConvention) ? PhpClientCodegen.camelize(name, true) : PhpClientCodegen.underscore(name);
        if (name.matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("[^\\w\\\\]+", "_");
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + PhpClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + PhpClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!name.matches("^\\\\.*")) {
            if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
                name = this.modelNamePrefix + "_" + name;
            }
            if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
                name = name + "_" + this.modelNameSuffix;
            }
        }
        return PhpClientCodegen.camelize(name);
    }

    @Override
    public String getArgumentsLocation() {
        return null;
    }

    @Override
    public String getDefaultTemplateDir() {
        return "php";
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + PhpClientCodegen.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        return PhpClientCodegen.camelize(this.sanitizeName(operationId), true);
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof StringSchema) {
            StringSchema stringSchema = (StringSchema)schema;
            if (stringSchema.getDefault() != null) {
                return "'" + (String)stringSchema.getDefault() + "'";
            }
        } else if (schema instanceof BooleanSchema) {
            BooleanSchema booleanSchema = (BooleanSchema)schema;
            if (booleanSchema.getDefault() != null) {
                return ((Boolean)booleanSchema.getDefault()).toString();
            }
        } else if (!(schema instanceof DateSchema) && !(schema instanceof DateTimeSchema)) {
            IntegerSchema integerSchema;
            if (schema instanceof NumberSchema) {
                NumberSchema numberSchema = (NumberSchema)schema;
                if (numberSchema.getDefault() != null && ("float".equals(schema.getFormat()) || "double".equals(schema.getFormat()))) {
                    return ((BigDecimal)numberSchema.getDefault()).toString();
                }
            } else if (schema instanceof IntegerSchema && (integerSchema = (IntegerSchema)schema).getDefault() != null) {
                return ((Number)integerSchema.getDefault()).toString();
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        String example = codegenParameter.defaultValue == null ? codegenParameter.example : codegenParameter.defaultValue;
        String type = codegenParameter.baseType;
        if (type == null) {
            type = codegenParameter.dataType;
        }
        if ("String".equalsIgnoreCase(type)) {
            if (example == null) {
                example = codegenParameter.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("\\SplFileObject".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("\\Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("\\DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("object".equals(type)) {
            example = "new \\stdClass";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = type != null && type.contains(this.modelPackage) ? "new " + type + "()" : "new " + this.getTypeDeclaration(type) + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        boolean isListContainer = ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-list-container");
        boolean isMapContainer = ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-map-container");
        if (example == null) {
            example = "NULL";
        } else if (isListContainer) {
            example = "array(" + example + ")";
        } else if (isMapContainer) {
            example = "array('key' => " + example + ")";
        }
        codegenParameter.example = example;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        String enumName = this.sanitizeName(PhpClientCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = PhpClientCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("x-testOperationId", PhpClientCodegen.camelize(op.operationId));
        }
        return objs;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        List<CodegenSecurity> securities = super.fromSecurity(securitySchemeMap);
        securities.forEach(codegenSecurity -> {
            Map extensions = codegenSecurity.getVendorExtensions();
            if (extensions != null && extensions.containsKey("x-token-example")) {
                this.additionalProperties.put("x-token-example", extensions.get("x-token-example"));
                return;
            }
        });
        return securities;
    }
}

