/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.java.AbstractJavaJAXRSServerCodegen;
import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaJerseyServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    protected static final String LIBRARY_JERSEY1 = "jersey1";
    protected static final String LIBRARY_JERSEY2 = "jersey2";
    public static final String DEFAULT_JERSEY_LIBRARY = "jersey2";
    public static final String USE_TAGS = "useTags";
    protected boolean useTags = false;

    public JavaJerseyServerCodegen() {
        this.outputFolder = "generated-code/JavaJaxRS-Jersey";
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        this.supportedLibraries.put(LIBRARY_JERSEY1, "Jersey core 1.x");
        this.supportedLibraries.put("jersey2", "Jersey core 2.x");
        library.setEnum(this.supportedLibraries);
        library.setDefault("jersey2");
        this.cliOptions.add(library);
        this.cliOptions.add(CliOption.newBoolean((String)"supportJava6", (String)"Whether to support Java6 with the Jersey1/2 library."));
        this.cliOptions.add(CliOption.newBoolean((String)USE_TAGS, (String)"use tags for creating interface and controller classnames"));
    }

    public String getName() {
        return "jaxrs-jersey";
    }

    public String getHelp() {
        return "[WORK IN PROGRESS: generated code depends from Swagger v2 libraries] Generates a Java JAXRS Server application based on Jersey framework.";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isEnum;
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!BooleanUtils.toBoolean((Boolean)(isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum")))) {
            model.imports.add("JsonProperty");
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-has-enums");
            if (BooleanUtils.toBoolean((Boolean)hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public void processOpts() {
        if (LIBRARY_JERSEY1.equalsIgnoreCase(this.library)) {
            this.setUseOas2(true);
            this.additionalProperties.put("useOas2", true);
        }
        super.processOpts();
        this.addTemplateFiles();
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary("jersey2");
        }
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.valueOf(this.additionalProperties.get(USE_TAGS).toString()));
        }
        this.addDateLibrary();
        this.addSupportingFiles();
    }

    public void addDateLibrary() {
        if ("joda".equals(this.dateLibrary)) {
            this.supportingFiles.add(new SupportingFile("JodaDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("JodaLocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaLocalDateProvider.java"));
        } else if (this.dateLibrary.startsWith("java8")) {
            this.supportingFiles.add(new SupportingFile("OffsetDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "OffsetDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("LocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "LocalDateProvider.java"));
        }
    }

    public void addTemplateFiles() {
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceFactory.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
    }

    public void addSupportingFiles() {
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "NotFoundException.java"));
        this.supportingFiles.add(new SupportingFile("jacksonJsonProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JacksonJsonProvider.java"));
        this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "RFC3339DateFormat.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("bootstrap.mustache", (this.implFolder + '/' + this.apiPackage).replace(".", "/"), "Bootstrap.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "StringUtil.java"));
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaJaxRS";
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)cm, "x-is-enum");
            if (!isEnum || cm.allowableValues == null) continue;
            cm.imports.add(this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations;
        objs = super.postProcessOperations(objs);
        if (this.useTags && (operations = (Map)objs.get("operations")) != null) {
            ArrayList<String> allPaths = new ArrayList<String>();
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                String path = operation.path;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                allPaths.add(path);
            }
            if (!allPaths.isEmpty()) {
                String basePath;
                String[] parts;
                StringBuilder basePathSB = new StringBuilder();
                String firstPath = (String)allPaths.remove(0);
                block1: for (String part : parts = firstPath.split("/")) {
                    for (String path : allPaths) {
                        if (path.startsWith(basePathSB.toString() + part)) continue;
                        break block1;
                    }
                    basePathSB.append(part).append("/");
                }
                if ((basePath = basePathSB.toString()).endsWith("/")) {
                    basePath = basePath.substring(0, basePath.length() - 1);
                }
                if (basePath.length() > 0) {
                    for (CodegenOperation operation : ops) {
                        operation.path = operation.path.substring(basePath.length() + (operation.path.startsWith("/") ? 1 : 0));
                        operation.baseName = basePath;
                        operation.subresourceOperation = !operation.path.isEmpty();
                    }
                    objs.put("apiBasePath", basePath);
                }
            }
        }
        return objs;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.useTags) {
            List<CodegenOperation> opList = operations.get(tag);
            if (opList == null) {
                opList = new ArrayList<CodegenOperation>();
                operations.put(tag, opList);
            }
            opList.add(co);
        } else {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath == "") {
                basePath = "default";
            } else {
                if (co.path.startsWith("/" + basePath)) {
                    co.path = co.path.substring(("/" + basePath).length());
                }
                co.subresourceOperation = !co.path.isEmpty();
            }
            List<CodegenOperation> opList = operations.get(basePath);
            if (opList == null) {
                opList = new ArrayList<CodegenOperation>();
                operations.put(basePath, opList);
            }
            opList.add(co);
            co.baseName = basePath;
        }
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }
}

