/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenModelFactory;
import io.swagger.codegen.v3.CodegenModelType;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.ISchemaHandler;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SchemaHandler
implements ISchemaHandler {
    public static final String ALL_OF_PREFFIX = "AllOf";
    public static final String ONE_OF_PREFFIX = "OneOf";
    public static final String ANY_OF_PREFFIX = "AnyOf";
    public static final String ARRAY_ITEMS_SUFFIX = "Items";
    protected DefaultCodegenConfig codegenConfig;
    private List<CodegenModel> composedModels = new ArrayList<CodegenModel>();

    public SchemaHandler(DefaultCodegenConfig codegenConfig) {
        this.codegenConfig = codegenConfig;
    }

    public void processComposedSchemas(CodegenModel codegenModel, Schema schema, Map<String, CodegenModel> allModels) {
        if (schema instanceof ComposedSchema) {
            this.addComposedModel(this.processComposedSchema(codegenModel, (ComposedSchema)schema, allModels));
            return;
        }
        if (schema instanceof ArraySchema) {
            this.addComposedModel(this.processArrayItemSchema(codegenModel, (ArraySchema)schema, allModels));
            return;
        }
        Map properties = schema.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String name : properties.keySet()) {
            Schema property = (Schema)properties.get(name);
            Optional<CodegenProperty> optionalCodegenProperty = codegenModel.getVars().stream().filter(codegenProperty -> codegenProperty.baseName.equals(name)).findFirst();
            if (!optionalCodegenProperty.isPresent()) continue;
            CodegenProperty codegenProperty2 = optionalCodegenProperty.get();
            String codegenName = codegenModel.getName() + this.codegenConfig.toModelName(codegenProperty2.getName());
            if (property instanceof ComposedSchema) {
                this.addComposedModel(this.processComposedSchema(codegenName, codegenProperty2, (ComposedSchema)property, allModels));
                continue;
            }
            if (!(property instanceof ArraySchema)) continue;
            this.addComposedModel(this.processArrayItemSchema(codegenName, codegenProperty2, (ArraySchema)property, allModels));
        }
    }

    public List<CodegenModel> getModels() {
        return this.composedModels;
    }

    protected CodegenModel processComposedSchema(CodegenModel codegenModel, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel(ONE_OF_PREFFIX + codegenModel.getName(), schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel(ANY_OF_PREFFIX + codegenModel.getName(), schemas);
            if (composedModel == null) {
                return null;
            }
        }
        this.addInterfaceModel(codegenModel, composedModel);
        this.addInterfaces(schemas, composedModel, allModels);
        return composedModel;
    }

    protected CodegenModel processComposedSchema(String name, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel(ONE_OF_PREFFIX + name, schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel(ANY_OF_PREFFIX + name, schemas);
            if (composedModel == null) {
                return null;
            }
        }
        this.addInterfaces(schemas, composedModel, allModels);
        return composedModel;
    }

    protected CodegenModel processComposedSchema(String codegenModelName, CodegenProperty codegenProperty, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getAllOf();
        if (schemas != null && !schemas.isEmpty()) {
            CodegenModel composedModel = this.codegenConfig.fromModel(ALL_OF_PREFFIX + codegenModelName, (Schema)composedSchema);
            this.updatePropertyDataType(codegenProperty, composedModel);
            return composedModel;
        }
        schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel(ONE_OF_PREFFIX + codegenModelName, schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel(ANY_OF_PREFFIX + codegenModelName, schemas);
            if (composedModel == null) {
                return null;
            }
        }
        this.addInterfaces(schemas, composedModel, allModels);
        this.updatePropertyDataType(codegenProperty, composedModel);
        return composedModel;
    }

    protected CodegenModel processArrayItemSchema(CodegenModel codegenModel, ArraySchema arraySchema, Map<String, CodegenModel> allModels) {
        Schema itemsSchema = arraySchema.getItems();
        if (itemsSchema instanceof ComposedSchema) {
            CodegenModel composedModel = this.processComposedSchema(codegenModel.name + ARRAY_ITEMS_SUFFIX, (ComposedSchema)itemsSchema, allModels);
            this.updateArrayModel(codegenModel, composedModel.name, arraySchema);
            return composedModel;
        }
        return null;
    }

    protected CodegenModel processArrayItemSchema(String codegenModelName, CodegenProperty codegenProperty, ArraySchema arraySchema, Map<String, CodegenModel> allModels) {
        Schema itemsSchema = arraySchema.getItems();
        if (itemsSchema instanceof ComposedSchema) {
            CodegenModel composedModel = this.processComposedSchema(codegenModelName + ARRAY_ITEMS_SUFFIX, codegenProperty.items, (ComposedSchema)itemsSchema, allModels);
            if (composedModel == null) {
                return null;
            }
            this.updatePropertyDataType(codegenProperty, composedModel.name, arraySchema);
            return composedModel;
        }
        return null;
    }

    protected CodegenModel createComposedModel(String name, List<Schema> schemas) {
        if (schemas == null || schemas.isEmpty()) {
            return null;
        }
        CodegenModel composedModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        composedModel.setIsComposedModel(true);
        composedModel.setInterfaces(new ArrayList());
        this.configureModel(composedModel, name);
        return composedModel;
    }

    protected void addInterfaceModel(CodegenModel codegenModel, CodegenModel interfaceModel) {
        if (codegenModel == null) {
            return;
        }
        if (codegenModel.getInterfaceModels() == null) {
            codegenModel.setInterfaceModels(new ArrayList());
        }
        codegenModel.getInterfaceModels().add(interfaceModel);
    }

    protected void addInterfaces(List<Schema> schemas, CodegenModel codegenModel, Map<String, CodegenModel> allModels) {
        for (Schema interfaceSchema : schemas) {
            String ref = interfaceSchema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) continue;
            String schemaName = ref.substring(ref.lastIndexOf("/") + 1);
            this.addInterfaceModel(allModels.get(this.codegenConfig.toModelName(schemaName)), codegenModel);
        }
    }

    protected void configureModel(CodegenModel codegenModel, String name) {
        codegenModel.name = name;
        codegenModel.classname = this.codegenConfig.toModelName(name);
        codegenModel.classVarName = this.codegenConfig.toVarName(name);
        codegenModel.classFilename = this.codegenConfig.toModelFilename(name);
    }

    protected boolean hasNonObjectSchema(List<Schema> schemas) {
        for (Schema schema : schemas) {
            if (this.codegenConfig.isObjectSchema(schema)) continue;
            return true;
        }
        return false;
    }

    protected void addComposedModel(CodegenModel composedModel) {
        if (composedModel == null) {
            return;
        }
        this.composedModels.add(composedModel);
    }

    protected void updatePropertyDataType(CodegenProperty codegenProperty, String schemaName, ArraySchema arraySchema) {
        Schema items = arraySchema.getItems();
        Schema refSchema = new Schema();
        refSchema.set$ref("#/components/schemas/" + schemaName);
        arraySchema.setItems(refSchema);
        codegenProperty.setDatatype(this.codegenConfig.getTypeDeclaration((Schema)arraySchema));
        codegenProperty.setDatatypeWithEnum(codegenProperty.getDatatype());
        codegenProperty.defaultValue = this.codegenConfig.toDefaultValue((Schema)arraySchema);
        codegenProperty.defaultValueWithParam = this.codegenConfig.toDefaultValueWithParam(codegenProperty.baseName, (Schema)arraySchema);
        arraySchema.setItems(items);
    }

    protected void updateArrayModel(CodegenModel codegenModel, String schemaName, ArraySchema arraySchema) {
        Schema items = arraySchema.getItems();
        Schema refSchema = new Schema();
        refSchema.set$ref("#/components/schemas/" + schemaName);
        arraySchema.setItems(refSchema);
        this.codegenConfig.addParentContainer(codegenModel, codegenModel.name, (Schema)arraySchema);
        codegenModel.defaultValue = this.codegenConfig.toDefaultValue((Schema)arraySchema);
        codegenModel.arrayModelType = this.codegenConfig.fromProperty((String)codegenModel.name, (Schema)arraySchema).complexType;
        arraySchema.setItems(items);
    }

    private void updatePropertyDataType(CodegenProperty codegenProperty, CodegenModel composedModel) {
        codegenProperty.datatype = composedModel.getClassname();
        codegenProperty.datatypeWithEnum = composedModel.getClassname();
        codegenProperty.baseType = composedModel.getClassname();
        codegenProperty.complexType = composedModel.getClassname();
    }
}

