/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.html;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import java.io.File;

public class StaticDocCodegen
extends DefaultCodegenConfig
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "docs";

    public StaticDocCodegen() {
        this.importMapping.clear();
        this.outputFolder = "docs";
        this.modelTemplateFiles.put("model.mustache", ".html");
        this.apiTemplateFiles.put("operation.mustache", ".html");
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.js"));
        this.supportingFiles.add(new SupportingFile("assets/css/bootstrap-responsive.css", this.outputFolder + "/assets/css", "bootstrap-responsive.css"));
        this.supportingFiles.add(new SupportingFile("assets/css/bootstrap.css", this.outputFolder + "/assets/css", "bootstrap.css"));
        this.supportingFiles.add(new SupportingFile("assets/css/style.css", this.outputFolder + "/assets/css", "style.css"));
        this.supportingFiles.add(new SupportingFile("assets/images/logo.png", this.outputFolder + "/assets/images", "logo.png"));
        this.supportingFiles.add(new SupportingFile("assets/js/bootstrap.js", this.outputFolder + "/assets/js", "bootstrap.js"));
        this.supportingFiles.add(new SupportingFile("assets/js/jquery-1.8.3.min.js", this.outputFolder + "/assets/js", "jquery-1.8.3.min.js"));
        this.supportingFiles.add(new SupportingFile("assets/js/main.js", this.outputFolder + "/assets/js", "main.js"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.outputFolder, "index.html"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
    }

    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getArgumentsLocation() {
        return "";
    }

    @Override
    public String getDefaultTemplateDir() {
        return "swagger-static";
    }

    public String getName() {
        return "dynamic-html";
    }

    public String getHelp() {
        return "Generates a dynamic HTML site.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "operations";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "models";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

