/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.scala;

import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.scala.AbstractScalaCodegen;
import io.swagger.codegen.v3.generators.scala.TextOrMatcher;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkkaHttpServerCodegen
extends AbstractScalaCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(AkkaHttpServerCodegen.class);
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-scala-akka-http-server";
    protected String artifactVersion = "1.0.0";
    protected String invokerPackage = "io.swagger.server";
    protected static String LOWERCASE_HTTP_METHOD = "lowercaseHttpMethod";
    protected static String PATHS = "paths";
    private static Map<String, String> pathTypeToMatcher = new HashMap<String, String>(){
        {
            this.put("Int", "IntNumber");
            this.put("Long", "LongNumber");
            this.put("Float", "FloatNumber");
            this.put("Double", "DoubleNumber");
            this.put("Boolean", "Boolean");
            this.put("String", "Segment");
        }
    };
    protected static String FALLBACK_DATA_TYPE = "String";
    protected static String COOKIE_DATA_TYPE = "HttpCookiePair";
    private static Set<String> primitiveParamTypes = new HashSet<String>(){
        {
            this.addAll(Arrays.asList("Int", "Long", "Float", "Double", "Boolean", "String"));
        }
    };
    protected static String QUERY_PARAMS_WITH_SUPPORTED_TYPE = "queryParamsWithSupportedType";
    protected static String PARAMS_WITH_SUPPORTED_TYPE = "paramsWithSupportedType";

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "scala-akka-http-server";
    }

    public String getHelp() {
        return "Generates an akka http server in scala";
    }

    public AkkaHttpServerCodegen() {
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.apiPackage = "io.swagger.server.api";
        this.modelPackage = "io.swagger.server.model";
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("controller.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "Controller.scala"));
        this.supportingFiles.add(new SupportingFile("helper.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "AkkaHttpHelper.scala"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return AkkaHttpServerCodegen.setComplexTypes(objs);
    }

    public static Map<String, Object> setComplexTypes(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        Boolean hasComplexTypes = Boolean.FALSE;
        Boolean hasCookieParams = Boolean.FALSE;
        HashSet<String> complexRequestTypes = new HashSet<String>();
        ArrayList<CodegenResponse> complexReturnTypes = new ArrayList<CodegenResponse>();
        for (CodegenOperation op : operationList) {
            ArrayList<CodegenResponse> complexOperationReturnTypes = new ArrayList<CodegenResponse>();
            for (CodegenParameter parameter : op.allParams) {
                if (!parameter.getIsPrimitiveType().booleanValue() && parameter.getIsBodyParam().booleanValue()) {
                    hasComplexTypes = Boolean.TRUE;
                    complexRequestTypes.add(parameter.dataType);
                }
                if (!parameter.getIsCookieParam().booleanValue()) continue;
                hasCookieParams = Boolean.TRUE;
            }
            for (CodegenResponse response : op.responses) {
                if (response.getIsPrimitiveType().booleanValue()) continue;
                hasComplexTypes = Boolean.TRUE;
                complexReturnTypes.add(response);
                complexOperationReturnTypes.add(response);
            }
            op.getVendorExtensions().put("complexReturnTypes", complexOperationReturnTypes);
        }
        objs.put("hasComplexTypes", hasComplexTypes);
        objs.put("hasCookieParams", hasCookieParams);
        objs.put("complexRequestTypes", complexRequestTypes);
        objs.put("complexReturnTypes", complexReturnTypes);
        return objs;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, schemas, openAPI);
        AkkaHttpServerCodegen.addLowercaseHttpMethod(codegenOperation);
        AkkaHttpServerCodegen.addPathMatcher(codegenOperation);
        AkkaHttpServerCodegen.addQueryParamsWithSupportedType(codegenOperation);
        AkkaHttpServerCodegen.addAllParamsWithSupportedTypes(codegenOperation);
        return codegenOperation;
    }

    @Override
    public String getDefaultTemplateDir() {
        return "scala/akka-http-server";
    }

    protected static void addLowercaseHttpMethod(CodegenOperation codegenOperation) {
        codegenOperation.getVendorExtensions().put(LOWERCASE_HTTP_METHOD, codegenOperation.httpMethod.toLowerCase());
    }

    protected static void addPathMatcher(CodegenOperation codegenOperation) {
        LinkedList<String> allPaths = new LinkedList<String>(Arrays.asList(codegenOperation.path.split("/")));
        allPaths.removeIf(""::equals);
        LinkedList<TextOrMatcher> paths = AkkaHttpServerCodegen.replacePathsWithMatchers(allPaths, codegenOperation);
        codegenOperation.getVendorExtensions().put(PATHS, paths);
    }

    private static LinkedList<TextOrMatcher> replacePathsWithMatchers(LinkedList<String> paths, CodegenOperation codegenOperation) {
        LinkedList<TextOrMatcher> result = new LinkedList<TextOrMatcher>();
        for (String path : paths) {
            TextOrMatcher textOrMatcher = new TextOrMatcher("", true, true);
            if (path.startsWith("{") && path.endsWith("}")) {
                String parameterName = path.substring(1, path.length() - 1);
                for (CodegenParameter pathParam : codegenOperation.pathParams) {
                    if (!pathParam.paramName.equals(parameterName)) continue;
                    String matcher = pathTypeToMatcher.get(pathParam.dataType);
                    if (matcher == null) {
                        LOGGER.warn("The path parameter " + pathParam.paramName + " with the datatype " + pathParam.dataType + " could not be translated to a corresponding path matcher of akka http and therefore has been translated to string.");
                        matcher = pathTypeToMatcher.get(FALLBACK_DATA_TYPE);
                    }
                    textOrMatcher.value = matcher;
                    textOrMatcher.isText = false;
                    result.add(textOrMatcher);
                }
                continue;
            }
            textOrMatcher.value = path;
            textOrMatcher.isText = true;
            result.add(textOrMatcher);
        }
        ((TextOrMatcher)result.getLast()).hasMore = false;
        return result;
    }

    protected static void addQueryParamsWithSupportedType(CodegenOperation codegenOperation) {
        LinkedList<CodegenParameter> queryParamsWithSupportedType = new LinkedList<CodegenParameter>();
        for (CodegenParameter parameter : codegenOperation.queryParams) {
            CodegenParameter parameterCopy = parameter.copy();
            if (!primitiveParamTypes.contains(parameter.dataType)) {
                parameterCopy.dataType = FALLBACK_DATA_TYPE;
            }
            queryParamsWithSupportedType.add(parameterCopy);
        }
        codegenOperation.getVendorExtensions().put(QUERY_PARAMS_WITH_SUPPORTED_TYPE, queryParamsWithSupportedType);
    }

    public static void addAllParamsWithSupportedTypes(CodegenOperation codegenOperation) {
        LinkedList<CodegenParameter> allParamsWithSupportedType = new LinkedList<CodegenParameter>();
        for (CodegenParameter parameter : codegenOperation.allParams) {
            CodegenParameter parameterCopy = parameter.copy();
            if (AkkaHttpServerCodegen.containsParam(codegenOperation.pathParams, parameter)) {
                if (!pathTypeToMatcher.containsKey(parameter.dataType)) {
                    parameterCopy.dataType = FALLBACK_DATA_TYPE;
                }
            } else if (AkkaHttpServerCodegen.containsParam(codegenOperation.queryParams, parameter)) {
                if (!primitiveParamTypes.contains(parameter.dataType)) {
                    parameterCopy.dataType = FALLBACK_DATA_TYPE;
                }
            } else if (AkkaHttpServerCodegen.containsParam(codegenOperation.formParams, parameter)) {
                if (!primitiveParamTypes.contains(parameter.dataType)) {
                    parameterCopy.dataType = FALLBACK_DATA_TYPE;
                }
            } else if (parameter.getIsCookieParam().booleanValue()) {
                parameterCopy.dataType = COOKIE_DATA_TYPE;
            }
            allParamsWithSupportedType.add(parameterCopy);
        }
        codegenOperation.getVendorExtensions().put(PARAMS_WITH_SUPPORTED_TYPE, allParamsWithSupportedType);
    }

    private static boolean containsParam(List<CodegenParameter> parameters, CodegenParameter param) {
        for (CodegenParameter elem : parameters) {
            if (!param.paramName.equals(elem.paramName)) continue;
            return true;
        }
        return false;
    }
}

