/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.html;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenModelFactory;
import io.swagger.codegen.v3.CodegenModelType;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.SchemaHandler;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HtmlSchemaHandler
extends SchemaHandler {
    public HtmlSchemaHandler(DefaultCodegenConfig codegenConfig) {
        super(codegenConfig);
    }

    @Override
    public void createCodegenModel(ComposedSchema composedProperty, CodegenProperty codegenProperty) {
        List oneOf = composedProperty.getOneOf();
        List anyOf = composedProperty.getAnyOf();
        if (oneOf != null && !oneOf.isEmpty() && !this.hasNonObjectSchema(oneOf)) {
            CodegenModel oneOfModel = this.createFromOneOfSchemas(oneOf);
            codegenProperty.vendorExtensions.put("oneOf-model", oneOfModel);
        }
        if (anyOf != null && !anyOf.isEmpty() && !this.hasNonObjectSchema(anyOf)) {
            CodegenModel anyOfModel = this.createFromOneOfSchemas(anyOf);
            codegenProperty.vendorExtensions.put("anyOf-model", anyOfModel);
        }
    }

    @Override
    public void configureComposedModelFromSchemaItems(CodegenModel codegenModel, ComposedSchema items) {
        List anyOfList;
        List oneOfList = items.getOneOf();
        if (oneOfList != null && !oneOfList.isEmpty()) {
            String name = "OneOf" + codegenModel.name + "Items";
            CodegenModel oneOfModel = this.createComposedModel(name);
            items.addExtension("x-model-name", (Object)this.codegenConfig.toModelName(name));
            ArrayList<String> modelNames = new ArrayList<String>();
            for (Schema interfaceSchema : oneOfList) {
                if (!StringUtils.isNotBlank((CharSequence)interfaceSchema.get$ref())) continue;
                String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
                modelNames.add(this.codegenConfig.toModelName(schemaName));
            }
            oneOfModel.vendorExtensions.put("x-model-names", modelNames);
            if (!modelNames.isEmpty()) {
                codegenModel.vendorExtensions.put("oneOf-model", oneOfModel);
            }
        }
        if ((anyOfList = items.getAnyOf()) != null && !anyOfList.isEmpty()) {
            String name = "AnyOf" + codegenModel.name + "Items";
            CodegenModel anyOfModel = this.createComposedModel(name);
            items.addExtension("x-model-name", (Object)this.codegenConfig.toModelName(name));
            ArrayList<String> modelNames = new ArrayList<String>();
            for (Schema interfaceSchema : anyOfList) {
                if (!StringUtils.isNotBlank((CharSequence)interfaceSchema.get$ref())) continue;
                String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
                modelNames.add(this.codegenConfig.toModelName(schemaName));
            }
            anyOfModel.vendorExtensions.put("x-model-names", modelNames);
            if (!modelNames.isEmpty()) {
                codegenModel.vendorExtensions.put("anyOf-model", anyOfModel);
            }
        }
    }

    @Override
    public void configureOneOfModel(CodegenModel codegenModel, List<Schema> oneOf) {
    }

    @Override
    public void configureAnyOfModel(CodegenModel codegenModel, List<Schema> anyOf) {
    }

    @Override
    public void configureOneOfModelFromProperty(CodegenProperty codegenProperty, CodegenModel codegenModel) {
    }

    @Override
    public void configureAnyOfModelFromProperty(CodegenProperty codegenProperty, CodegenModel codegenModel) {
    }

    private CodegenModel createFromOneOfSchemas(List<Schema> schemas) {
        CodegenModel codegenModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        ArrayList<String> modelNames = new ArrayList<String>();
        for (Schema interfaceSchema : schemas) {
            if (!StringUtils.isNotBlank((CharSequence)interfaceSchema.get$ref())) continue;
            String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
            modelNames.add(this.codegenConfig.toModelName(schemaName));
        }
        codegenModel.vendorExtensions.put("x-model-names", modelNames);
        return codegenModel;
    }

    private CodegenModel createComposedModel(String name) {
        CodegenModel composedModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        this.configureModel(composedModel, name);
        return composedModel;
    }

    private void configureModel(CodegenModel codegenModel, String name) {
        codegenModel.name = name;
        codegenModel.classname = this.codegenConfig.toModelName(name);
        codegenModel.classVarName = this.codegenConfig.toVarName(name);
        codegenModel.classFilename = this.codegenConfig.toModelFilename(name);
        codegenModel.vendorExtensions.put("x-is-composed-model", Boolean.TRUE);
    }

    private boolean hasNonObjectSchema(List<Schema> schemas) {
        for (Schema schema : schemas) {
            if (this.codegenConfig.isObjectSchema(schema)) continue;
            return true;
        }
        return false;
    }
}

