/*
 * Decompiled with CFR 0.152.
 */
package io.supercharge.shimmerlayout;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.supercharge.shimmerlayout.R;

public class ShimmerLayout
extends FrameLayout {
    private static final int DEFAULT_ANIMATION_DURATION = 1500;
    private static final int DEFAULT_ANGLE = 20;
    private static final int MIN_ANGLE_VALUE = 0;
    private static final int MAX_ANGLE_VALUE = 30;
    private static final int MIN_MASK_WIDTH_VALUE = 0;
    private static final int MAX_MASK_WIDTH_VALUE = 1;
    private static final int MIN_GRADIENT_CENTER_COLOR_WIDTH_VALUE = 0;
    private static final int MAX_GRADIENT_CENTER_COLOR_WIDTH_VALUE = 1;
    private int maskOffsetX;
    private Rect maskRect;
    private Paint gradientTexturePaint;
    private ValueAnimator maskAnimator;
    private Bitmap localDestinationBitmap;
    private Bitmap destinationBitmap;
    private Canvas canvasForShimmerDrawing;
    private boolean isAnimationStarted;
    private boolean autoStart;
    private int shimmerAnimationDuration;
    private int shimmerColor;
    private int shimmerAngle;
    private float maskWidth;
    private float gradientCenterColorWidth;
    private ViewTreeObserver.OnPreDrawListener startAnimationPreDrawListener;

    public ShimmerLayout(Context context) {
        this(context, null);
    }

    public ShimmerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShimmerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ShimmerLayout, 0, 0);
        try {
            this.shimmerAngle = a.getInteger(R.styleable.ShimmerLayout_shimmer_angle, 20);
            this.shimmerAnimationDuration = a.getInteger(R.styleable.ShimmerLayout_shimmer_animation_duration, 1500);
            this.shimmerColor = a.getColor(R.styleable.ShimmerLayout_shimmer_color, this.getColor(R.color.shimmer_color));
            this.autoStart = a.getBoolean(R.styleable.ShimmerLayout_shimmer_auto_start, false);
            this.maskWidth = a.getFloat(R.styleable.ShimmerLayout_shimmer_mask_width, 0.5f);
            this.gradientCenterColorWidth = a.getFloat(R.styleable.ShimmerLayout_shimmer_gradient_center_color_width, 0.06f);
        }
        finally {
            a.recycle();
        }
        this.setMaskWidth(this.maskWidth);
        this.setGradientCenterColorWidth(this.gradientCenterColorWidth);
        this.setShimmerAngle(this.shimmerAngle);
        if (this.autoStart && this.getVisibility() == 0) {
            this.startShimmerAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.resetShimmering();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.isAnimationStarted || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.dispatchDrawShimmer(canvas);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            if (this.autoStart) {
                this.startShimmerAnimation();
            }
        } else {
            this.stopShimmerAnimation();
        }
    }

    public void startShimmerAnimation() {
        if (this.isAnimationStarted) {
            return;
        }
        if (this.getWidth() == 0) {
            this.startAnimationPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    ShimmerLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    ShimmerLayout.this.startShimmerAnimation();
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(this.startAnimationPreDrawListener);
            return;
        }
        Animator animator = this.getShimmerAnimation();
        animator.start();
        this.isAnimationStarted = true;
    }

    public void stopShimmerAnimation() {
        if (this.startAnimationPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener(this.startAnimationPreDrawListener);
        }
        this.resetShimmering();
    }

    public void setShimmerColor(int shimmerColor) {
        this.shimmerColor = shimmerColor;
        this.resetIfStarted();
    }

    public void setShimmerAnimationDuration(int durationMillis) {
        this.shimmerAnimationDuration = durationMillis;
        this.resetIfStarted();
    }

    public void setShimmerAngle(int angle) {
        if (angle < 0 || 30 < angle) {
            throw new IllegalArgumentException(String.format("shimmerAngle value must be between %d and %d", 0, 30));
        }
        this.shimmerAngle = angle;
        this.resetIfStarted();
    }

    public void setMaskWidth(float maskWidth) {
        if (maskWidth <= 0.0f || 1.0f < maskWidth) {
            throw new IllegalArgumentException(String.format("maskWidth value must be higher than %d and less or equal to %d", 0, 1));
        }
        this.maskWidth = maskWidth;
        this.resetIfStarted();
    }

    public void setGradientCenterColorWidth(float gradientCenterColorWidth) {
        if (gradientCenterColorWidth <= 0.0f || 1.0f < gradientCenterColorWidth) {
            throw new IllegalArgumentException(String.format("gradientCenterColorWidth value must be higher than %d and less or equal to %d", 0, 1));
        }
        this.gradientCenterColorWidth = gradientCenterColorWidth;
        this.resetIfStarted();
    }

    private void resetIfStarted() {
        if (this.isAnimationStarted) {
            this.resetShimmering();
            this.startShimmerAnimation();
        }
    }

    private void dispatchDrawShimmer(Canvas canvas) {
        this.localDestinationBitmap = this.getDestinationBitmap();
        if (this.localDestinationBitmap == null) {
            return;
        }
        if (this.canvasForShimmerDrawing == null) {
            this.canvasForShimmerDrawing = new Canvas(this.localDestinationBitmap);
        }
        this.canvasForShimmerDrawing.drawColor(0, PorterDuff.Mode.CLEAR);
        super.dispatchDraw(this.canvasForShimmerDrawing);
        this.drawShimmer(this.canvasForShimmerDrawing);
        canvas.drawBitmap(this.localDestinationBitmap, 0.0f, 0.0f, null);
        this.localDestinationBitmap = null;
    }

    private void drawShimmer(Canvas destinationCanvas) {
        this.createShimmerPaint();
        destinationCanvas.save();
        destinationCanvas.rotate((float)this.shimmerAngle, (float)(this.maskOffsetX + this.maskRect.width() / 2), (float)(this.getHeight() / 2));
        destinationCanvas.translate((float)this.maskOffsetX, 0.0f);
        destinationCanvas.drawRect((float)(-this.maskRect.left), (float)this.maskRect.top, (float)(this.maskRect.width() + this.maskRect.left), (float)this.maskRect.bottom, this.gradientTexturePaint);
        destinationCanvas.restore();
    }

    private void resetShimmering() {
        if (this.maskAnimator != null) {
            this.maskAnimator.end();
            this.maskAnimator.removeAllUpdateListeners();
        }
        this.maskAnimator = null;
        this.isAnimationStarted = false;
        this.releaseBitMaps();
    }

    private void releaseBitMaps() {
        if (this.destinationBitmap != null) {
            this.destinationBitmap.recycle();
            this.destinationBitmap = null;
        }
        this.canvasForShimmerDrawing = null;
    }

    private Bitmap getDestinationBitmap() {
        if (this.destinationBitmap == null) {
            this.destinationBitmap = this.createBitmap(this.getWidth(), this.getHeight());
        }
        return this.destinationBitmap;
    }

    private void createShimmerPaint() {
        if (this.gradientTexturePaint != null) {
            return;
        }
        int edgeColor = this.reduceColorAlphaValueToZero(this.shimmerColor);
        LinearGradient gradient = new LinearGradient((float)(-this.maskRect.left), 0.0f, (float)(this.maskRect.width() + this.maskRect.left), 0.0f, new int[]{edgeColor, this.shimmerColor, this.shimmerColor, edgeColor}, this.getGradientColorDistribution(), Shader.TileMode.CLAMP);
        this.gradientTexturePaint = new Paint();
        this.gradientTexturePaint.setAntiAlias(true);
        this.gradientTexturePaint.setDither(true);
        this.gradientTexturePaint.setFilterBitmap(true);
        this.gradientTexturePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        this.gradientTexturePaint.setShader((Shader)gradient);
    }

    private Animator getShimmerAnimation() {
        if (this.maskAnimator != null) {
            return this.maskAnimator;
        }
        if (this.maskRect == null) {
            this.maskRect = this.calculateMaskRect();
        }
        int animationToX = this.getWidth();
        final int animationFromX = this.getWidth() > this.maskRect.width() ? -animationToX : -this.maskRect.width();
        final int shimmerBitmapWidth = this.maskRect.width();
        final int shimmerAnimationFullLength = animationToX - animationFromX;
        this.maskAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.maskAnimator.setDuration((long)this.shimmerAnimationDuration);
        this.maskAnimator.setRepeatCount(-1);
        final float[] value = new float[1];
        this.maskAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                value[0] = ((Float)animation.getAnimatedValue()).floatValue();
                ShimmerLayout.this.maskOffsetX = (int)((float)animationFromX + (float)shimmerAnimationFullLength * value[0]);
                if (ShimmerLayout.this.maskOffsetX + shimmerBitmapWidth >= 0) {
                    ShimmerLayout.this.invalidate();
                }
            }
        });
        return this.maskAnimator;
    }

    private Bitmap createBitmap(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            return null;
        }
    }

    private int getColor(int id) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getColor(id);
        }
        return this.getResources().getColor(id);
    }

    private int reduceColorAlphaValueToZero(int actualColor) {
        return Color.argb((int)0, (int)Color.red((int)actualColor), (int)Color.green((int)actualColor), (int)Color.blue((int)actualColor));
    }

    private Rect calculateMaskRect() {
        int shimmerWidth = this.getWidth() / 2;
        if (this.shimmerAngle == 0) {
            return new Rect((int)((float)shimmerWidth * this.getMaskPositionStartRatio()), 0, (int)((float)shimmerWidth * this.getMaskPositionEndRatio()), this.getHeight());
        }
        int top = 0;
        int center = (int)((double)this.getHeight() * 0.5);
        int right = (int)((float)shimmerWidth * this.getMaskPositionEndRatio());
        Point originalTopRight = new Point(right, top);
        Point originalCenterRight = new Point(right, center);
        Point rotatedTopRight = this.rotatePoint(originalTopRight, this.shimmerAngle, shimmerWidth / 2, this.getHeight() / 2);
        Point rotatedCenterRight = this.rotatePoint(originalCenterRight, this.shimmerAngle, shimmerWidth / 2, this.getHeight() / 2);
        Point rotatedIntersection = this.getTopIntersection(rotatedTopRight, rotatedCenterRight);
        int halfMaskHeight = this.distanceBetween(rotatedCenterRight, rotatedIntersection);
        int paddingVertical = this.getHeight() / 2 - halfMaskHeight;
        int paddingHorizontal = shimmerWidth - rotatedIntersection.x;
        return new Rect(paddingHorizontal, paddingVertical, shimmerWidth - paddingHorizontal, this.getHeight() - paddingVertical);
    }

    private Point getTopIntersection(Point p1, Point p2) {
        double x1 = p1.x;
        double x2 = p2.x;
        double y1 = -p1.y;
        double y2 = -p2.y;
        double m = (y2 - y1) / (x2 - x1);
        double b = y1 - m * x1;
        int x = (int)((0.0 - b) / m);
        int y = 0;
        return new Point(x, y);
    }

    private Point rotatePoint(Point point, float degrees, float cx, float cy) {
        float[] pts = new float[]{point.x, point.y};
        Matrix transform = new Matrix();
        transform.setRotate(degrees, cx, cy);
        transform.mapPoints(pts);
        return new Point((int)pts[0], (int)pts[1]);
    }

    private int distanceBetween(Point p1, Point p2) {
        return (int)Math.ceil(Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0)));
    }

    private float[] getGradientColorDistribution() {
        float[] colorDistribution = new float[4];
        colorDistribution[0] = this.getMaskPositionStartRatio();
        colorDistribution[3] = this.getMaskPositionEndRatio();
        colorDistribution[1] = 0.5f - this.gradientCenterColorWidth / 2.0f;
        colorDistribution[2] = 0.5f + this.gradientCenterColorWidth / 2.0f;
        return colorDistribution;
    }

    private float getMaskPositionStartRatio() {
        return (1.0f - this.maskWidth) / 2.0f;
    }

    private float getMaskPositionEndRatio() {
        return 1.0f - this.getMaskPositionStartRatio();
    }
}

