/*
 * Decompiled with CFR 0.152.
 */
package io.supercharge.shimmerlayout;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.supercharge.shimmerlayout.R;

public class ShimmerLayout
extends FrameLayout {
    private static final int DEFAULT_ANIMATION_DURATION = 1500;
    private static final int DEFAULT_ANGLE = 20;
    private static final int MIN_ANGLE_VALUE = 0;
    private static final int MAX_ANGLE_VALUE = 30;
    private int maskOffsetX;
    private Rect maskRect;
    private Paint maskPaint;
    private ValueAnimator maskAnimator;
    private Bitmap localAvailableBitmap;
    private Bitmap localMaskBitmap;
    private Bitmap destinationBitmap;
    private Bitmap sourceMaskBitmap;
    private Canvas canvasForRendering;
    private boolean isAnimationStarted;
    private boolean autoStart;
    private int shimmerAnimationDuration;
    private int shimmerColor;
    private int shimmerAngle;

    public ShimmerLayout(Context context) {
        this(context, null);
    }

    public ShimmerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShimmerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.maskPaint = new Paint();
        this.maskPaint.setAntiAlias(true);
        this.maskPaint.setDither(true);
        this.maskPaint.setFilterBitmap(true);
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ShimmerLayout, 0, 0);
        try {
            this.shimmerAngle = a.getInteger(R.styleable.ShimmerLayout_shimmer_angle, 20);
            this.shimmerAnimationDuration = a.getInteger(R.styleable.ShimmerLayout_shimmer_animation_duration, 1500);
            this.shimmerColor = a.getColor(R.styleable.ShimmerLayout_shimmer_color, this.getColor(R.color.shimmer_color));
            this.autoStart = a.getBoolean(R.styleable.ShimmerLayout_shimmer_auto_start, false);
        }
        finally {
            a.recycle();
        }
        this.setShimmerAngle(this.shimmerAngle);
        if (this.autoStart && this.getVisibility() == 0) {
            this.startShimmerAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.resetShimmering();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.isAnimationStarted || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.dispatchDrawUsingBitmap(canvas);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            if (this.autoStart) {
                this.startShimmerAnimation();
            }
        } else {
            this.stopShimmerAnimation();
        }
    }

    public void startShimmerAnimation() {
        if (this.isAnimationStarted) {
            return;
        }
        if (this.getWidth() == 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ShimmerLayout.this.removeGlobalLayoutListener(this);
                    ShimmerLayout.this.startShimmerAnimation();
                }
            });
            return;
        }
        Animator animator = this.getShimmerAnimation();
        animator.start();
        this.isAnimationStarted = true;
    }

    public void stopShimmerAnimation() {
        this.resetShimmering();
    }

    public void setShimmerColor(int shimmerColor) {
        this.shimmerColor = shimmerColor;
        this.resetIfStarted();
    }

    public void setShimmerAnimationDuration(int durationMillis) {
        this.shimmerAnimationDuration = durationMillis;
        this.resetIfStarted();
    }

    public void setShimmerAngle(int angle) {
        if (angle < 0 || 30 < angle) {
            throw new IllegalArgumentException(String.format("shimmerAngle value must be between %d and %d", 0, 30));
        }
        this.shimmerAngle = angle;
        this.resetIfStarted();
    }

    private void resetIfStarted() {
        if (this.isAnimationStarted) {
            this.resetShimmering();
            this.startShimmerAnimation();
        }
    }

    private void dispatchDrawUsingBitmap(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.localAvailableBitmap = this.getDestinationBitmap();
        if (this.localAvailableBitmap == null) {
            return;
        }
        if (this.canvasForRendering == null) {
            this.canvasForRendering = new Canvas(this.localAvailableBitmap);
        }
        this.drawMask(this.canvasForRendering);
        canvas.save();
        canvas.clipRect(this.maskOffsetX, 0, this.maskOffsetX + this.maskRect.width(), this.getHeight());
        canvas.drawBitmap(this.localAvailableBitmap, 0.0f, 0.0f, null);
        canvas.restore();
        this.localAvailableBitmap = null;
    }

    private void drawMask(Canvas renderCanvas) {
        this.localMaskBitmap = this.getSourceMaskBitmap();
        if (this.localMaskBitmap == null) {
            return;
        }
        renderCanvas.save();
        renderCanvas.clipRect(this.maskOffsetX, 0, this.maskOffsetX + this.localMaskBitmap.getWidth(), this.getHeight());
        super.dispatchDraw(renderCanvas);
        renderCanvas.drawBitmap(this.localMaskBitmap, (float)this.maskOffsetX, 0.0f, this.maskPaint);
        renderCanvas.restore();
        this.localMaskBitmap = null;
    }

    private void resetShimmering() {
        if (this.maskAnimator != null) {
            this.maskAnimator.end();
            this.maskAnimator.removeAllUpdateListeners();
        }
        this.maskAnimator = null;
        this.isAnimationStarted = false;
        this.releaseBitMaps();
    }

    private void releaseBitMaps() {
        if (this.sourceMaskBitmap != null) {
            this.sourceMaskBitmap.recycle();
            this.sourceMaskBitmap = null;
        }
        if (this.destinationBitmap != null) {
            this.destinationBitmap.recycle();
            this.destinationBitmap = null;
        }
        this.canvasForRendering = null;
    }

    private Bitmap getDestinationBitmap() {
        if (this.destinationBitmap == null) {
            this.destinationBitmap = this.createBitmap(this.getWidth(), this.getHeight());
        }
        return this.destinationBitmap;
    }

    private Bitmap getSourceMaskBitmap() {
        if (this.sourceMaskBitmap != null) {
            return this.sourceMaskBitmap;
        }
        int width = this.maskRect.width();
        int height = this.getHeight();
        int edgeColor = this.reduceColorAlphaValueToZero(this.shimmerColor);
        LinearGradient gradient = new LinearGradient((float)(-this.maskRect.left), 0.0f, (float)(width + this.maskRect.left), 0.0f, new int[]{edgeColor, this.shimmerColor, this.shimmerColor, edgeColor}, new float[]{0.25f, 0.47f, 0.53f, 0.75f}, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setShader((Shader)gradient);
        this.sourceMaskBitmap = this.createBitmap(width, height);
        Canvas canvas = new Canvas(this.sourceMaskBitmap);
        canvas.rotate((float)this.shimmerAngle, (float)(width / 2), (float)(height / 2));
        canvas.drawRect((float)(-this.maskRect.left), (float)this.maskRect.top, (float)(width + this.maskRect.left), (float)this.maskRect.bottom, paint);
        return this.sourceMaskBitmap;
    }

    private Animator getShimmerAnimation() {
        if (this.maskAnimator != null) {
            return this.maskAnimator;
        }
        if (this.maskRect == null) {
            this.maskRect = this.calculateMaskRect();
        }
        int animationToX = this.getWidth();
        final int animationFromX = -animationToX;
        final int shimmerBitmapWidth = this.maskRect.width();
        final int shimmerAnimationFullLength = animationToX - animationFromX;
        this.maskAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.maskAnimator.setDuration((long)this.shimmerAnimationDuration);
        this.maskAnimator.setRepeatCount(-1);
        final float[] value = new float[1];
        this.maskAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                value[0] = ((Float)animation.getAnimatedValue()).floatValue();
                ShimmerLayout.this.maskOffsetX = (int)((float)animationFromX + (float)shimmerAnimationFullLength * value[0]);
                if (ShimmerLayout.this.maskOffsetX + shimmerBitmapWidth >= 0) {
                    ShimmerLayout.this.invalidate();
                }
            }
        });
        return this.maskAnimator;
    }

    private Bitmap createBitmap(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    private int getColor(int id) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getColor(id);
        }
        return this.getResources().getColor(id);
    }

    private void removeGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            this.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }

    private int reduceColorAlphaValueToZero(int actualColor) {
        return Color.argb((int)0, (int)Color.red((int)actualColor), (int)Color.green((int)actualColor), (int)Color.blue((int)actualColor));
    }

    private Rect calculateMaskRect() {
        int shimmerWidth = this.getWidth() / 2;
        if (this.shimmerAngle == 0) {
            return new Rect((int)((double)shimmerWidth * 0.25), 0, (int)((double)shimmerWidth * 0.75), this.getHeight());
        }
        int top = 0;
        int center = (int)((double)this.getHeight() * 0.5);
        int right = (int)((double)shimmerWidth * 0.75);
        Point originalTopRight = new Point(right, top);
        Point originalCenterRight = new Point(right, center);
        Point rotatedTopRight = this.rotatePoint(originalTopRight, this.shimmerAngle, shimmerWidth / 2, this.getHeight() / 2);
        Point rotatedCenterRight = this.rotatePoint(originalCenterRight, this.shimmerAngle, shimmerWidth / 2, this.getHeight() / 2);
        Point rotatedIntersection = this.getTopIntersection(rotatedTopRight, rotatedCenterRight);
        int halfMaskHeight = this.distanceBetween(rotatedCenterRight, rotatedIntersection);
        int paddingVertical = this.getHeight() / 2 - halfMaskHeight;
        int paddingHorizontal = shimmerWidth - rotatedIntersection.x;
        return new Rect(paddingHorizontal, paddingVertical, shimmerWidth - paddingHorizontal, this.getHeight() - paddingVertical);
    }

    private Point getTopIntersection(Point p1, Point p2) {
        double x1 = p1.x;
        double x2 = p2.x;
        double y1 = -p1.y;
        double y2 = -p2.y;
        double m = (y2 - y1) / (x2 - x1);
        double b = y1 - m * x1;
        int x = (int)((0.0 - b) / m);
        int y = 0;
        return new Point(x, y);
    }

    private Point rotatePoint(Point point, float degrees, float cx, float cy) {
        float[] pts = new float[]{point.x, point.y};
        Matrix transform = new Matrix();
        transform.setRotate(degrees, cx, cy);
        transform.mapPoints(pts);
        return new Point((int)pts[0], (int)pts[1]);
    }

    private int distanceBetween(Point p1, Point p2) {
        return (int)Math.ceil(Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0)));
    }
}

