/*
 * Decompiled with CFR 0.152.
 */
package io.supercharge.shimmerlayout;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.supercharge.shimmerlayout.R;

public class ShimmerLayout
extends FrameLayout {
    private Paint maskPaint;
    private ValueAnimator maskAnimator;
    private Bitmap localAvailableBitmap;
    private Bitmap localMaskBitmap;
    private Bitmap destinationBitmap;
    private Bitmap sourceMaskBitmap;
    private Canvas canvasForRendering;
    private int maskOffsetX;
    private boolean isAnimationStarted;
    private boolean autoStart;
    private int shimmerAnimationDuration;
    private int shimmerColor;

    public ShimmerLayout(Context context) {
        this(context, null);
    }

    public ShimmerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShimmerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.maskPaint = new Paint();
        this.maskPaint.setAntiAlias(true);
        this.maskPaint.setDither(true);
        this.maskPaint.setFilterBitmap(true);
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ShimmerLayout, 0, 0);
        try {
            this.shimmerAnimationDuration = a.getInteger(R.styleable.ShimmerLayout_shimmer_animation_duration, 1500);
            this.shimmerColor = a.getColor(R.styleable.ShimmerLayout_shimmer_color, this.getColor(R.color.shimmer_color));
            this.autoStart = a.getBoolean(R.styleable.ShimmerLayout_shimmer_auto_start, false);
        }
        finally {
            a.recycle();
        }
        if (this.autoStart && this.getVisibility() == 0) {
            this.startShimmerAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.resetShimmering();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.isAnimationStarted || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.dispatchDrawUsingBitmap(canvas);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            if (this.autoStart) {
                this.startShimmerAnimation();
            }
        } else {
            this.stopShimmerAnimation();
        }
    }

    public void startShimmerAnimation() {
        if (this.isAnimationStarted) {
            return;
        }
        if (this.getWidth() == 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ShimmerLayout.this.removeGlobalLayoutListener(this);
                    ShimmerLayout.this.startShimmerAnimation();
                }
            });
            return;
        }
        Animator animator = this.getShimmerAnimation();
        animator.start();
        this.isAnimationStarted = true;
    }

    public void stopShimmerAnimation() {
        this.resetShimmering();
    }

    public void setShimmerColor(int shimmerColor) {
        this.shimmerColor = shimmerColor;
        this.resetIfStarted();
    }

    public void setShimmerAnimationDuration(int durationMillis) {
        this.shimmerAnimationDuration = durationMillis;
        this.resetIfStarted();
    }

    private void resetIfStarted() {
        if (this.isAnimationStarted) {
            this.resetShimmering();
            this.startShimmerAnimation();
        }
    }

    private void dispatchDrawUsingBitmap(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.localAvailableBitmap = this.getDestinationBitmap();
        if (this.localAvailableBitmap == null) {
            return;
        }
        if (this.canvasForRendering == null) {
            this.canvasForRendering = new Canvas(this.localAvailableBitmap);
        }
        this.drawMask(this.canvasForRendering);
        canvas.save();
        canvas.clipRect(this.maskOffsetX, 0, this.maskOffsetX + this.getWidth() / 2, this.getHeight());
        canvas.drawBitmap(this.localAvailableBitmap, 0.0f, 0.0f, null);
        canvas.restore();
        this.localAvailableBitmap = null;
    }

    private void drawMask(Canvas renderCanvas) {
        this.localMaskBitmap = this.getSourceMaskBitmap();
        if (this.localMaskBitmap == null) {
            return;
        }
        renderCanvas.save();
        renderCanvas.clipRect(this.maskOffsetX, 0, this.maskOffsetX + this.localMaskBitmap.getWidth(), this.getHeight());
        super.dispatchDraw(renderCanvas);
        renderCanvas.drawBitmap(this.localMaskBitmap, (float)this.maskOffsetX, 0.0f, this.maskPaint);
        renderCanvas.restore();
        this.localMaskBitmap = null;
    }

    private void resetShimmering() {
        if (this.maskAnimator != null) {
            this.maskAnimator.end();
            this.maskAnimator.removeAllUpdateListeners();
        }
        this.maskAnimator = null;
        this.isAnimationStarted = false;
        this.releaseBitMaps();
    }

    private void releaseBitMaps() {
        if (this.sourceMaskBitmap != null) {
            this.sourceMaskBitmap.recycle();
            this.sourceMaskBitmap = null;
        }
        if (this.destinationBitmap != null) {
            this.destinationBitmap.recycle();
            this.destinationBitmap = null;
        }
        this.canvasForRendering = null;
    }

    private Bitmap getDestinationBitmap() {
        if (this.destinationBitmap == null) {
            this.destinationBitmap = this.createBitmap(this.getWidth(), this.getHeight());
        }
        return this.destinationBitmap;
    }

    private Bitmap getSourceMaskBitmap() {
        if (this.sourceMaskBitmap != null) {
            return this.sourceMaskBitmap;
        }
        int width = this.getWidth() / 2;
        int height = this.getHeight();
        this.sourceMaskBitmap = this.createBitmap(width, height);
        Canvas canvas = new Canvas(this.sourceMaskBitmap);
        LinearGradient gradient = new LinearGradient(0.0f, 0.0f, (float)width, 0.0f, new int[]{0, this.shimmerColor, this.shimmerColor, 0}, new float[]{0.25f, 0.5f, 0.5f, 0.75f}, Shader.TileMode.CLAMP);
        canvas.rotate(20.0f, (float)(width / 2), (float)(height / 2));
        Paint paint = new Paint();
        paint.setShader((Shader)gradient);
        int padding = (int)(Math.sqrt(2.0) * (double)Math.max(width, height)) / 2;
        canvas.drawRect(0.0f, (float)(-padding), (float)width, (float)(height + padding), paint);
        return this.sourceMaskBitmap;
    }

    private Animator getShimmerAnimation() {
        if (this.maskAnimator != null) {
            return this.maskAnimator;
        }
        int animationToX = this.getWidth();
        final int animationFromX = -animationToX;
        final int shimmerBitmapWidth = this.getWidth() / 2;
        final int shimmerAnimationFullLength = animationToX - animationFromX;
        this.maskAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.maskAnimator.setDuration((long)this.shimmerAnimationDuration);
        this.maskAnimator.setRepeatCount(-1);
        final float[] value = new float[1];
        this.maskAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                value[0] = ((Float)animation.getAnimatedValue()).floatValue();
                ShimmerLayout.this.maskOffsetX = (int)((float)animationFromX + (float)shimmerAnimationFullLength * value[0]);
                if (ShimmerLayout.this.maskOffsetX + shimmerBitmapWidth >= 0) {
                    ShimmerLayout.this.invalidate();
                }
            }
        });
        return this.maskAnimator;
    }

    private Bitmap createBitmap(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    private int getColor(int id) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getColor(id);
        }
        return this.getResources().getColor(id);
    }

    private void removeGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            this.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }
}

