/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.extension.ExtensionCollector;
import io.substrait.extension.SimpleExtension;
import io.substrait.function.NullableType;
import io.substrait.function.TypeExpressionVisitor;
import io.substrait.type.Type;
import io.substrait.type.proto.BaseProtoTypes;
import java.util.stream.Collectors;

abstract class BaseProtoConverter<T, I>
extends TypeExpressionVisitor.TypeExpressionThrowsVisitor<T, RuntimeException> {
    protected final ExtensionCollector extensionCollector;

    public abstract BaseProtoTypes<T, I> typeContainer(boolean var1);

    public BaseProtoConverter(ExtensionCollector extensionCollector, String unsupportedMessage) {
        super(unsupportedMessage);
        this.extensionCollector = extensionCollector;
    }

    public final BaseProtoTypes<T, I> typeContainer(NullableType literal) {
        return this.typeContainer(literal.nullable());
    }

    @Override
    public final T visit(Type.Bool expr) {
        return this.typeContainer((NullableType)expr).BOOLEAN;
    }

    @Override
    public final T visit(Type.I8 expr) {
        return this.typeContainer((NullableType)expr).I8;
    }

    @Override
    public final T visit(Type.I16 expr) {
        return this.typeContainer((NullableType)expr).I16;
    }

    @Override
    public final T visit(Type.I32 expr) {
        return this.typeContainer((NullableType)expr).I32;
    }

    @Override
    public final T visit(Type.I64 expr) {
        return this.typeContainer((NullableType)expr).I64;
    }

    @Override
    public final T visit(Type.FP32 expr) {
        return this.typeContainer((NullableType)expr).FP32;
    }

    @Override
    public final T visit(Type.FP64 expr) {
        return this.typeContainer((NullableType)expr).FP64;
    }

    @Override
    public final T visit(Type.Str expr) {
        return this.typeContainer((NullableType)expr).STRING;
    }

    @Override
    public final T visit(Type.Binary expr) {
        return this.typeContainer((NullableType)expr).BINARY;
    }

    @Override
    public final T visit(Type.Date expr) {
        return this.typeContainer((NullableType)expr).DATE;
    }

    @Override
    public final T visit(Type.Time expr) {
        return this.typeContainer((NullableType)expr).TIME;
    }

    @Override
    public final T visit(Type.TimestampTZ expr) {
        return this.typeContainer((NullableType)expr).TIMESTAMP_TZ;
    }

    @Override
    public final T visit(Type.Timestamp expr) {
        return this.typeContainer((NullableType)expr).TIMESTAMP;
    }

    @Override
    public final T visit(Type.IntervalYear expr) {
        return this.typeContainer((NullableType)expr).INTERVAL_YEAR;
    }

    @Override
    public final T visit(Type.IntervalDay expr) {
        return this.typeContainer(expr).intervalDay(expr.precision());
    }

    @Override
    public final T visit(Type.IntervalCompound expr) {
        return this.typeContainer(expr).intervalCompound(expr.precision());
    }

    @Override
    public final T visit(Type.UUID expr) {
        return this.typeContainer((NullableType)expr).UUID;
    }

    @Override
    public final T visit(Type.FixedChar expr) {
        return this.typeContainer(expr).fixedChar(expr.length());
    }

    @Override
    public final T visit(Type.VarChar expr) {
        return this.typeContainer(expr).varChar(expr.length());
    }

    @Override
    public final T visit(Type.FixedBinary expr) {
        return this.typeContainer(expr).fixedBinary(expr.length());
    }

    @Override
    public final T visit(Type.Decimal expr) {
        return this.typeContainer(expr).decimal(expr.scale(), expr.precision());
    }

    @Override
    public final T visit(Type.PrecisionTime expr) {
        return this.typeContainer(expr).precisionTime(expr.precision());
    }

    @Override
    public final T visit(Type.PrecisionTimestamp expr) {
        return this.typeContainer(expr).precisionTimestamp(expr.precision());
    }

    @Override
    public final T visit(Type.PrecisionTimestampTZ expr) {
        return this.typeContainer(expr).precisionTimestampTZ(expr.precision());
    }

    @Override
    public final T visit(Type.Struct expr) {
        return this.typeContainer(expr).struct(expr.fields().stream().map(t -> t.accept(this)).collect(Collectors.toList()));
    }

    @Override
    public final T visit(Type.ListType expr) {
        return this.typeContainer(expr).list(expr.elementType().accept(this));
    }

    @Override
    public final T visit(Type.Map expr) {
        return this.typeContainer(expr).map(expr.key().accept(this), expr.value().accept(this));
    }

    @Override
    public final T visit(Type.UserDefined expr) {
        int ref = this.extensionCollector.getTypeReference(SimpleExtension.TypeAnchor.of(expr.urn(), expr.name()));
        return this.typeContainer(expr).userDefined(ref, expr.typeParameters());
    }
}

